/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.wft.util;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.xmi.XMIResource;

public class RefIdCounter {
    private static final String copyright = "(c) Copyright IBM Corporation 2001.";
    private Map namesToIntegers = new HashMap();

    private int getCounter(String name) {
        Integer counter = (Integer)this.namesToIntegers.get(name);
        if (counter == null) {
            counter = new Integer(0);
        }
        counter = new Integer(counter + 1);
        this.namesToIntegers.put(name, counter);
        return counter;
    }

    private void setCounter(String name, int count) {
        this.namesToIntegers.put(name, new Integer(count));
    }

    public String setRefId(EObject object) {
        int originalCount;
        if (!(object instanceof ENamedElement)) {
            return null;
        }
        String name = ((ENamedElement)object).getName();
        if (name == null) {
            return null;
        }
        XMIResource res = (XMIResource)object.eResource();
        name = name + "_";
        int actualCount = originalCount = this.getCounter(name);
        String id = name + actualCount;
        if (res != null) {
            while (res.getIDToEObjectMap().get(id) != null) {
                id = name + ++actualCount;
            }
        }
        if (actualCount != originalCount) {
            this.setCounter(name, actualCount);
        }
        res.setID(object, id);
        return id;
    }
}

