/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.wft.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class WFTResourceDependencyRegister {
    private static final String copyright = "(c) Copyright IBM Corporation 2001.";
    protected HashMap dependencies = new HashMap();
    protected static WFTResourceDependencyRegister singleton;

    public void addDependency(String aUriString, String dependentUriString) {
        if (aUriString != null && dependentUriString != null) {
            ArrayList<String> list = (ArrayList<String>)this.dependencies.get(aUriString);
            if (list == null) {
                list = new ArrayList<String>();
                this.dependencies.put(aUriString, list);
            }
            list.add(dependentUriString);
        }
    }

    public List getDependencies(String aUriString) {
        List list;
        if (aUriString != null && (list = this.primGetDependencies(aUriString)) != null) {
            return list;
        }
        return Collections.unmodifiableList(new ArrayList());
    }

    protected String getKeyEndingWith(String aUriString) {
        Iterator it = this.dependencies.keySet().iterator();
        while (it.hasNext()) {
            String key = (String)it.next();
            if (!aUriString.endsWith(key)) continue;
            return key;
        }
        return null;
    }

    public List getRelativeDependencies(String aUriString) {
        List list = this.primGetDependencies(aUriString);
        if (list != null) {
            return list;
        }
        String registeredKey = this.getKeyEndingWith(aUriString);
        if (registeredKey == null) {
            return Collections.unmodifiableList(new ArrayList());
        }
        list = this.getDependencies(registeredKey);
        return this.makeRelative(list, aUriString, registeredKey);
    }

    protected List makeRelative(List aList, String aUriString, String registeredUriString) {
        if (aList.isEmpty() || aUriString.equals(registeredUriString)) {
            return aList;
        }
        ArrayList<String> relativeList = new ArrayList<String>(aList.size());
        int end = aUriString.length() - registeredUriString.length();
        String prefix = aUriString.substring(0, end);
        Iterator it = aList.iterator();
        while (it.hasNext()) {
            String next = (String)it.next();
            relativeList.add(prefix + next);
        }
        return relativeList;
    }

    protected List primGetDependencies(String aUriString) {
        if (aUriString != null) {
            return (List)this.dependencies.get(aUriString);
        }
        return null;
    }

    public void removeAllDependencies(String aUriString) {
        if (aUriString != null) {
            this.dependencies.remove(aUriString);
        }
    }

    public void removeDependency(String aUriString, String dependentUriString) {
        List list;
        if (aUriString != null && dependentUriString != null && (list = (List)this.dependencies.get(aUriString)) != null) {
            list.remove(dependentUriString);
        }
    }

    public static WFTResourceDependencyRegister singleton() {
        if (singleton == null) {
            singleton = new WFTResourceDependencyRegister();
        }
        return singleton;
    }
}

