/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jem.internal.proxy.initParser;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.jem.internal.proxy.initParser.EvaluationException;

public class MethodHelper {
    static final ArrayList sPrimitivesOrder = new ArrayList(6);
    static final int sCharPos;

    static {
        sPrimitivesOrder.add(Byte.TYPE);
        sPrimitivesOrder.add(Short.TYPE);
        sPrimitivesOrder.add(Integer.TYPE);
        sPrimitivesOrder.add(Long.TYPE);
        sPrimitivesOrder.add(Float.TYPE);
        sPrimitivesOrder.add(Double.TYPE);
        sCharPos = sPrimitivesOrder.indexOf(Short.TYPE);
    }

    public static boolean isAssignableFrom(Class type1, Class type2) {
        if (type1 == type2) {
            return true;
        }
        if (type1.isPrimitive()) {
            if (type2.isPrimitive()) {
                int type2Pos;
                if (type1 == Boolean.TYPE || type2 == Boolean.TYPE) {
                    return false;
                }
                int type1Pos = type1 != Character.TYPE ? sPrimitivesOrder.indexOf(type1) : sCharPos;
                int n = type2Pos = type2 != Character.TYPE ? sPrimitivesOrder.indexOf(type2) : sCharPos;
                return type1Pos > type2Pos;
            }
            return false;
        }
        if (type2 == Void.TYPE) {
            return true;
        }
        if (type2.isPrimitive()) {
            return false;
        }
        return type1.isAssignableFrom(type2);
    }

    public static boolean isAssignableFrom(Class[] types1, Class[] types2) {
        if (types1.length != types2.length) {
            return false;
        }
        int i = 0;
        while (i < types1.length) {
            if (!MethodHelper.isAssignableFrom(types1[i], types2[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private static int findMostCompatible(List methods, List parms) throws AmbiguousMethodException {
        int maxSpecific = -1;
        Class[][] parmsCopy = (Class[][])parms.toArray((T[])new Class[parms.size()][]);
        int size = parmsCopy.length;
        int i = 0;
        while (i < size) {
            block13: {
                Class<?> dclClassi = methods != null ? ((Method)methods.get(i)).getDeclaringClass() : null;
                Object[] parmsi = parmsCopy[i];
                int j = i + 1;
                while (j < size) {
                    if (parmsCopy[j] != null) {
                        boolean moreSpecificClass = true;
                        Class<?> dclClassj = null;
                        if (dclClassi != null) {
                            dclClassj = ((Method)methods.get(j)).getDeclaringClass();
                            moreSpecificClass = MethodHelper.isAssignableFrom(dclClassj, dclClassi);
                        }
                        Class[] parmsj = parmsCopy[j];
                        if (moreSpecificClass && MethodHelper.isAssignableFrom(parmsj, (Class[])parmsi)) {
                            parmsCopy[j] = null;
                        } else {
                            moreSpecificClass = true;
                            if (dclClassi != null) {
                                moreSpecificClass = MethodHelper.isAssignableFrom(dclClassi, dclClassj);
                            }
                            if (moreSpecificClass && MethodHelper.isAssignableFrom((Class[])parmsi, parmsj)) break block13;
                        }
                    }
                    ++j;
                }
                if (maxSpecific != -1) {
                    if (!Arrays.equals(parmsCopy[maxSpecific], parmsi)) {
                        throw new AmbiguousMethodException();
                    }
                    if (!Modifier.isAbstract(((Method)methods.get(i)).getModifiers())) {
                        maxSpecific = i;
                    }
                } else {
                    maxSpecific = i;
                }
            }
            ++i;
        }
        return maxSpecific;
    }

    /*
     * Unable to fully structure code
     */
    public static Method findCompatibleMethod(Class receiver, String methodName, Class[] arguments) throws EvaluationException {
        try {
            mthd = receiver.getMethod(methodName, arguments);
            return mthd;
        }
        catch (NoSuchMethodException exc) {
            mthds = receiver.getMethods();
            parmsList = new ArrayList<Class[]>(mthds.length);
            mthdsList = new ArrayList<Method>(mthds.length);
            i = 0;
            ** while (i < mthds.length)
        }
lbl-1000:
        // 1 sources

        {
            mthd = mthds[i];
            if (mthd.getName().equals(methodName) && MethodHelper.isAssignableFrom(parms = mthd.getParameterTypes(), arguments)) {
                parmsList.add(parms);
                mthdsList.add(mthd);
            }
            ++i;
            continue;
        }
lbl18:
        // 1 sources

        if (parmsList.size() == 0) {
            throw new EvaluationException(exc);
        }
        if (parmsList.size() == 1) {
            return (Method)mthdsList.get(0);
        }
        try {
            mostCompatible = MethodHelper.findMostCompatible(mthdsList, parmsList);
            return (Method)mthdsList.get(mostCompatible);
        }
        catch (AmbiguousMethodException v0) {
            throw new EvaluationException(new AmbiguousMethodException(methodName));
        }
    }

    /*
     * Unable to fully structure code
     */
    public static Constructor findCompatibleConstructor(Class receiver, Class[] arguments) throws EvaluationException {
        try {
            ctor = receiver.getDeclaredConstructor(arguments);
            ctor.setAccessible(true);
            return ctor;
        }
        catch (NoSuchMethodException exc) {
            ctors = receiver.getDeclaredConstructors();
            parmsList = new ArrayList<Class[]>(ctors.length);
            ctorsList = new ArrayList<Constructor>(ctors.length);
            i = 0;
            ** while (i < ctors.length)
        }
lbl-1000:
        // 1 sources

        {
            ctor = ctors[i];
            parms = ctor.getParameterTypes();
            if (MethodHelper.isAssignableFrom(parms, arguments)) {
                parmsList.add(parms);
                ctorsList.add(ctor);
            }
            ++i;
            continue;
        }
lbl20:
        // 1 sources

        if (parmsList.size() == 0) {
            throw new EvaluationException(exc);
        }
        if (parmsList.size() == 1) {
            ctor = (Constructor)ctorsList.get(0);
            ctor.setAccessible(true);
            return ctor;
        }
        try {
            mostCompatible = MethodHelper.findMostCompatible(null, parmsList);
            ctor = (Constructor)ctorsList.get(mostCompatible);
            ctor.setAccessible(true);
            return ctor;
        }
        catch (AmbiguousMethodException v0) {
            throw new EvaluationException(new AmbiguousMethodException(receiver.getName()));
        }
    }

    public static class AmbiguousMethodException
    extends Exception {
        public AmbiguousMethodException() {
        }

        public AmbiguousMethodException(String msg) {
            super(msg);
        }
    }
}

