/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.jfc.beaninfo;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import org.eclipse.ve.internal.jfc.beaninfo.AbstractBorderPropertyPage;
import org.eclipse.ve.internal.jfc.beaninfo.BorderEditor;
import org.eclipse.ve.internal.jfc.beaninfo.SubEditorJDialog;
import org.eclipse.ve.internal.jfc.beaninfo.VisualBeanInfoMessages;

public class CompoundBorderPropertyPage
extends AbstractBorderPropertyPage
implements ActionListener {
    private boolean built = false;
    private Border outsideBorder = null;
    private Border insideBorder = null;
    private BorderEditor outsideBorderEditor = null;
    private BorderEditor insideBorderEditor = null;
    private JPanel outsideBorderEditPanel = null;
    private JPanel insideBorderEditPanel = null;
    private JTextField outsideBorderField = null;
    private JTextField insideBorderField = null;
    private JButton outsideBorderButton = null;
    private JButton insideBorderButton = null;

    public CompoundBorderPropertyPage() {
        this.initialize();
    }

    public void initialize() {
        this.setName("CompoundBorderPropertyPage");
    }

    public void buildPropertyPage() {
        if (!this.built) {
            this.setBackground(SystemColor.control);
            Insets labelInsets = new Insets(0, 5, 5, 5);
            Insets compInsets = new Insets(0, 5, 10, 5);
            GridBagLayout gb = new GridBagLayout();
            GridBagConstraints c = new GridBagConstraints();
            c.weightx = 1.0;
            c.fill = 2;
            c.anchor = 18;
            c.gridx = 0;
            this.setLayout(gb);
            c.gridy = 0;
            c.insets = labelInsets;
            JLabel outsideBorderLabel = new JLabel(VisualBeanInfoMessages.getString("CompoundBorder.OutsideBorder"));
            this.add((Component)outsideBorderLabel, c);
            c.gridy = 1;
            c.insets = compInsets;
            this.add((Component)this.getOutsideBorderEditPanel(), c);
            JLabel insideBorderLabel = new JLabel(VisualBeanInfoMessages.getString("CompoundBorder.InsideBorder"));
            c.gridy = 2;
            c.insets = labelInsets;
            this.add((Component)insideBorderLabel, c);
            c.gridy = 3;
            c.insets = compInsets;
            this.add((Component)this.getInsideBorderEditPanel(), c);
            c.gridy = 4;
            c.weighty = 1.0;
            JPanel filler = new JPanel();
            filler.setBackground(SystemColor.control);
            this.add((Component)filler, c);
            this.updateBorder();
            this.built = true;
        }
    }

    public JPanel getOutsideBorderEditPanel() {
        if (this.outsideBorderEditPanel == null) {
            this.outsideBorderEditPanel = new JPanel();
            this.outsideBorderEditPanel.setBackground(SystemColor.control);
            GridBagLayout gb = new GridBagLayout();
            GridBagConstraints c = new GridBagConstraints();
            c.fill = 2;
            c.anchor = 18;
            c.gridy = 0;
            this.outsideBorderEditPanel.setLayout(gb);
            c.insets = new Insets(0, 0, 0, 5);
            c.weightx = 1.0;
            c.gridx = 0;
            this.outsideBorderField = new JTextField();
            this.outsideBorderField.setEditable(false);
            this.outsideBorderField.setBackground(SystemColor.control);
            gb.setConstraints(this.outsideBorderField, c);
            this.outsideBorderEditPanel.add(this.outsideBorderField);
            c.insets = new Insets(0, 0, 0, 0);
            c.weightx = 0.0;
            c.gridx = 1;
            this.outsideBorderButton = new JButton();
            this.outsideBorderButton.setText(VisualBeanInfoMessages.getString("CompoundBorder.ChooseButton"));
            this.outsideBorderButton.setMargin(new Insets(0, 5, 0, 5));
            this.outsideBorderButton.setBackground(SystemColor.control);
            this.outsideBorderButton.addActionListener(this);
            gb.setConstraints(this.outsideBorderButton, c);
            this.outsideBorderEditPanel.add(this.outsideBorderButton);
        }
        return this.outsideBorderEditPanel;
    }

    public JPanel getInsideBorderEditPanel() {
        if (this.insideBorderEditPanel == null) {
            this.insideBorderEditPanel = new JPanel();
            this.insideBorderEditPanel.setBackground(SystemColor.control);
            GridBagLayout gb = new GridBagLayout();
            GridBagConstraints c = new GridBagConstraints();
            c.fill = 2;
            c.anchor = 18;
            c.gridy = 0;
            this.insideBorderEditPanel.setLayout(gb);
            c.insets = new Insets(0, 0, 0, 5);
            c.weightx = 1.0;
            c.gridx = 0;
            this.insideBorderField = new JTextField();
            this.insideBorderField.setEditable(false);
            this.insideBorderField.setBackground(SystemColor.control);
            gb.setConstraints(this.insideBorderField, c);
            this.insideBorderEditPanel.add(this.insideBorderField);
            c.insets = new Insets(0, 0, 0, 0);
            c.weightx = 0.0;
            c.gridx = 1;
            this.insideBorderButton = new JButton();
            this.insideBorderButton.setText(VisualBeanInfoMessages.getString("CompoundBorder.ChooseButton"));
            this.insideBorderButton.setMargin(new Insets(0, 5, 0, 5));
            this.insideBorderButton.setBackground(SystemColor.control);
            this.insideBorderButton.addActionListener(this);
            gb.setConstraints(this.insideBorderButton, c);
            this.insideBorderEditPanel.add(this.insideBorderButton);
        }
        return this.insideBorderEditPanel;
    }

    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        int state = 1;
        if (source == this.outsideBorderButton) {
            state = SubEditorJDialog.showSubEditorJDialog(this.getTopLevelAncestor(), this.getOutsideBorderEditor().getCustomEditor());
        } else if (source == this.insideBorderButton) {
            state = SubEditorJDialog.showSubEditorJDialog(this.getTopLevelAncestor(), this.getInsideBorderEditor().getCustomEditor());
        }
        if (state == 0) {
            this.updateBorder();
        }
    }

    public BorderEditor getOutsideBorderEditor() {
        if (this.outsideBorderEditor == null) {
            this.outsideBorderEditor = new BorderEditor();
            this.outsideBorderEditor.setValue(this.outsideBorder);
        }
        return this.outsideBorderEditor;
    }

    public BorderEditor getInsideBorderEditor() {
        if (this.insideBorderEditor == null) {
            this.insideBorderEditor = new BorderEditor();
            this.insideBorderEditor.setValue(this.insideBorder);
        }
        return this.insideBorderEditor;
    }

    public void updateBorder() {
        this.outsideBorder = (Border)this.getOutsideBorderEditor().getValue();
        String text = this.getOutsideBorderEditor().getAsText();
        this.outsideBorderField.setText(text == null ? "" : text);
        this.insideBorder = (Border)this.getInsideBorderEditor().getValue();
        text = this.getInsideBorderEditor().getAsText();
        this.insideBorderField.setText(text == null ? "" : text);
        this.firePropertyChange("borderValueChanged", null, this.getBorderValue());
    }

    public boolean okToSetBorder(Border aBorder) {
        if (aBorder instanceof CompoundBorder) {
            CompoundBorder newBorder = (CompoundBorder)aBorder;
            this.outsideBorder = newBorder.getOutsideBorder();
            this.insideBorder = newBorder.getInsideBorder();
            this.getOutsideBorderEditor().setValue(this.outsideBorder);
            this.getInsideBorderEditor().setValue(this.insideBorder);
            return true;
        }
        return false;
    }

    public String getJavaInitializationString() {
        String outsideString = this.getOutsideBorderEditor().getValue() == null ? "null" : this.getOutsideBorderEditor().getJavaInitializationString();
        String insideString = this.getInsideBorderEditor().getValue() == null ? "null" : this.getInsideBorderEditor().getJavaInitializationString();
        return "javax.swing.BorderFactory.createCompoundBorder(" + outsideString + ", " + insideString + ")";
    }

    public Border getBorderValue() {
        return BorderFactory.createCompoundBorder(this.outsideBorder, this.insideBorder);
    }

    public String getDisplayName() {
        String outsideString = this.getOutsideBorderEditor().getValue() == null ? VisualBeanInfoMessages.getString("CompoundBorder.DisplayName.None") : this.getOutsideBorderEditor().getAsText();
        String insideString = this.getInsideBorderEditor().getValue() == null ? VisualBeanInfoMessages.getString("CompoundBorder.DisplayName.None") : this.getInsideBorderEditor().getAsText();
        return MessageFormat.format(VisualBeanInfoMessages.getString("CompoundBorder.DisplayName.Title(Outside,Inside)"), outsideString, insideString);
    }
}

