/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.jfc.beaninfo;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.SystemColor;
import java.text.MessageFormat;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.eclipse.ve.internal.jfc.beaninfo.AbstractBorderPropertyPage;
import org.eclipse.ve.internal.jfc.beaninfo.ColorPropertyEditor;
import org.eclipse.ve.internal.jfc.beaninfo.VisualBeanInfoMessages;

public class LineBorderPropertyPage
extends AbstractBorderPropertyPage
implements DocumentListener,
ChangeListener {
    private boolean built = false;
    private static final Color DEFAULT_COLOR = Color.gray;
    private JTextField widthField = null;
    private ColorPropertyEditor cpe = null;
    private int borderWidth = 5;

    public LineBorderPropertyPage() {
        this.initialize();
    }

    public void initialize() {
        Dimension size = new Dimension(445, 250);
        this.setMinimumSize(size);
        this.cpe = new ColorPropertyEditor();
        this.cpe.setValue(DEFAULT_COLOR);
        this.cpe.addChangeListener(this);
    }

    public void buildPropertyPage() {
        if (!this.built) {
            this.cpe.setPreviewEnabled(false);
            this.cpe.initialize();
            this.setName("LineBorderPropertypage");
            this.setLayout(new BorderLayout());
            this.setBackground(SystemColor.control);
            this.widthField = new JTextField(String.valueOf(this.getBorderWidth()));
            this.widthField.getDocument().addDocumentListener(this);
            JPanel p1 = new JPanel();
            p1.setBackground(SystemColor.control);
            p1.setLayout(new BorderLayout());
            p1.add((Component)new JLabel(VisualBeanInfoMessages.getString("LineBorder.Width.Label.Text")), "West");
            p1.add((Component)this.widthField, "Center");
            this.add((Component)p1, "North");
            JPanel p2 = new JPanel();
            p2.setLayout(new BorderLayout());
            p2.add((Component)new JLabel(VisualBeanInfoMessages.getString("LineBorder.Color.Label.text")), "North");
            p2.setBackground(SystemColor.control);
            p2.add((Component)this.cpe, "Center");
            this.add((Component)p2, "Center");
            this.cpe.autoSelectTab();
            this.built = true;
        }
    }

    public String getName() {
        return "LineBorderPropertyPage";
    }

    public String getDisplayName() {
        return MessageFormat.format(VisualBeanInfoMessages.getString("LineBorder.DisplayName(width,Color)"), new Integer(this.getBorderWidth()), this.cpe.getAsText());
    }

    public String getJavaInitializationString() {
        return "javax.swing.BorderFactory.createLineBorder(" + this.cpe.getJavaInitializationString() + "," + this.getBorderWidth() + ")";
    }

    public void handleException(Throwable exception) {
        exception.printStackTrace();
    }

    public int getBorderWidth() {
        return this.borderWidth;
    }

    public Color getBorderColor() {
        return (Color)this.cpe.getValue();
    }

    public Border getBorderValue() {
        Border aLineBorder = BorderFactory.createLineBorder(this.getBorderColor(), this.getBorderWidth());
        return aLineBorder;
    }

    public void stateChanged(ChangeEvent e) {
        this.firePropertyChange("borderValueChanged", null, this.getBorderValue());
    }

    public void updateHandle(DocumentEvent e) {
        if (e.getDocument() == this.widthField.getDocument()) {
            try {
                this.borderWidth = Integer.parseInt(this.widthField.getText());
                this.firePropertyChange("borderValueChanged", null, this.getBorderValue());
            }
            catch (NumberFormatException numberFormatException) {}
        }
    }

    public void insertUpdate(DocumentEvent e) {
        this.updateHandle(e);
    }

    public void removeUpdate(DocumentEvent e) {
        this.updateHandle(e);
    }

    public void changedUpdate(DocumentEvent e) {
        this.updateHandle(e);
    }

    public boolean okToSetBorder(Border aBorder) {
        if (aBorder instanceof LineBorder) {
            LineBorder fBorder = (LineBorder)aBorder;
            this.borderWidth = fBorder.getThickness();
            this.cpe.setValue(fBorder.getLineColor());
            return true;
        }
        return false;
    }
}

