/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.jfc.beaninfo;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.eclipse.ve.internal.jfc.beaninfo.CountryCellRenderer;
import org.eclipse.ve.internal.jfc.beaninfo.LanguageCellRenderer;
import org.eclipse.ve.internal.jfc.beaninfo.LocaleCountry;
import org.eclipse.ve.internal.jfc.beaninfo.LocaleLanguage;
import org.eclipse.ve.internal.jfc.beaninfo.LocaleVariant;
import org.eclipse.ve.internal.jfc.beaninfo.VariantCellRenderer;
import org.eclipse.ve.internal.jfc.beaninfo.VisualBeanInfoMessages;

public class LocalePropertyEditor
extends JPanel
implements ListSelectionListener,
PropertyChangeListener {
    private Locale fLocaleValue = null;
    private LocaleLanguage[] fLocaleLanguages = null;
    private LocaleCountry[] fLocaleCountries = null;
    private LocaleVariant[] fLocaleVariants = null;
    private JLabel languageLabel = new JLabel(VisualBeanInfoMessages.getString("Locale.Language"));
    private JLabel countryLabel = new JLabel(VisualBeanInfoMessages.getString("Locale.Country"));
    private JLabel variantLabel = new JLabel(VisualBeanInfoMessages.getString("Locale.Variant"));
    private JTextField localeField = new JTextField();
    private JList languageList = null;
    private JScrollPane languagePane = null;
    private JList countryList = null;
    private JScrollPane countryPane = null;
    private JList variantList = null;
    private JScrollPane variantPane = null;
    protected transient PropertyChangeSupport fPropertyChange = new PropertyChangeSupport(this);

    public LocalePropertyEditor() {
        this.initialize();
    }

    public LocalePropertyEditor(Locale locale) {
        this.initialize();
        this.setLocaleValue(locale);
    }

    private void createLocaleValues() {
        if (this.fLocaleLanguages != null) {
            return;
        }
        Locale[] locales = Locale.getAvailableLocales();
        int count = locales.length;
        Vector<LocaleLanguage> myLocales = new Vector<LocaleLanguage>();
        int i = 0;
        while (i < count) {
            Locale fLocale = locales[i];
            LocaleVariant fVariant = new LocaleVariant();
            fVariant.setID(fLocale.getVariant());
            fVariant.setName(fLocale.getDisplayVariant());
            LocaleCountry fCountry = new LocaleCountry();
            fCountry.setID(fLocale.getCountry());
            fCountry.setName(fLocale.getDisplayCountry());
            fCountry.addVariant(fVariant);
            boolean isDuplication = false;
            int j = 0;
            while (j < myLocales.size()) {
                if (((LocaleLanguage)myLocales.elementAt(j)).getID() == fLocale.getLanguage()) {
                    ((LocaleLanguage)myLocales.elementAt(j)).addCountry(fCountry);
                    isDuplication = true;
                }
                ++j;
            }
            if (!isDuplication) {
                LocaleLanguage fLanguage = new LocaleLanguage();
                fLanguage.setID(fLocale.getLanguage());
                fLanguage.setName(fLocale.getDisplayLanguage());
                fLanguage.addCountry(fCountry);
                myLocales.addElement(fLanguage);
            }
            ++i;
        }
        int fSize = myLocales.size();
        this.fLocaleLanguages = new LocaleLanguage[fSize];
        Enumeration enumeration = myLocales.elements();
        int i2 = 0;
        while (i2 < fSize && enumeration.hasMoreElements()) {
            this.fLocaleLanguages[i2] = (LocaleLanguage)enumeration.nextElement();
            ++i2;
        }
        this.sortLocaleLanguages();
    }

    public void sortLocaleLanguages() {
        int i = 0;
        while (i < this.fLocaleLanguages.length) {
            String s = this.fLocaleLanguages[i].getName();
            int min = i;
            if (s != null && !s.equals(" ")) {
                int j = i;
                while (j < this.fLocaleLanguages.length) {
                    String newString = this.fLocaleLanguages[j].getName();
                    if (newString.compareTo(s) < 0) {
                        min = j;
                        s = this.fLocaleLanguages[min].getName();
                    }
                    ++j;
                }
            }
            LocaleLanguage swap = this.fLocaleLanguages[i];
            this.fLocaleLanguages[i] = this.fLocaleLanguages[min];
            this.fLocaleLanguages[min] = swap;
            ++i;
        }
    }

    private JList getLanguageList() {
        if (this.languageList == null) {
            try {
                this.languageList = new JList();
                this.languageList.setName("LanguageList");
                DefaultListModel<LocaleLanguage> languageModel = new DefaultListModel<LocaleLanguage>();
                this.languageList.setModel(languageModel);
                int i = 0;
                while (i < this.fLocaleLanguages.length) {
                    languageModel.addElement(this.fLocaleLanguages[i]);
                    ++i;
                }
                this.languageList.setSelectionMode(0);
                String[] languageNames = new String[this.fLocaleLanguages.length];
                int i2 = 0;
                while (i2 < this.fLocaleLanguages.length) {
                    languageNames[i2] = this.fLocaleLanguages[i2].getName();
                    ++i2;
                }
                this.languageList.setCellRenderer(new LanguageCellRenderer(languageNames));
                this.languageList.addListSelectionListener(this);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.languageList;
    }

    private JScrollPane getLanguagePane() {
        if (this.languagePane == null) {
            this.languagePane = new JScrollPane(this.getLanguageList());
            this.languagePane.setBackground(SystemColor.control);
        }
        return this.languagePane;
    }

    private JList getCountryList() {
        if (this.countryList == null) {
            try {
                this.countryList = new JList();
                this.countryList.setName("CountryList");
                this.countryList.setSelectionMode(0);
                this.countryList.addListSelectionListener(this);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.countryList;
    }

    private JScrollPane getCountryPane() {
        if (this.countryPane == null) {
            this.countryPane = new JScrollPane(this.getCountryList());
            this.countryPane.setBackground(SystemColor.control);
        }
        return this.countryPane;
    }

    private JList getVariantList() {
        if (this.variantList == null) {
            try {
                this.variantList = new JList();
                this.variantList.setName("LanguageList");
                this.variantList.setSelectionMode(0);
                this.variantList.addListSelectionListener(this);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.variantList;
    }

    private JScrollPane getVariantPane() {
        if (this.variantPane == null) {
            this.variantPane = new JScrollPane(this.getVariantList());
        }
        return this.variantPane;
    }

    public void initialize() {
        this.createLocaleValues();
        this.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), VisualBeanInfoMessages.getString("Locale.TitleBorder")));
        this.setName("LocalePropertyEditor");
        this.setBackground(SystemColor.control);
        this.setLayout(new GridBagLayout());
        this.languageLabel.setBackground(SystemColor.control);
        this.countryLabel.setBackground(SystemColor.control);
        this.variantLabel.setBackground(SystemColor.control);
        GridBagConstraints constraintsLanguageLabel = new GridBagConstraints();
        constraintsLanguageLabel.gridx = 0;
        constraintsLanguageLabel.gridy = 0;
        constraintsLanguageLabel.gridwidth = 1;
        constraintsLanguageLabel.gridheight = 1;
        constraintsLanguageLabel.fill = 2;
        constraintsLanguageLabel.insets = new Insets(2, 2, 2, 2);
        constraintsLanguageLabel.weightx = 2.0;
        constraintsLanguageLabel.weighty = 1.0;
        this.add((Component)this.languageLabel, constraintsLanguageLabel);
        GridBagConstraints constraintsCountryLabel = new GridBagConstraints();
        constraintsCountryLabel.gridx = 1;
        constraintsCountryLabel.gridy = 0;
        constraintsCountryLabel.gridwidth = 1;
        constraintsCountryLabel.gridheight = 1;
        constraintsCountryLabel.fill = 2;
        constraintsCountryLabel.insets = new Insets(2, 2, 2, 2);
        constraintsCountryLabel.weightx = 2.0;
        constraintsCountryLabel.weighty = 1.0;
        this.add((Component)this.countryLabel, constraintsCountryLabel);
        GridBagConstraints constraintsVariantLabel = new GridBagConstraints();
        constraintsVariantLabel.gridx = 2;
        constraintsVariantLabel.gridy = 0;
        constraintsVariantLabel.gridwidth = 1;
        constraintsVariantLabel.gridheight = 1;
        constraintsVariantLabel.fill = 2;
        constraintsVariantLabel.insets = new Insets(2, 2, 2, 2);
        constraintsVariantLabel.weightx = 2.0;
        constraintsVariantLabel.weighty = 1.0;
        this.add((Component)this.variantLabel, constraintsVariantLabel);
        GridBagConstraints constraintsLanguagePane = new GridBagConstraints();
        constraintsLanguagePane.gridx = 0;
        constraintsLanguagePane.gridy = 1;
        constraintsLanguagePane.gridwidth = 1;
        constraintsLanguagePane.gridheight = 1;
        constraintsLanguagePane.fill = 1;
        constraintsLanguagePane.insets = new Insets(2, 2, 2, 2);
        constraintsLanguagePane.weightx = 2.0;
        constraintsLanguagePane.weighty = 4.0;
        this.add((Component)this.getLanguagePane(), constraintsLanguagePane);
        GridBagConstraints constraintsCountryPane = new GridBagConstraints();
        constraintsCountryPane.gridx = 1;
        constraintsCountryPane.gridy = 1;
        constraintsCountryPane.gridwidth = 1;
        constraintsCountryPane.gridheight = 1;
        constraintsCountryPane.fill = 1;
        constraintsCountryPane.insets = new Insets(2, 2, 2, 2);
        constraintsCountryPane.weightx = 2.0;
        constraintsCountryPane.weighty = 4.0;
        this.add((Component)this.getCountryPane(), constraintsCountryPane);
        GridBagConstraints constraintsVariantPane = new GridBagConstraints();
        constraintsVariantPane.gridx = 2;
        constraintsVariantPane.gridy = 1;
        constraintsVariantPane.gridwidth = 1;
        constraintsVariantPane.gridheight = 1;
        constraintsVariantPane.fill = 1;
        constraintsVariantPane.insets = new Insets(2, 2, 2, 2);
        constraintsVariantPane.weightx = 2.0;
        constraintsVariantPane.weighty = 4.0;
        this.add((Component)this.getVariantPane(), constraintsVariantPane);
        GridBagConstraints constraintsLocaleField = new GridBagConstraints();
        constraintsLocaleField.gridx = 0;
        constraintsLocaleField.gridy = 2;
        constraintsLocaleField.gridwidth = 1;
        constraintsLocaleField.gridheight = 1;
        constraintsLocaleField.fill = 2;
        constraintsLocaleField.insets = new Insets(2, 2, 2, 2);
        constraintsLocaleField.weightx = 2.0;
        constraintsLocaleField.weighty = 1.0;
        this.add((Component)this.localeField, constraintsLocaleField);
        this.localeField.setBackground(SystemColor.control);
        this.localeField.setEditable(false);
    }

    public void actionPerformed(ActionEvent e) {
    }

    public String getLocaleInitializationString() {
        return "new java.util.Locale(\"" + this.fLocaleValue.getLanguage() + "\", \"" + this.fLocaleValue.getCountry() + "\", \"" + this.fLocaleValue.getVariant() + "\")";
    }

    public Locale getLocaleValue() {
        return this.fLocaleValue;
    }

    public void setLocaleValue(Locale locale) {
        String s;
        this.fLocaleValue = locale;
        if (this.fLocaleLanguages != null) {
            int languageIndex = 0;
            while (languageIndex < this.fLocaleLanguages.length) {
                if (this.fLocaleLanguages[languageIndex].getName() == this.fLocaleValue.getDisplayLanguage()) {
                    this.getLanguageList().setSelectedIndex(languageIndex);
                }
                ++languageIndex;
            }
        }
        if (this.fLocaleCountries != null) {
            int countryIndex = 0;
            while (countryIndex < this.fLocaleCountries.length) {
                s = this.fLocaleCountries[countryIndex].getName();
                if (s != null && !s.equals(" ") && s.equals(locale.getDisplayCountry())) {
                    this.getCountryList().setSelectedIndex(countryIndex);
                    this.getCountryList().ensureIndexIsVisible(countryIndex);
                }
                ++countryIndex;
            }
        }
        if (this.fLocaleVariants != null) {
            int variantIndex = 0;
            while (variantIndex < this.fLocaleVariants.length) {
                s = this.fLocaleVariants[variantIndex].getName();
                if (s != null && !s.equals(" ") && s.equals(locale.getDisplayVariant())) {
                    this.getVariantList().setSelectedIndex(variantIndex);
                    this.getVariantList().ensureIndexIsVisible(variantIndex);
                }
                ++variantIndex;
            }
        }
        this.setLocaleField(locale);
    }

    public void setLocaleField(Locale locale) {
        this.localeField.setText(locale.toString());
    }

    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        if (this.fPropertyChange == null) {
            this.fPropertyChange = new PropertyChangeSupport(this);
        }
        this.fPropertyChange.firePropertyChange(propertyName, oldValue, newValue);
    }

    public void valueChanged(ListSelectionEvent e) {
        LocaleCountry selectedCountry;
        int selectedCountryIndex;
        int i;
        LocaleLanguage selectedLanguage;
        int selectedLanguageIndex;
        String selectedLanguageID = "";
        String selectedCountryID = "";
        String selectedVariantID = "";
        if (e.getSource() == this.getLanguageList() && (selectedLanguageIndex = this.getLanguageList().getSelectedIndex()) >= 0) {
            selectedLanguage = this.fLocaleLanguages[selectedLanguageIndex];
            selectedLanguageID = selectedLanguage.getID();
            this.fLocaleCountries = selectedLanguage.getCountries();
            int countryCount = this.fLocaleCountries.length;
            String[] countryNames = new String[countryCount];
            DefaultListModel<String> countryModel = new DefaultListModel<String>();
            this.getCountryList().setModel(countryModel);
            i = 0;
            while (i < countryCount) {
                if (this.fLocaleCountries[i].getName() != null && !this.fLocaleCountries[i].getName().equals(" ")) {
                    countryNames[i] = this.fLocaleCountries[i].getName();
                    countryModel.addElement(countryNames[i]);
                }
                ++i;
            }
            this.getCountryList().setCellRenderer(new CountryCellRenderer(countryNames));
            this.getVariantList().setModel(new DefaultListModel());
        }
        if (e.getSource() == this.getCountryList()) {
            selectedLanguageIndex = this.getLanguageList().getSelectedIndex();
            if (selectedLanguageIndex >= 0) {
                selectedLanguage = this.fLocaleLanguages[selectedLanguageIndex];
                selectedLanguageID = selectedLanguage.getID();
            }
            if ((selectedCountryIndex = this.getCountryList().getSelectedIndex()) >= 0) {
                selectedCountry = this.fLocaleCountries[selectedCountryIndex];
                selectedCountryID = selectedCountry.getID();
                this.fLocaleVariants = selectedCountry.getVariants();
                int variantCount = this.fLocaleVariants.length;
                String[] variantNames = new String[variantCount];
                DefaultListModel<String> variantModel = new DefaultListModel<String>();
                this.getVariantList().setModel(variantModel);
                i = 0;
                while (i < variantCount) {
                    if (this.fLocaleVariants[i].getName() != null && !this.fLocaleVariants[i].getName().equals(" ")) {
                        variantNames[i] = this.fLocaleVariants[i].getName();
                        variantModel.addElement(variantNames[i]);
                    }
                    ++i;
                }
                this.getVariantList().setCellRenderer(new VariantCellRenderer(variantNames));
            }
        }
        if (e.getSource() == this.getVariantList()) {
            int selectedVariantIndex;
            selectedLanguageIndex = this.getLanguageList().getSelectedIndex();
            if (selectedLanguageIndex >= 0) {
                selectedLanguage = this.fLocaleLanguages[selectedLanguageIndex];
                selectedLanguageID = selectedLanguage.getID();
            }
            if ((selectedCountryIndex = this.getCountryList().getSelectedIndex()) >= 0) {
                selectedCountry = this.fLocaleCountries[selectedCountryIndex];
                selectedCountryID = selectedCountry.getID();
            }
            if ((selectedVariantIndex = this.getVariantList().getSelectedIndex()) >= 0) {
                LocaleVariant selectedVariant = this.fLocaleVariants[selectedVariantIndex];
                selectedVariantID = selectedVariant.getID();
            }
        }
        this.fLocaleValue = new Locale(selectedLanguageID, selectedCountryID, selectedVariantID);
        this.setLocaleField(this.fLocaleValue);
        this.firePropertyChange("localeValue", null, this.getLocaleValue());
    }

    public void propertyChange(PropertyChangeEvent e) {
        if (e.getPropertyName().equals("localeValue")) {
            this.setLocaleField(this.fLocaleValue);
        }
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener listener) {
        this.fPropertyChange.addPropertyChangeListener(listener);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener listener) {
        this.fPropertyChange.removePropertyChangeListener(listener);
    }

    private void handleException(Throwable exc) {
    }

    public Dimension getPreferredSize() {
        return new Dimension(450, 250);
    }
}

