/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.jfc.beaninfo;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.SystemColor;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.border.MatteBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.eclipse.ve.internal.jfc.beaninfo.AbstractBorderPropertyPage;
import org.eclipse.ve.internal.jfc.beaninfo.ColorCellRenderer;
import org.eclipse.ve.internal.jfc.beaninfo.VisualBeanInfoMessages;

public class MatteBorderPropertyPage
extends AbstractBorderPropertyPage
implements DocumentListener,
ListSelectionListener {
    private static ResourceBundle resabtedit = ResourceBundle.getBundle("org.eclipse.ve.internal.jfc.beaninfo.vceedit");
    private boolean built = false;
    public static String[] colorNames = new String[]{resabtedit.getString("black"), resabtedit.getString("blue"), resabtedit.getString("cyan"), resabtedit.getString("darkGray"), resabtedit.getString("gray"), resabtedit.getString("green"), resabtedit.getString("lightGray"), resabtedit.getString("magenta"), resabtedit.getString("orange"), resabtedit.getString("pink"), resabtedit.getString("red"), resabtedit.getString("white"), resabtedit.getString("yellow")};
    public static Color[] colorValues = new Color[]{Color.black, Color.blue, Color.cyan, Color.darkGray, Color.gray, Color.green, Color.lightGray, Color.magenta, Color.orange, Color.pink, Color.red, Color.white, Color.yellow};
    public static String[] initStrings = new String[]{"black", "blue", "cyan", "darkGray", "gray", "green", "lightGray", "magenta", "orange", "pink", "red", "white", "yellow"};
    private int top = 5;
    private int left = 5;
    private int bottom = 5;
    private int right = 5;
    private Color color = colorValues[0];
    private JTextField topField = null;
    private JTextField leftField = null;
    private JTextField bottomField = null;
    private JTextField rightField = null;
    private JList colorList = null;
    private JScrollPane colorPane = null;

    public MatteBorderPropertyPage() {
        this.initialize();
    }

    public String getName() {
        return "MatteBorderPropertyPage";
    }

    public String getDisplayName() {
        String colorString = colorNames[this.getIndex(this.color)];
        return MessageFormat.format(VisualBeanInfoMessages.getString("MatteBorder.Matte(Color,top,left,bottom,right)"), colorString, new Integer(this.getTop()), new Integer(this.getLeft()), new Integer(this.getBottom()), new Integer(this.getRight()));
    }

    public int getIndex(Color c) {
        int index = -1;
        int i = 0;
        while (i < colorValues.length) {
            if (colorValues[i].equals(c)) {
                index = i;
                break;
            }
            ++i;
        }
        return index;
    }

    public JList getColorList() {
        if (this.colorList == null) {
            try {
                this.colorList = new JList<Color>(colorValues);
                this.colorList.setCellRenderer(new ColorCellRenderer(colorNames, colorValues));
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
        return this.colorList;
    }

    public JScrollPane getColorPane() {
        if (this.colorPane == null) {
            try {
                this.colorPane = new JScrollPane(this.getColorList());
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
        return this.colorPane;
    }

    public void initialize() {
        this.setName("MatteBorderPropertyPage");
    }

    public void buildPropertyPage() {
        if (!this.built) {
            this.setBackground(SystemColor.control);
            this.setLayout(new BorderLayout());
            JPanel p1 = new JPanel();
            p1.setBackground(SystemColor.control);
            p1.setLayout(new GridLayout(4, 2, 0, 0));
            this.topField = new JTextField(String.valueOf(this.top));
            this.leftField = new JTextField(String.valueOf(this.left));
            this.bottomField = new JTextField(String.valueOf(this.bottom));
            this.rightField = new JTextField(String.valueOf(this.right));
            p1.add(new JLabel(VisualBeanInfoMessages.getString("Top")));
            p1.add(this.topField);
            p1.add(new JLabel(VisualBeanInfoMessages.getString("Left")));
            p1.add(this.leftField);
            p1.add(new JLabel(VisualBeanInfoMessages.getString("Bottom")));
            p1.add(this.bottomField);
            p1.add(new JLabel(VisualBeanInfoMessages.getString("Right")));
            p1.add(this.rightField);
            this.add((Component)p1, "North");
            this.topField.getDocument().addDocumentListener(this);
            this.leftField.getDocument().addDocumentListener(this);
            this.bottomField.getDocument().addDocumentListener(this);
            this.rightField.getDocument().addDocumentListener(this);
            JPanel p2 = new JPanel();
            p2.setLayout(new BorderLayout());
            p2.setBackground(SystemColor.control);
            p2.add((Component)new JLabel(VisualBeanInfoMessages.getString("MatteBorder.BorderColor")), "North");
            p2.add((Component)this.getColorPane(), "Center");
            this.add((Component)p2, "Center");
            this.getColorList().setSelectedIndex(this.getIndex(this.color));
            this.getColorList().addListSelectionListener(this);
            this.built = true;
        }
    }

    protected int getIntValue(JTextField aTextField) {
        try {
            return Integer.parseInt(aTextField.getText());
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    public int getTop() {
        return this.top;
    }

    public int getLeft() {
        return this.left;
    }

    public int getBottom() {
        return this.bottom;
    }

    public int getRight() {
        return this.right;
    }

    public Color getColor() {
        return this.color;
    }

    public Border getBorderValue() {
        MatteBorder aBorder = BorderFactory.createMatteBorder(this.getTop(), this.getLeft(), this.getBottom(), this.getRight(), this.getColor());
        return aBorder;
    }

    public void valueChanged(ListSelectionEvent e) {
        if (e.getSource() == this.getColorList()) {
            int i = this.getColorList().getSelectedIndex();
            this.color = i >= 0 && i < colorNames.length ? colorValues[i] : colorValues[0];
            this.firePropertyChange("borderValueChanged", null, this.getBorderValue());
        }
    }

    public void updateHandle(DocumentEvent e) {
        if (e.getDocument() == this.topField.getDocument()) {
            this.top = this.getIntValue(this.topField);
        } else if (e.getDocument() == this.leftField.getDocument()) {
            this.left = this.getIntValue(this.leftField);
        } else if (e.getDocument() == this.bottomField.getDocument()) {
            this.bottom = this.getIntValue(this.bottomField);
        } else if (e.getDocument() == this.rightField.getDocument()) {
            this.right = this.getIntValue(this.rightField);
        } else {
            return;
        }
        this.firePropertyChange("borderValueChanged", null, this.getBorderValue());
    }

    public void insertUpdate(DocumentEvent e) {
        this.updateHandle(e);
    }

    public void removeUpdate(DocumentEvent e) {
        this.updateHandle(e);
    }

    public void changedUpdate(DocumentEvent e) {
        this.updateHandle(e);
    }

    public boolean okToSetBorder(Border aBorder) {
        if (aBorder instanceof MatteBorder) {
            MatteBorder fBorder = (MatteBorder)aBorder;
            Insets fInsets = fBorder.getBorderInsets();
            this.top = fInsets.top;
            this.left = fInsets.left;
            this.bottom = fInsets.bottom;
            this.right = fInsets.right;
            this.color = fBorder.getMatteColor();
            return true;
        }
        return false;
    }

    protected String getBorderColorJavaInitializationString() {
        int i = this.getIndex(this.color);
        if (i != -1) {
            return "java.awt.Color." + initStrings[i];
        }
        return "java.awt.Color." + initStrings[0];
    }

    public String getJavaInitializationString() {
        return "javax.swing.BorderFactory.createMatteBorder(" + this.getTop() + "," + this.getLeft() + "," + this.getBottom() + "," + this.getRight() + "," + this.getBorderColorJavaInitializationString() + ")";
    }
}

