/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jem.internal.core;

import org.eclipse.jem.internal.core.ConsoleLogger;

public abstract class MsgLogger {
    public static final int LOG_DEFAULT = -1;
    public static final int LOG_NONE = 7;
    public static final int LOG_SEVERE = 6;
    public static final int LOG_WARNING = 5;
    public static final int LOG_INFO = 4;
    public static final int LOG_CONFIG = 3;
    public static final int LOG_FINE = 2;
    public static final int LOG_FINER = 1;
    public static final int LOG_FINEST = 0;
    public static final int MIN_LOG = 0;
    private static MsgLogger DEFAULT_LOGGER;
    private boolean logEchoConsole = false;

    public static MsgLogger getLogger() {
        if (DEFAULT_LOGGER == null) {
            boolean echo = System.getProperty("logEchoConsole", "false").equalsIgnoreCase("true");
            int logLevel = Integer.getInteger("logLevel", 5);
            if (logLevel < 0 && logLevel > 7) {
                logLevel = 5;
            }
            DEFAULT_LOGGER = new ConsoleLogger(echo, logLevel);
        }
        return DEFAULT_LOGGER;
    }

    static void setDefaultLogger(MsgLogger logger) {
        DEFAULT_LOGGER = logger;
    }

    protected MsgLogger(boolean logEchoConsole) {
        this.logEchoConsole = logEchoConsole;
    }

    public final void log(Throwable e) {
        this.log(e, -1);
    }

    public final void log(Throwable e, int logLevel) {
        this.primLog(e, logLevel);
        if (this.logEchoConsole) {
            this.echoConsole(e);
        }
    }

    protected void echoConsole(Throwable e) {
        e.printStackTrace();
    }

    public final void log(Object object) {
        this.log(object, -1);
    }

    public final void log(Object object, int logLevel) {
        this.primLog(object, logLevel);
        if (this.logEchoConsole) {
            this.echoConsole(object);
        }
    }

    protected void echoConsole(Object object) {
        System.out.println(object.toString());
    }

    public final void log(boolean msg) {
        this.log(msg, -1);
    }

    public final void log(boolean msg, int logLevel) {
        this.primLog(msg, logLevel);
        if (this.logEchoConsole) {
            this.echoConsole(String.valueOf(msg));
        }
    }

    public final void log(char msg) {
        this.log(msg, -1);
    }

    public final void log(char msg, int logLevel) {
        this.primLog(msg, logLevel);
        if (this.logEchoConsole) {
            this.echoConsole(String.valueOf(msg));
        }
    }

    public final void log(byte msg) {
        this.log(msg, -1);
    }

    public final void log(byte msg, int logLevel) {
        this.primLog(msg, logLevel);
        if (this.logEchoConsole) {
            this.echoConsole(String.valueOf(msg));
        }
    }

    public final void write(short msg) {
        this.log(msg, -1);
    }

    public final void log(short msg, int logLevel) {
        this.primLog(msg, logLevel);
        if (this.logEchoConsole) {
            this.echoConsole(String.valueOf(msg));
        }
    }

    public final void log(int msg) {
        this.log(msg, -1);
    }

    public final void log(int msg, int logLevel) {
        this.primLog(msg, logLevel);
        if (this.logEchoConsole) {
            this.echoConsole(String.valueOf(msg));
        }
    }

    public final void log(long msg) {
        this.log(msg, -1);
    }

    public final void log(long msg, int logLevel) {
        this.primLog(msg, logLevel);
        if (this.logEchoConsole) {
            this.echoConsole(String.valueOf(msg));
        }
    }

    public final void log(float msg) {
        this.log(msg, -1);
    }

    public final void log(float msg, int logLevel) {
        this.primLog(msg, logLevel);
        if (this.logEchoConsole) {
            this.echoConsole(String.valueOf(msg));
        }
    }

    public final void log(double msg) {
        this.log(msg, -1);
    }

    public final void log(double msg, int logLevel) {
        this.primLog(msg, logLevel);
        if (this.logEchoConsole) {
            this.echoConsole(String.valueOf(msg));
        }
    }

    protected abstract void primLog(Object var1, int var2);

    protected abstract void primLog(Throwable var1, int var2);

    protected abstract void primLog(boolean var1, int var2);

    protected abstract void primLog(byte var1, int var2);

    protected abstract void primLog(char var1, int var2);

    protected abstract void primLog(double var1, int var3);

    protected abstract void primLog(float var1, int var2);

    protected abstract void primLog(int var1, int var2);

    protected abstract void primLog(long var1, int var3);

    protected abstract void primLog(short var1, int var2);

    public void setLogEchoConsole(boolean logEchoConsole) {
        this.logEchoConsole = logEchoConsole;
    }

    public boolean isLogEchoConsole() {
        return this.logEchoConsole;
    }
}

