/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jem.internal.java.adapters.jdk;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.xmi.XMIResource;
import org.eclipse.jem.internal.core.MsgLogger;
import org.eclipse.jem.internal.java.InheritanceCycleException;
import org.eclipse.jem.internal.java.JavaClass;
import org.eclipse.jem.internal.java.TypeKind;
import org.eclipse.jem.internal.java.adapters.IJavaClassAdaptor;
import org.eclipse.jem.internal.java.adapters.jdk.JDKAdaptor;
import org.eclipse.jem.internal.java.adapters.jdk.JavaJDKAdapterFactory;
import org.eclipse.jem.internal.java.adapters.nls.ResourceHandler;
import org.eclipse.jem.internal.java.impl.JavaClassImpl;

public class JavaClassJDKAdaptor
extends JDKAdaptor
implements IJavaClassAdaptor {
    protected Class sourceType = null;

    public JavaClassJDKAdaptor(Notifier target, JavaJDKAdapterFactory anAdapterFactory) {
        super(target, anAdapterFactory);
    }

    protected void addFields() {
        XMIResource resource = (XMIResource)this.getJavaClassTarget().eResource();
        EList targetFields = this.getJavaClassTarget().getFieldsGen();
        targetFields.clear();
        Field[] fields = new Field[]{};
        try {
            fields = this.getSourceType().getDeclaredFields();
        }
        catch (NoClassDefFoundError error) {
            System.out.println(ResourceHandler.getString("Could_Not_Reflect_Fields_ERROR_", new Object[]{this.getJavaClassTarget().getQualifiedName(), error.getMessage()}));
        }
        int i = 0;
        while (i < fields.length) {
            targetFields.add(this.createJavaField(fields[i], resource));
            ++i;
        }
    }

    protected void addMethods() {
        XMIResource resource = (XMIResource)this.getJavaClassTarget().eResource();
        EList targetMethods = this.getJavaClassTarget().getMethodsGen();
        targetMethods.clear();
        Method[] methods = new Method[]{};
        try {
            methods = this.getSourceType().getDeclaredMethods();
        }
        catch (NoClassDefFoundError error) {
            MsgLogger.getLogger().log(ResourceHandler.getString("Could_Not_Reflect_Methods_ERROR_", new Object[]{this.getJavaClassTarget().getQualifiedName(), error.toString()}), 5);
        }
        int i = 0;
        while (i < methods.length) {
            targetMethods.add(this.createJavaMethod(methods[i], resource));
            ++i;
        }
        Constructor[] ctors = new Constructor[]{};
        try {
            ctors = this.getSourceType().getDeclaredConstructors();
        }
        catch (NoClassDefFoundError error) {
            MsgLogger.getLogger().log(ResourceHandler.getString("Could_Not_Reflect_Constructors_ERROR_", new Object[]{this.getJavaClassTarget().getQualifiedName(), error.getMessage()}), 5);
        }
        int i2 = 0;
        while (i2 < ctors.length) {
            targetMethods.add(this.createJavaMethod(ctors[i2], resource));
            ++i2;
        }
    }

    protected boolean flushFields() {
        this.getJavaClassTarget().getFieldsGen().clear();
        return true;
    }

    protected boolean flushImplements() {
        this.getJavaClassTarget().getImplementsInterfacesGen().clear();
        return true;
    }

    protected boolean flushMethods() {
        this.getJavaClassTarget().getMethodsGen().clear();
        return true;
    }

    protected boolean flushInnerClasses() {
        this.getJavaClassTarget().getDeclaredClassesGen().clear();
        return true;
    }

    protected boolean flushModifiers() {
        JavaClass javaClassTarget = (JavaClass)this.getTarget();
        javaClassTarget.setAbstract(false);
        javaClassTarget.setFinal(false);
        javaClassTarget.setPublic(false);
        javaClassTarget.setKind(TypeKind.UNDEFINED_LITERAL);
        return true;
    }

    protected boolean flushReflectedValues(boolean clearCachedModelObject) {
        boolean result = this.flushModifiers();
        result &= this.flushSuper();
        result &= this.flushImplements();
        result &= this.flushMethods();
        result &= this.flushFields();
        return result &= this.flushInnerClasses();
    }

    protected void postFlushReflectedValuesIfNecessary(boolean isExisting) {
        this.getJavaClassTarget().setReflected(false);
        super.postFlushReflectedValuesIfNecessary(isExisting);
    }

    protected boolean flushSuper() {
        EList targetSupers = this.getJavaClassTarget().getESuperTypesGen();
        targetSupers.clear();
        return true;
    }

    protected JavaClassImpl getJavaClassTarget() {
        return (JavaClassImpl)this.getTarget();
    }

    public Object getReflectionSource() {
        return this.getSourceType();
    }

    protected Class getSourceType() {
        if (this.sourceType == null) {
            this.sourceType = this.getType((JavaClass)this.getTarget());
        }
        return this.sourceType;
    }

    public Object getValueIn(EObject object, EObject attribute) {
        return super.getValueIn(object, attribute);
    }

    public boolean isSourceTypeFromBinary() {
        return true;
    }

    public boolean reflectValues() {
        block5: {
            super.reflectValues();
            try {
                if (this.getSourceType() == null) break block5;
                this.setModifiers();
                this.setNaming();
                try {
                    this.setSuper();
                }
                catch (InheritanceCycleException e) {
                    MsgLogger.getLogger().log(e);
                }
                this.setImplements();
                this.addMethods();
                this.addFields();
                this.reflectInnerClasses();
                this.getAdapterFactory().registerReflection(this.getSourceType().getName(), this);
                Object var2_2 = null;
                this.sourceType = null;
                return true;
            }
            catch (Throwable throwable) {
                Object var2_4 = null;
                this.sourceType = null;
                throw throwable;
            }
        }
        Object var2_3 = null;
        this.sourceType = null;
        return false;
    }

    protected void reflectInnerClasses() {
        Class<?>[] innerClasses = this.getSourceType().getClasses();
        if (innerClasses.length != 0) {
            EList declaredClasses = this.getJavaClassTarget().getDeclaredClassesGen();
            ResourceSet set = this.getTargetResource().getResourceSet();
            int i = 0;
            while (i < innerClasses.length) {
                JavaClass inner = (JavaClass)JavaClassImpl.reflect(innerClasses[i].getName(), set);
                declaredClasses.add(inner);
                ++i;
            }
        }
    }

    protected void setImplements() {
        Class<?>[] interfaces = this.getSourceType().getInterfaces();
        JavaClassImpl javaClassTarget = (JavaClassImpl)this.getTarget();
        EList intList = javaClassTarget.getImplementsInterfacesGen();
        intList.clear();
        int i = 0;
        while (i < interfaces.length) {
            JavaClass ref = this.createJavaClassRef(interfaces[i].getName());
            intList.add(ref);
            ++i;
        }
    }

    protected void setModifiers() {
        JavaClass javaClassTarget = (JavaClass)this.getTarget();
        javaClassTarget.setAbstract(Modifier.isAbstract(this.getSourceType().getModifiers()));
        javaClassTarget.setFinal(Modifier.isFinal(this.getSourceType().getModifiers()));
        javaClassTarget.setPublic(Modifier.isPublic(this.getSourceType().getModifiers()));
        if (this.getSourceType().isInterface()) {
            javaClassTarget.setKind(TypeKind.INTERFACE_LITERAL);
        } else {
            javaClassTarget.setKind(TypeKind.CLASS_LITERAL);
        }
    }

    protected void setNaming() {
    }

    protected void setSuper() throws InheritanceCycleException {
        Class superClass = null;
        superClass = this.getSourceType().getSuperclass();
        if (superClass != null) {
            JavaClass javaClassTarget = (JavaClass)this.getTarget();
            javaClassTarget.setSupertype(this.createJavaClassRef(superClass.getName()));
        }
    }

    public boolean sourceTypeExists() {
        return this.getSourceType() != null;
    }
}

