/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jem.internal.java.impl;

import java.util.Collection;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.EClassImpl;
import org.eclipse.emf.ecore.impl.EClassifierImpl;
import org.eclipse.emf.ecore.impl.EModelElementImpl;
import org.eclipse.emf.ecore.impl.ENamedElementImpl;
import org.eclipse.emf.ecore.impl.EObjectImpl;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.jem.internal.java.JavaClass;
import org.eclipse.jem.internal.java.JavaDataType;
import org.eclipse.jem.internal.java.JavaRefPackage;
import org.eclipse.jem.internal.java.impl.JavaClassImpl;
import org.eclipse.jem.internal.java.instantiation.IInstantiationInstance;

public class JavaDataTypeImpl
extends EClassImpl
implements JavaDataType {
    static final String FALSE = "false";
    static final String DOUBLE_ZERO = "0.0";
    static final String FLOAT_ZERO = "0.0f";
    static final String CHAR_ZERO = "'0'";
    static final String ZERO = "0";
    static /* synthetic */ Class class$0;

    protected JavaDataTypeImpl() {
    }

    protected EClass eStaticClass() {
        return JavaRefPackage.eINSTANCE.getJavaDataType();
    }

    public String getDefaultValueString() {
        String typeName = this.getJavaName();
        if (typeName.equals(Boolean.TYPE.getName())) {
            return FALSE;
        }
        if (typeName.equals(Double.TYPE.getName())) {
            return DOUBLE_ZERO;
        }
        if (typeName.equals(Float.TYPE.getName())) {
            return FLOAT_ZERO;
        }
        if (typeName.equals(Character.TYPE.getName())) {
            return CHAR_ZERO;
        }
        return ZERO;
    }

    public String getJavaName() {
        return this.getName();
    }

    public JavaDataType getPrimitive() {
        return this;
    }

    public String getQualifiedName() {
        return this.getJavaName();
    }

    public JavaClass getWrapper() {
        String wrapperName = this.getWrapperQualifiedName();
        if (wrapperName != null) {
            return (JavaClass)JavaClassImpl.reflect(wrapperName, (EObject)this);
        }
        return null;
    }

    protected String getWrapperQualifiedName() {
        String myName = this.getJavaName();
        if (myName.equals("int")) {
            return "java.lang.Integer";
        }
        if (myName.equals("char")) {
            return "java.lang.Character";
        }
        if (myName.equals("boolean")) {
            return "java.lang.Boolean";
        }
        if (myName.equals("byte")) {
            return "java.lang.Byte";
        }
        if (myName.equals("short")) {
            return "java.lang.Short";
        }
        if (myName.equals("long")) {
            return "java.lang.Long";
        }
        if (myName.equals("float")) {
            return "java.lang.Float";
        }
        if (myName.equals("double")) {
            return "java.lang.Double";
        }
        return null;
    }

    public boolean isArray() {
        return false;
    }

    public boolean isAssignableFrom(EClassifier aClass) {
        return this == aClass;
    }

    public boolean isInstance(Object o) {
        return o instanceof IInstantiationInstance ? this.isAssignableFrom(((IInstantiationInstance)o).getJavaType()) : false;
    }

    public boolean isPrimitive() {
        return true;
    }

    public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
        if (featureID >= 0) {
            switch (this.eDerivedStructuralFeatureID(featureID, baseClass)) {
                case 0: {
                    return ((InternalEList)this.getEAnnotations()).basicAdd((Object)otherEnd, msgs);
                }
                case 5: {
                    if (((EObjectImpl)this).eContainer != null) {
                        msgs = this.eBasicRemoveFromContainer(msgs);
                    }
                    return this.eBasicSetContainer(otherEnd, 5, msgs);
                }
                case 9: {
                    return ((InternalEList)this.getEOperations()).basicAdd((Object)otherEnd, msgs);
                }
            }
            return this.eDynamicInverseAdd(otherEnd, featureID, baseClass, msgs);
        }
        if (((EObjectImpl)this).eContainer != null) {
            msgs = this.eBasicRemoveFromContainer(msgs);
        }
        return this.eBasicSetContainer(otherEnd, featureID, msgs);
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
        if (featureID >= 0) {
            switch (this.eDerivedStructuralFeatureID(featureID, baseClass)) {
                case 0: {
                    return ((InternalEList)this.getEAnnotations()).basicRemove((Object)otherEnd, msgs);
                }
                case 5: {
                    return this.eBasicSetContainer(null, 5, msgs);
                }
                case 9: {
                    return ((InternalEList)this.getEOperations()).basicRemove((Object)otherEnd, msgs);
                }
                case 12: {
                    return ((InternalEList)this.getEReferences()).basicRemove((Object)otherEnd, msgs);
                }
                case 13: {
                    return ((InternalEList)this.getEAttributes()).basicRemove((Object)otherEnd, msgs);
                }
            }
            return this.eDynamicInverseRemove(otherEnd, featureID, baseClass, msgs);
        }
        return this.eBasicSetContainer(null, featureID, msgs);
    }

    public NotificationChain eBasicRemoveFromContainer(NotificationChain msgs) {
        block6: {
            if (((EObjectImpl)this).eContainerFeatureID < 0) break block6;
            switch (((EObjectImpl)this).eContainerFeatureID) {
                case 5: {
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = class$0 = Class.forName("[Lorg.eclipse.emf.ecore.EPackage;").getComponentType();
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    return ((EObjectImpl)this).eContainer.eInverseRemove((InternalEObject)this, 5, (Class)clazz, msgs);
                }
            }
            return this.eDynamicBasicRemoveFromContainer(msgs);
        }
        return ((EObjectImpl)this).eContainer.eInverseRemove((InternalEObject)this, -1 - ((EObjectImpl)this).eContainerFeatureID, null, msgs);
    }

    public Object eGet(EStructuralFeature eFeature, boolean resolve) {
        switch (this.eDerivedStructuralFeatureID(eFeature)) {
            case 0: {
                return this.getEAnnotations();
            }
            case 1: {
                return this.getName();
            }
            case 2: {
                return this.getInstanceClassName();
            }
            case 3: {
                return this.getInstanceClass();
            }
            case 4: {
                return this.getDefaultValue();
            }
            case 5: {
                return this.getEPackage();
            }
            case 6: {
                return this.isAbstract() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 7: {
                return this.isInterface() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 8: {
                return this.getESuperTypes();
            }
            case 9: {
                return this.getEOperations();
            }
            case 10: {
                return this.getEAllAttributes();
            }
            case 11: {
                return this.getEAllReferences();
            }
            case 12: {
                return this.getEReferences();
            }
            case 13: {
                return this.getEAttributes();
            }
            case 14: {
                return this.getEAllContainments();
            }
            case 15: {
                return this.getEAllOperations();
            }
            case 16: {
                return this.getEAllStructuralFeatures();
            }
            case 17: {
                return this.getEAllSuperTypes();
            }
            case 18: {
                return this.getEIDAttribute();
            }
        }
        return this.eDynamicGet(eFeature, resolve);
    }

    public void eSet(EStructuralFeature eFeature, Object newValue) {
        switch (this.eDerivedStructuralFeatureID(eFeature)) {
            case 0: {
                this.getEAnnotations().clear();
                this.getEAnnotations().addAll((Collection)newValue);
                return;
            }
            case 1: {
                this.setName((String)newValue);
                return;
            }
            case 2: {
                this.setInstanceClassName((String)newValue);
                return;
            }
            case 6: {
                this.setAbstract((Boolean)newValue);
                return;
            }
            case 7: {
                this.setInterface((Boolean)newValue);
                return;
            }
            case 8: {
                this.getESuperTypes().clear();
                this.getESuperTypes().addAll((Collection)newValue);
                return;
            }
            case 9: {
                this.getEOperations().clear();
                this.getEOperations().addAll((Collection)newValue);
                return;
            }
            case 12: {
                this.getEReferences().clear();
                this.getEReferences().addAll((Collection)newValue);
                return;
            }
            case 13: {
                this.getEAttributes().clear();
                this.getEAttributes().addAll((Collection)newValue);
                return;
            }
        }
        this.eDynamicSet(eFeature, newValue);
    }

    public void eUnset(EStructuralFeature eFeature) {
        switch (this.eDerivedStructuralFeatureID(eFeature)) {
            case 0: {
                this.getEAnnotations().clear();
                return;
            }
            case 1: {
                this.setName(ENamedElementImpl.NAME_EDEFAULT);
                return;
            }
            case 2: {
                this.setInstanceClassName(EClassifierImpl.INSTANCE_CLASS_NAME_EDEFAULT);
                return;
            }
            case 6: {
                this.setAbstract(false);
                return;
            }
            case 7: {
                this.setInterface(false);
                return;
            }
            case 8: {
                this.getESuperTypes().clear();
                return;
            }
            case 9: {
                this.getEOperations().clear();
                return;
            }
            case 12: {
                this.getEReferences().clear();
                return;
            }
            case 13: {
                this.getEAttributes().clear();
                return;
            }
        }
        this.eDynamicUnset(eFeature);
    }

    public boolean eIsSet(EStructuralFeature eFeature) {
        switch (this.eDerivedStructuralFeatureID(eFeature)) {
            case 0: {
                return ((EModelElementImpl)this).eAnnotations != null && !((EModelElementImpl)this).eAnnotations.isEmpty();
            }
            case 1: {
                return ENamedElementImpl.NAME_EDEFAULT == null ? ((ENamedElementImpl)this).name != null : !ENamedElementImpl.NAME_EDEFAULT.equals(((ENamedElementImpl)this).name);
            }
            case 2: {
                return EClassifierImpl.INSTANCE_CLASS_NAME_EDEFAULT == null ? ((EClassifierImpl)this).instanceClassName != null : !EClassifierImpl.INSTANCE_CLASS_NAME_EDEFAULT.equals(((EClassifierImpl)this).instanceClassName);
            }
            case 3: {
                return this.getInstanceClass() != null;
            }
            case 4: {
                return this.getDefaultValue() != null;
            }
            case 5: {
                return this.getEPackage() != null;
            }
            case 6: {
                return this.abstract_;
            }
            case 7: {
                return this.interface_;
            }
            case 8: {
                return this.eSuperTypes != null && !this.eSuperTypes.isEmpty();
            }
            case 9: {
                return this.eOperations != null && !this.eOperations.isEmpty();
            }
            case 10: {
                return !this.getEAllAttributes().isEmpty();
            }
            case 11: {
                return !this.getEAllReferences().isEmpty();
            }
            case 12: {
                return this.eReferences != null && !this.eReferences.isEmpty();
            }
            case 13: {
                return this.eAttributes != null && !this.eAttributes.isEmpty();
            }
            case 14: {
                return !this.getEAllContainments().isEmpty();
            }
            case 15: {
                return !this.getEAllOperations().isEmpty();
            }
            case 16: {
                return !this.getEAllStructuralFeatures().isEmpty();
            }
            case 17: {
                return !this.getEAllSuperTypes().isEmpty();
            }
            case 18: {
                return this.getEIDAttribute() != null;
            }
        }
        return this.eDynamicIsSet(eFeature);
    }
}

