/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jem.internal.instantiation.base;

import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.impl.EObjectImpl;
import org.eclipse.jem.internal.instantiation.base.IJavaObjectInstance;
import org.eclipse.jem.internal.instantiation.base.JavaInstantiation;
import org.eclipse.jem.internal.java.JavaHelpers;

public class JavaObjectInstance
extends EObjectImpl
implements IJavaObjectInstance {
    public JavaHelpers getJavaType() {
        return (JavaHelpers)this.eClass();
    }

    public boolean isImplicit() {
        return this.isSetImplicit() ? (Boolean)this.eGet((EStructuralFeature)JavaInstantiation.getImplicitFeature(this)) : false;
    }

    public boolean isSetImplicit() {
        return this.eIsSet((EStructuralFeature)JavaInstantiation.getImplicitFeature(this));
    }

    public void setImplicit(boolean implicit) {
        this.eSet((EStructuralFeature)JavaInstantiation.getImplicitFeature(this), implicit ? Boolean.TRUE : Boolean.FALSE);
    }

    public String getInitializationString() {
        if (this.isSetInitializationString()) {
            return (String)this.eGet((EStructuralFeature)JavaInstantiation.getInitializationStringFeature(this));
        }
        JavaHelpers jc = this.getJavaType();
        String qn = jc.getQualifiedName();
        return "new " + qn + "()";
    }

    public boolean isSetInitializationString() {
        return this.eIsSet((EStructuralFeature)JavaInstantiation.getInitializationStringFeature(this));
    }

    public void setInitializationString(String initString) {
        this.eSet((EStructuralFeature)JavaInstantiation.getInitializationStringFeature(this), initString);
    }

    public String getInstantiateUsing() {
        if (this.isSetInstantiateUsing()) {
            return (String)this.eGet((EStructuralFeature)JavaInstantiation.getInstantiateUsingFeature(this));
        }
        return null;
    }

    public boolean isSetInstantiateUsing() {
        return this.eIsSet((EStructuralFeature)JavaInstantiation.getInstantiateUsingFeature(this));
    }

    public void setInstantiateUsing(String aClassname) {
        this.eSet((EStructuralFeature)JavaInstantiation.getInstantiateUsingFeature(this), aClassname);
    }

    public String getSerializeData() {
        if (this.isSetSerializeData()) {
            return (String)this.eGet((EStructuralFeature)JavaInstantiation.getSerializeDataFeature(this));
        }
        return null;
    }

    public boolean isSetSerializeData() {
        return this.eIsSet((EStructuralFeature)JavaInstantiation.getSerializeDataFeature(this));
    }

    public void setSerializeData(String serializableData) {
        this.eSet((EStructuralFeature)JavaInstantiation.getSerializeDataFeature(this), serializableData);
    }

    public boolean isPrimitive() {
        return false;
    }

    public String toString() {
        StringBuffer result = new StringBuffer(this.getClass().getName());
        result.append('@');
        result.append(Integer.toHexString(this.hashCode()));
        if (this.eIsProxy()) {
            result.append(" (eProxyURI: ");
            result.append(this.eProxyURI());
            result.append(')');
        }
        try {
            String initString = this.getInitializationString();
            if (initString != null) {
                result.append(':');
                result.append(initString);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (NullPointerException nullPointerException) {}
        return result.toString();
    }

    protected EObjectImpl.EPropertiesHolder eProperties() {
        if (this.eProperties == null) {
            this.eProperties = new JavaObjectInstancePropertiesHolder();
        }
        return this.eProperties;
    }

    public void eSetClass(EClass eClass) {
        super.eSetClass(eClass);
        this.migrate();
    }

    protected void migrate() {
        if (this.eProperties != null && (this.eProperties.hasSettings() || this.eProperties.getEContents() != null || this.eProperties.getECrossReferences() != null)) {
            JavaObjectInstancePropertiesHolder properties = (JavaObjectInstancePropertiesHolder)this.eProperties;
            EList oldAllFeatures = properties.getAllStructuralFeatures();
            if (properties.getEClass().getEAllStructuralFeatures() == oldAllFeatures) {
                return;
            }
            Object[] oldSettings = properties.eSettings();
            properties.clearCache();
            if (oldSettings == null) {
                return;
            }
            this.eSettings();
            Object[] newSettings = properties.eSettings();
            int staticFeatureCnt = this.eStaticFeatureCount();
            int oldIndex = 0;
            while (oldIndex < oldSettings.length) {
                if (oldSettings[oldIndex] != null) {
                    EStructuralFeature sf = (EStructuralFeature)oldAllFeatures.get(oldIndex + staticFeatureCnt);
                    int newIndex = super.eDynamicFeatureID(sf);
                    if (newIndex > -1) {
                        this.moveESetting(oldSettings, newSettings, oldIndex, sf, newIndex);
                    } else {
                        EStructuralFeature newSF = properties.getEClass().getEStructuralFeature(sf.getName());
                        if (newSF != null && newSF.getClass().equals(sf.getClass()) && newSF.isMany() == sf.isMany() && newSF.isChangeable() == sf.isChangeable()) {
                            boolean compatible;
                            boolean bl = compatible = newSF.isUnique() == sf.isUnique() || !newSF.isUnique();
                            if (newSF instanceof EReference) {
                                EReference newRef = (EReference)newSF;
                                EReference ref = (EReference)sf;
                                compatible = newRef.isContainment() == ref.isContainment() && newRef.getEReferenceType().isSuperTypeOf(ref.getEReferenceType());
                            } else {
                                compatible = newSF.getEType().equals(sf.getEType());
                            }
                            if (compatible) {
                                newIndex = this.eDynamicFeatureID(newSF);
                                this.moveESetting(oldSettings, newSettings, oldIndex, newSF, newIndex);
                            }
                        }
                    }
                }
                ++oldIndex;
            }
        }
    }

    private void moveESetting(Object[] oldSettings, Object[] newSettings, int oldIndex, EStructuralFeature sf, int newIndex) {
        if (!sf.isMany()) {
            newSettings[newIndex] = oldSettings[oldIndex];
        } else {
            BasicEList newMany = (BasicEList)this.eGet(sf);
            BasicEList oldMany = (BasicEList)oldSettings[oldIndex];
            newMany.setData(oldMany.size(), oldMany.data());
        }
    }

    protected int eDynamicFeatureID(EStructuralFeature eStructuralFeature) {
        this.migrate();
        return super.eDynamicFeatureID(eStructuralFeature);
    }

    public EList eContents() {
        this.migrate();
        return super.eContents();
    }

    public EList eCrossReferences() {
        this.migrate();
        return super.eCrossReferences();
    }

    protected static class JavaObjectInstancePropertiesHolder
    extends EObjectImpl.EPropertiesHolderImpl {
        private EList allStructuralFeatures;

        public Object[] eSettings() {
            return this.eSettings;
        }

        public EList getAllStructuralFeatures() {
            return this.allStructuralFeatures;
        }

        public void clearCache() {
            this.eSettings = null;
            this.setEContents(null);
            this.setECrossReferences(null);
            this.allStructuralFeatures = null;
        }

        public void allocateSettings(int maximumDynamicFeatureID) {
            if (this.allStructuralFeatures == null) {
                this.allStructuralFeatures = this.getEClass().getEAllStructuralFeatures();
            }
            super.allocateSettings(maximumDynamicFeatureID);
        }

        public void setEContents(EList eContents) {
            if (this.allStructuralFeatures == null) {
                this.allStructuralFeatures = this.getEClass().getEAllStructuralFeatures();
            }
            super.setEContents(eContents);
        }

        public void setECrossReferences(EList eCrossReferences) {
            if (this.allStructuralFeatures == null) {
                this.allStructuralFeatures = this.getEClass().getEAllStructuralFeatures();
            }
            super.setECrossReferences(eCrossReferences);
        }
    }
}

