/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jem.internal.proxy.remote;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.ConnectException;
import java.net.Socket;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.IStreamListener;
import org.eclipse.debug.core.Launch;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.IStreamMonitor;
import org.eclipse.debug.core.model.IStreamsProxy;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.launching.StandardVMRunner;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.IVMRunner;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.launching.VMRunnerConfiguration;
import org.eclipse.jem.internal.proxy.core.IClasspathContributionController;
import org.eclipse.jem.internal.proxy.core.IConfigurationContributor;
import org.eclipse.jem.internal.proxy.core.IRegistration;
import org.eclipse.jem.internal.proxy.core.ProxyFactoryRegistry;
import org.eclipse.jem.internal.proxy.core.ProxyPlugin;
import org.eclipse.jem.internal.proxy.core.ProxyVMRunner;
import org.eclipse.jem.internal.proxy.remote.DebugModeHelper;
import org.eclipse.jem.internal.proxy.remote.ProxyRegistration;
import org.eclipse.jem.internal.proxy.remote.ProxyRemoteMessages;
import org.eclipse.jem.internal.proxy.remote.ProxyRemoteUtil;
import org.eclipse.jem.internal.proxy.remote.REMMethodProxyFactory;
import org.eclipse.jem.internal.proxy.remote.REMProxyFactoryRegistry;
import org.eclipse.jem.internal.proxy.remote.REMStandardBeanProxyFactory;
import org.eclipse.jem.internal.proxy.remote.REMStandardBeanTypeProxyFactory;
import org.eclipse.jem.internal.proxy.remote.awt.REMRegisterAWT;

public class ProxyRegistration
implements IRegistration {
    private static final Random fgRandom = new Random(System.currentTimeMillis());
    private static String ATTR_TARGET_RUN_PERSPECTIVE;
    private static String ATTR_PRIVATE;

    static {
        ATTR_PRIVATE = null;
        ATTR_TARGET_RUN_PERSPECTIVE = null;
        try {
            Class<?> debugUIConstants = Class.forName("org.eclipse.debug.ui.IDebugUIConstants");
            ATTR_TARGET_RUN_PERSPECTIVE = (String)debugUIConstants.getField("ATTR_TARGET_RUN_PERSPECTIVE").get(null);
            ATTR_PRIVATE = (String)debugUIConstants.getField("ATTR_PRIVATE").get(null);
        }
        catch (SecurityException securityException) {
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (NoSuchFieldException noSuchFieldException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (IllegalAccessException illegalAccessException) {}
    }

    public ProxyFactoryRegistry startImplementation(final IConfigurationContributor[] contributors, boolean attachAWT, IProject project, String vmName, IProgressMonitor pm) throws CoreException {
        String[] environmentVariables;
        String name = "Project (" + project.getName() + ")";
        if (vmName != null) {
            name = String.valueOf(name) + '-' + vmName;
        }
        IJavaProject javaProject = JavaCore.create((IProject)project);
        final ArrayList<String> classPaths = new ArrayList<String>(Arrays.asList(JavaRuntime.computeDefaultRuntimeClassPath((IJavaProject)javaProject)));
        final IClasspathContributionController controller = new IClasspathContributionController(){

            public void contributeProject(IProject project, List classpaths, int insertBeforeIndex) throws CoreException {
                ArrayList<String> projectPaths = new ArrayList<String>(Arrays.asList(JavaRuntime.computeDefaultRuntimeClassPath((IJavaProject)JavaCore.create((IProject)project))));
                Iterator itr2 = projectPaths.iterator();
                while (itr2.hasNext()) {
                    Object path = itr2.next();
                    if (!classpaths.contains(path)) continue;
                    itr2.remove();
                }
                if (insertBeforeIndex == -1) {
                    classpaths.addAll(projectPaths);
                } else {
                    classpaths.addAll(insertBeforeIndex, projectPaths);
                }
            }

            public void contributeClasspath(String classpath, List classpaths, int insertBeforeIndex) {
                if (!classpaths.contains(classpath)) {
                    if (insertBeforeIndex == -1) {
                        classpaths.add(classpath);
                    } else {
                        classpaths.add(insertBeforeIndex, classpath);
                    }
                }
            }

            public void contributeClasspath(String[] classpathsToAdd, List classpaths, int insertBeforeIndex) {
                int i = 0;
                while (i < classpathsToAdd.length) {
                    this.contributeClasspath(classpathsToAdd[i], classpaths, insertBeforeIndex);
                    ++i;
                }
            }

            public void contributeClasspath(URL[] classpathsURLs, List classpaths, int insertBeforeIndex) {
                int i = 0;
                while (i < classpathsURLs.length) {
                    this.contributeClasspath(classpathsURLs[i].getFile(), classpaths, insertBeforeIndex);
                    ++i;
                }
            }
        };
        if (contributors != null) {
            int i = 0;
            while (i < contributors.length) {
                final int ii = i++;
                Platform.run((ISafeRunnable)new ISafeRunnable(){

                    public void handleException(Throwable exception) {
                    }

                    public void run() throws Exception {
                        contributors[ii].contributeClasspaths((List)classPaths, controller);
                    }
                });
            }
        }
        ProxyRemoteUtil.updateClassPaths(classPaths, controller);
        final VMRunnerConfiguration config = new VMRunnerConfiguration("org.eclipse.jem.internal.proxy.vm.remote.RemoteVMApplication", classPaths.toArray(new String[classPaths.size()]));
        REMProxyFactoryRegistry registry = new REMProxyFactoryRegistry(ProxyRemoteUtil.getRegistryController(), name);
        Integer registryKey = registry.getRegistryKey();
        Integer bufSize = Integer.getInteger("proxyvm.bufsize");
        if (bufSize == null) {
            bufSize = new Integer(16000);
        }
        int masterServerPort = ProxyRemoteUtil.getRegistryController().getMasterSocketPort();
        config.setVMArguments(new String[]{"-Dproxyvm.registryKey=" + registryKey, "-Dproxyvm.masterPort=" + String.valueOf(masterServerPort), "-Dproxyvm.bufsize=" + bufSize, "-Dproxyvm.servername=" + name});
        if (contributors != null) {
            int i = 0;
            while (i < contributors.length) {
                final int ii = i++;
                Platform.run((ISafeRunnable)new ISafeRunnable(){

                    public void handleException(Throwable exception) {
                    }

                    public void run() throws Exception {
                        contributors[ii].contributeToConfiguration(config);
                    }
                });
            }
        }
        DebugModeHelper dh = new DebugModeHelper();
        boolean debugMode = dh.debugMode(name);
        int dport = -1;
        if (debugMode) {
            dport = ProxyRegistration.findUnusedLocalPort("localhost", 5000, 15000, new int[0]);
            String[] dArgs = new String[]{"-Djava.compiler=NONE", "-Xdebug", "-Xnoagent", "-Xrunjdwp:transport=dt_socket,server=y,address=" + dport};
            String[] newVMArgs = new String[config.getVMArguments().length + dArgs.length];
            System.arraycopy(config.getVMArguments(), 0, newVMArgs, 0, config.getVMArguments().length);
            System.arraycopy(dArgs, 0, newVMArgs, config.getVMArguments().length, dArgs.length);
            config.setVMArguments(newVMArgs);
        }
        IVMRunner runner = null;
        JavaRuntime.getVMInstallTypes();
        IVMInstall vm = JavaRuntime.getVMInstall((IJavaProject)javaProject);
        if (vm == null) {
            vm = JavaRuntime.getDefaultVMInstall();
        }
        if (vm != null) {
            runner = vm.getVMRunner("run");
        }
        if (runner instanceof StandardVMRunner) {
            runner = new ProxyVMRunner(vm);
        }
        if (runner == null) {
            String msg = null;
            msg = vm == null ? MessageFormat.format(ProxyRemoteMessages.getString("Proxy_NoVM_ERROR_"), name) : MessageFormat.format(ProxyRemoteMessages.getString("Proxy_NoRunner_ERROR_"), name);
            dh.displayErrorMessage(ProxyRemoteMessages.getString("Proxy_Error_Title"), msg);
            ProxyPlugin.getPlugin().getMsgLogger().log((Object)new Status(4, ProxyPlugin.getPlugin().getDescriptor().getUniqueIdentifier(), 0, msg, null));
            return null;
        }
        SubProgressMonitor spm = new SubProgressMonitor(pm, 1);
        ILaunchConfigurationType lcType = DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurationType(IJavaLaunchConfigurationConstants.ID_JAVA_APPLICATION);
        ILaunchConfigurationWorkingCopy wc = lcType.newInstance(null, vmName);
        this.applyDebugUIConstants(wc);
        Launch runresult = new Launch((ILaunchConfiguration)wc, "run", null);
        Map vmMap = config.getVMSpecificAttributesMap();
        if (vmMap != null && (environmentVariables = (String[])vmMap.get("environment_variable")) != null) {
            ((ProxyVMRunner)runner).fEnvironmentVariables = environmentVariables;
        }
        runner.run(config, (ILaunch)runresult, (IProgressMonitor)spm);
        spm.worked(1);
        if (runresult != null) {
            class StreamListener
            implements IStreamListener {
                String tracePrefix;
                int level;
                final /* synthetic */ ProxyRegistration this$0;

                public StreamListener(ProxyRegistration proxyRegistration, String type, int level, String string) {
                    this.this$0 = proxyRegistration;
                    this.tracePrefix = String.valueOf(string) + ':' + type + '>';
                    this.level = level;
                }

                public void streamAppended(String newText, IStreamMonitor monitor) {
                    ProxyPlugin.getPlugin().getMsgLogger().log((Object)new Status(this.level, ProxyPlugin.getPlugin().getDescriptor().getUniqueIdentifier(), 0, String.valueOf(this.tracePrefix) + newText, null));
                }
            }
            IProcess[] processes = runresult.getProcesses();
            IProcess process = processes[0];
            if (process.isTerminated()) {
                IStreamsProxy stProxy = process.getStreamsProxy();
                StringWriter s = new StringWriter();
                PrintWriter w = new PrintWriter(s);
                w.println(ProxyRemoteMessages.getString("VM_TERMINATED_INFO_"));
                w.println(ProxyRemoteMessages.getString("VM_TERMINATED_LINE1"));
                w.println(stProxy.getErrorStreamMonitor().getContents());
                w.println(ProxyRemoteMessages.getString("VM_TERMINATED_LINE2"));
                w.println(stProxy.getOutputStreamMonitor().getContents());
                w.println(ProxyRemoteMessages.getString("VM_TERMINATED_LINE3"));
                w.close();
                String msg = MessageFormat.format(ProxyRemoteMessages.getString("Proxy_Terminated_too_soon_ERROR_"), name);
                dh.displayErrorMessage(ProxyRemoteMessages.getString("Proxy_Error_Title"), msg);
                ProxyPlugin.getPlugin().getMsgLogger().log((Object)new Status(2, ProxyPlugin.getPlugin().getDescriptor().getUniqueIdentifier(), 0, s.toString(), null));
                return null;
            }
            String traceName = name;
            IStreamsProxy fStreamsProxy = process.getStreamsProxy();
            IStreamMonitor monitor = fStreamsProxy.getErrorStreamMonitor();
            if (monitor != null) {
                monitor.addListener((IStreamListener)new StreamListener(this, "err", 2, traceName));
            }
            if ("true".equalsIgnoreCase(Platform.getDebugOption((String)(String.valueOf(ProxyPlugin.getPlugin().getDescriptor().getUniqueIdentifier()) + "/remote/debug/vmtraceout"))) && (monitor = fStreamsProxy.getOutputStreamMonitor()) != null) {
                monitor.addListener((IStreamListener)new StreamListener(this, "out", 1, traceName));
            }
            if (debugMode && !dh.promptPort(dport)) {
                process.terminate();
                return null;
            }
            registry.initializeRegistry(process);
            new REMStandardBeanTypeProxyFactory(registry);
            new REMStandardBeanProxyFactory(registry);
            new REMMethodProxyFactory(registry);
            if (debugMode) {
                registry.fNoTimeouts = true;
            }
            if (attachAWT) {
                REMRegisterAWT.registerAWT(registry);
            }
            if (contributors != null) {
                final REMProxyFactoryRegistry reg = registry;
                int i = 0;
                while (i < contributors.length) {
                    final int ii = i++;
                    Platform.run((ISafeRunnable)new ISafeRunnable(){

                        public void handleException(Throwable exception) {
                        }

                        public void run() throws Exception {
                            contributors[ii].contributeToRegistry(reg);
                        }
                    });
                }
            }
            return registry;
        }
        String msg = MessageFormat.format(ProxyRemoteMessages.getString("PRoxy_NoLaunch_ERROR_"), name);
        dh.displayErrorMessage(ProxyRemoteMessages.getString("Proxy_Error_Title"), msg);
        ProxyPlugin.getPlugin().getMsgLogger().log((Object)new Status(4, ProxyPlugin.getPlugin().getDescriptor().getUniqueIdentifier(), 0, msg, null));
        return null;
    }

    private static int findUnusedLocalPort(String host, int searchFrom, int searchTo, int[] exclude) {
        int i = 0;
        while (i < 10) {
            int port = 0;
            block4: while (true) {
                port = ProxyRegistration.getRandomPort(searchFrom, searchTo);
                if (exclude == null) break;
                int e = 0;
                while (e < exclude.length) {
                    if (port == exclude[e]) continue block4;
                    ++e;
                }
                break;
            }
            try {
                new Socket(host, port);
            }
            catch (ConnectException connectException) {
                return port;
            }
            catch (IOException iOException) {}
            ++i;
        }
        return -1;
    }

    private static int getRandomPort(int low, int high) {
        return (int)(fgRandom.nextFloat() * (float)(high - low)) + low;
    }

    protected static String makeAbsolute(IWorkspace ws, IPath path) {
        IResource resource = ws.getRoot().findMember(path);
        if (resource != null) {
            return resource.getLocation().toOSString();
        }
        return path.toOSString();
    }

    private void applyDebugUIConstants(ILaunchConfigurationWorkingCopy wc) {
        if (ATTR_TARGET_RUN_PERSPECTIVE != null) {
            wc.setAttribute(ATTR_TARGET_RUN_PERSPECTIVE, null);
        }
        if (ATTR_PRIVATE != null) {
            wc.setAttribute(ATTR_PRIVATE, true);
        }
    }
}

