/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jem.internal.proxy.remote;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.jem.internal.proxy.core.IBeanProxy;
import org.eclipse.jem.internal.proxy.core.ICallback;
import org.eclipse.jem.internal.proxy.core.ICallbackRegistry;
import org.eclipse.jem.internal.proxy.remote.IREMBeanProxy;
import org.eclipse.jem.internal.proxy.remote.IREMBeanTypeProxy;
import org.eclipse.jem.internal.proxy.remote.IREMMethodProxy;
import org.eclipse.jem.internal.proxy.remote.REMCallbackThread;
import org.eclipse.jem.internal.proxy.remote.REMInterfaceBeanTypeProxy;
import org.eclipse.jem.internal.proxy.remote.REMMethodProxyFactory;
import org.eclipse.jem.internal.proxy.remote.REMProxyFactoryRegistry;
import org.eclipse.jem.internal.proxy.remote.REMStandardBeanProxyFactory;
import org.eclipse.jem.internal.proxy.remote.REMStandardBeanTypeProxyFactory;

class REMCallbackServerThread
extends Thread
implements ICallbackRegistry {
    final REMProxyFactoryRegistry fFactory;
    final String fNamePostfix;
    ServerSocket fServer;
    List fThreads = Collections.synchronizedList(new LinkedList());
    HashMap fIdToCallback = new HashMap(5);
    HashSet fRegisteredCallbackProxies = new HashSet(5);
    IREMMethodProxy fInitializeCallback;
    IREMBeanProxy fRemoteServer;
    Object fStarted = null;
    static boolean LINUX_1_3 = "linux".equalsIgnoreCase(System.getProperty("os.name")) && System.getProperty("java.version", "").startsWith("1.3");

    public REMCallbackServerThread(String name, REMProxyFactoryRegistry aFactory, Object started) {
        super("Callback Server Thread-" + name);
        this.fFactory = aFactory;
        this.fNamePostfix = name;
        this.fStarted = started;
        try {
            this.fServer = new ServerSocket(0, 50, InetAddress.getByName("localhost"));
        }
        catch (IOException iOException) {
            return;
        }
        REMStandardBeanTypeProxyFactory typeFactory = (REMStandardBeanTypeProxyFactory)this.fFactory.getBeanTypeProxyFactory();
        REMInterfaceBeanTypeProxy vmserverType = new REMInterfaceBeanTypeProxy(this.fFactory, new Integer(29), "org.eclipse.jem.internal.proxy.vm.remote.IVMServer");
        REMInterfaceBeanTypeProxy callbackType = new REMInterfaceBeanTypeProxy(this.fFactory, new Integer(30), "org.eclipse.jem.internal.proxy.vm.remote.ICallback");
        IREMBeanTypeProxy serverType = typeFactory.objectClass.newBeanTypeForClass(new Integer(32), "org.eclipse.jem.internal.proxy.vm.remote.RemoteVMServerThread", false);
        this.fInitializeCallback = (IREMMethodProxy)((REMMethodProxyFactory)this.fFactory.getMethodProxyFactory()).methodType.newBeanProxy(new Integer(33));
        this.fRemoteServer = serverType.newBeanProxy(new Integer(31));
        ((REMStandardBeanProxyFactory)this.fFactory.getBeanProxyFactory()).registerProxy(vmserverType);
        ((REMStandardBeanProxyFactory)this.fFactory.getBeanProxyFactory()).registerProxy(callbackType);
        ((REMStandardBeanProxyFactory)this.fFactory.getBeanProxyFactory()).registerProxy(this.fInitializeCallback);
        ((REMStandardBeanProxyFactory)this.fFactory.getBeanProxyFactory()).registerProxy(this.fRemoteServer);
    }

    public int getServerPort() {
        return this.fServer != null ? this.fServer.getLocalPort() : -1;
    }

    public void run() {
        try {
            if (LINUX_1_3) {
                this.fServer.setSoTimeout(1000);
            }
            Object object = this.fStarted;
            synchronized (object) {
                this.fStarted.notify();
            }
            this.fStarted = null;
            while (true) {
                Socket incoming = null;
                try {
                    incoming = this.fServer.accept();
                }
                catch (InterruptedIOException interruptedIOException) {
                    continue;
                }
                REMCallbackThread st = new REMCallbackThread(incoming, this, "Callback Thread-" + this.fNamePostfix, this.fFactory, this.fFactory.fNoTimeouts);
                this.fThreads.add(st);
                st.start();
                st = null;
                object = null;
            }
        }
        catch (Exception exception) {
            this.shutdown();
            return;
        }
    }

    public boolean requestShutdown() {
        if (this.fServer == null) {
            return false;
        }
        try {
            this.fServer.close();
        }
        catch (Exception exception) {}
        return true;
    }

    public void removeCallbackThread(REMCallbackThread thread) {
        this.fThreads.remove(thread);
    }

    private void shutdown() {
        if (this.fServer != null) {
            try {
                this.fServer.close();
            }
            catch (Exception exception) {}
        }
        REMCallbackThread[] threadsArray = this.fThreads.toArray(new REMCallbackThread[this.fThreads.size()]);
        int i = 0;
        while (i < threadsArray.length) {
            threadsArray[i].close();
            ++i;
        }
        i = 0;
        while (i < threadsArray.length) {
            try {
                threadsArray[i].join(10000L);
            }
            catch (InterruptedException interruptedException) {}
            ++i;
        }
        this.fThreads.clear();
        this.fIdToCallback.clear();
        this.fRegisteredCallbackProxies.clear();
        this.fInitializeCallback = null;
        this.fRemoteServer = null;
    }

    public ICallback getRegisteredCallback(int id) {
        HashMap hashMap = this.fIdToCallback;
        synchronized (hashMap) {
            return (ICallback)this.fIdToCallback.get(new Integer(id));
        }
    }

    public void registerCallback(IBeanProxy callbackProxy, ICallback cb) {
        HashMap hashMap = this.fIdToCallback;
        synchronized (hashMap) {
            this.fIdToCallback.put(((IREMBeanProxy)callbackProxy).getID(), cb);
            this.fRegisteredCallbackProxies.add(callbackProxy);
            this.fInitializeCallback.invokeCatchThrowableExceptions(callbackProxy, new IBeanProxy[]{this.fRemoteServer, this.fFactory.getBeanProxyFactory().createBeanProxyWith(((IREMBeanProxy)callbackProxy).getID().intValue())});
        }
    }

    public void deregisterCallback(IBeanProxy callbackProxy) {
        HashMap hashMap = this.fIdToCallback;
        synchronized (hashMap) {
            this.fIdToCallback.remove(((IREMBeanProxy)callbackProxy).getID());
            this.fRegisteredCallbackProxies.remove(callbackProxy);
        }
    }
}

