/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jem.internal.proxy.remote;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.Socket;
import org.eclipse.core.runtime.Status;
import org.eclipse.jem.internal.proxy.common.CommandException;
import org.eclipse.jem.internal.proxy.common.remote.CommandErrorException;
import org.eclipse.jem.internal.proxy.common.remote.Commands;
import org.eclipse.jem.internal.proxy.core.ProxyPlugin;
import org.eclipse.jem.internal.proxy.remote.IREMConnection;

public class REMConnection
implements IREMConnection {
    protected Socket fSocket = null;
    protected DataInputStream in = null;
    protected DataOutputStream out = null;
    private static final int TIME_OUT = 60000;

    public REMConnection(Socket socket, boolean noTimeouts) {
        try {
            Integer bufSize;
            this.fSocket = socket;
            this.fSocket.setSoLinger(true, 10);
            if (!noTimeouts) {
                this.fSocket.setSoTimeout(60000);
            }
            if ((bufSize = Integer.getInteger("proxyvm.bufsize")) == null) {
                bufSize = new Integer(16000);
            }
            this.out = new DataOutputStream(new BufferedOutputStream(this.fSocket.getOutputStream(), bufSize));
            this.in = new DataInputStream(new BufferedInputStream(this.fSocket.getInputStream(), bufSize));
        }
        catch (IOException e) {
            ProxyPlugin.getPlugin().getMsgLogger().log((Object)new Status(4, ProxyPlugin.getPlugin().getDescriptor().getUniqueIdentifier(), 0, "", (Throwable)e));
            if (this.out != null) {
                try {
                    this.out.close();
                }
                catch (IOException iOException) {}
            }
            if (this.in != null) {
                try {
                    this.in.close();
                }
                catch (IOException iOException) {}
            }
            try {
                this.fSocket.close();
            }
            catch (IOException iOException) {}
            this.fSocket = null;
            this.in = null;
            this.out = null;
        }
    }

    public boolean isConnected() {
        return this.fSocket != null;
    }

    public void terminateServer() {
        if (this.isConnected()) {
            try {
                Commands.sendTerminateCommand((DataOutputStream)this.out);
            }
            catch (IOException iOException) {}
            this.close();
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void close() {
        if (!this.isConnected()) return;
        try {
            try {
                Commands.sendQuitCommand((DataOutputStream)this.out);
            }
            catch (IOException iOException) {}
        }
        catch (Throwable throwable) {
            Object var1_2 = null;
            try {
                this.out.close();
            }
            catch (IOException iOException) {}
            try {
                this.in.close();
            }
            catch (IOException iOException) {}
            try {
                this.fSocket.close();
                throw throwable;
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        {
            Object var1_3 = null;
        }
        try {}
        catch (IOException iOException) {}
        this.out.close();
        try {}
        catch (IOException iOException) {}
        this.in.close();
        try {}
        catch (IOException iOException) {}
        this.fSocket.close();
        this.fSocket = null;
        this.in = null;
        this.out = null;
    }

    public Commands.GetClassReturn getClass(String className) throws CommandException {
        block3: {
            if (this.isConnected()) {
                try {
                    return Commands.sendGetClassCommand((DataOutputStream)this.out, (DataInputStream)this.in, (String)className);
                }
                catch (CommandErrorException e) {
                    if (e.getErrorCode() == 2) break block3;
                    throw e;
                }
            }
        }
        return null;
    }

    public Commands.GetClassIDReturn getClassFromID(int classID) throws CommandException {
        if (this.isConnected()) {
            return Commands.sendGetClassFromIDCommand((DataOutputStream)this.out, (DataInputStream)this.in, (int)classID);
        }
        return null;
    }

    public void getObjectData(int classID, Commands.ValueObject valueReturn) throws CommandException {
        if (this.isConnected()) {
            Commands.sendGetObjectData((DataOutputStream)this.out, (DataInputStream)this.in, (int)classID, (Commands.ValueObject)valueReturn);
        } else {
            valueReturn.set();
        }
    }

    public void getNewInstance(int classID, String initString, Commands.ValueObject newInstance) throws CommandException {
        if (this.isConnected()) {
            Commands.sendNewInstance((DataOutputStream)this.out, (DataInputStream)this.in, (int)classID, (String)initString, (Commands.ValueObject)newInstance);
        } else {
            newInstance.set();
        }
    }

    public void releaseID(int id) {
        if (this.isConnected()) {
            try {
                Commands.releaseObjectCommand((DataOutputStream)this.out, (int)id);
            }
            catch (IOException iOException) {}
        }
    }

    public void invokeMethod(int methodID, Commands.ValueObject invokeOn, Commands.ValueObject parms, Commands.ValueObject returnValue) throws CommandException {
        if (this.isConnected()) {
            Commands.sendInvokeMethodCommand((DataOutputStream)this.out, (DataInputStream)this.in, (int)methodID, (Commands.ValueObject)invokeOn, (Commands.ValueObject)parms, (Commands.ValueObject)returnValue);
        }
    }
}

