/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jem.internal.proxy.remote;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.Socket;
import java.text.MessageFormat;
import java.util.AbstractList;
import java.util.Iterator;
import java.util.Stack;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.IStreamsProxy;
import org.eclipse.jem.internal.proxy.core.ICallbackRegistry;
import org.eclipse.jem.internal.proxy.core.ProxyFactoryRegistry;
import org.eclipse.jem.internal.proxy.core.ProxyPlugin;
import org.eclipse.jem.internal.proxy.remote.DebugModeHelper;
import org.eclipse.jem.internal.proxy.remote.IREMConnection;
import org.eclipse.jem.internal.proxy.remote.ProxyRemoteMessages;
import org.eclipse.jem.internal.proxy.remote.REMCallbackServerThread;
import org.eclipse.jem.internal.proxy.remote.REMConnection;
import org.eclipse.jem.internal.proxy.remote.REMRegistryController;

public class REMProxyFactoryRegistry
extends ProxyFactoryRegistry {
    protected int fServerPort = 0;
    protected REMCallbackServerThread fCallbackServer;
    protected Stack fConnectionPool = new Stack();
    protected static int NUMBER_FREE_CONNECTIONS = 5;
    protected IProcess fProcess;
    protected String fName;
    protected int fCallbackServerPort;
    protected Integer fRegistryKey;
    protected REMRegistryController fRegistryController;
    boolean fNoTimeouts = false;
    private WaitForRegistrationThread waitRegistrationThread;
    private IDebugEventSetListener processListener = null;

    public REMProxyFactoryRegistry(REMRegistryController registryController, String name) {
        this.fRegistryController = registryController;
        this.fRegistryKey = this.fRegistryController.registerRegistry(this);
        this.fName = name;
        REMProxyFactoryRegistry rEMProxyFactoryRegistry = this;
        synchronized (rEMProxyFactoryRegistry) {
            this.waitRegistrationThread = new WaitForRegistrationThread();
            this.waitRegistrationThread.start();
            while (true) {
                try {
                    ((Object)((Object)this)).wait();
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
        }
    }

    public Integer getRegistryKey() {
        return this.fRegistryKey;
    }

    public void initializeRegistry(IProcess process) {
        this.fProcess = process;
        this.processListener = new IDebugEventSetListener(){

            public void handleDebugEvents(DebugEvent[] events) {
                int i = 0;
                while (i < events.length) {
                    DebugEvent e = events[i];
                    if (e.getSource() == REMProxyFactoryRegistry.this.fProcess && e.getKind() == 8) {
                        IStreamsProxy stProxy = REMProxyFactoryRegistry.this.fProcess.getStreamsProxy();
                        StringWriter s = new StringWriter();
                        PrintWriter w = new PrintWriter(s);
                        String msg = MessageFormat.format(ProxyRemoteMessages.getString("Proxy_Terminated_too_soon_ERROR_"), REMProxyFactoryRegistry.this.fName);
                        w.println(msg);
                        w.println(ProxyRemoteMessages.getString("VM_TERMINATED_INFO_"));
                        w.println(ProxyRemoteMessages.getString("VM_TERMINATED_LINE1"));
                        w.println(stProxy.getErrorStreamMonitor().getContents());
                        w.println(ProxyRemoteMessages.getString("VM_TERMINATED_LINE2"));
                        w.println(stProxy.getOutputStreamMonitor().getContents());
                        w.println(ProxyRemoteMessages.getString("VM_TERMINATED_LINE3"));
                        w.close();
                        DebugModeHelper dh = new DebugModeHelper();
                        dh.displayErrorMessage(ProxyRemoteMessages.getString("Proxy_Error_Title"), msg);
                        ProxyPlugin.getPlugin().getMsgLogger().log((Object)new Status(2, ProxyPlugin.getPlugin().getDescriptor().getUniqueIdentifier(), 0, s.toString(), null));
                        REMProxyFactoryRegistry.this.processListener = null;
                        DebugPlugin.getDefault().removeDebugEventListener((IDebugEventSetListener)this);
                        REMProxyFactoryRegistry.this.terminateRegistry();
                        break;
                    }
                    ++i;
                }
            }
        };
        DebugPlugin.getDefault().addDebugEventListener(this.processListener);
    }

    public int getCallbackServerPort() {
        this.getCallbackRegistry();
        return this.fCallbackServerPort;
    }

    public ICallbackRegistry getCallbackRegistry() {
        if (this.fCallbackServer == null) {
            Object started;
            Object object = started = new Object();
            synchronized (object) {
                this.fCallbackServer = new REMCallbackServerThread(this.fName, this, started);
                this.fCallbackServerPort = this.fCallbackServer.getServerPort();
                if (this.fCallbackServerPort == -1) {
                    return null;
                }
                this.fCallbackServer.start();
                try {
                    started.wait(30000L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        return this.fCallbackServer;
    }

    protected void registryTerminated() {
        Object db;
        if (this.processListener != null) {
            db = DebugPlugin.getDefault();
            if (db != null) {
                db.removeDebugEventListener(this.processListener);
            }
            this.processListener = null;
        }
        if (this.fServerPort != 0) {
            Object wThread;
            if (this.waitRegistrationThread != null) {
                db = this.waitRegistrationThread;
                synchronized (db) {
                    wThread = this.waitRegistrationThread;
                    this.waitRegistrationThread = null;
                    wThread.notifyAll();
                }
            }
            IREMConnection closeCon = null;
            wThread = this.fConnectionPool;
            synchronized (wThread) {
                Iterator itr = ((AbstractList)this.fConnectionPool).iterator();
                if (itr.hasNext()) {
                    closeCon = (IREMConnection)itr.next();
                }
                while (itr.hasNext()) {
                    IREMConnection con = (IREMConnection)itr.next();
                    con.close();
                }
            }
            if (closeCon == null) {
                closeCon = this.getFreeConnection();
            }
            if (closeCon != null) {
                closeCon.terminateServer();
            }
            this.fConnectionPool.clear();
            this.fServerPort = 0;
            if (this.fProcess != null) {
                try {
                    int i = 0;
                    while (!this.fProcess.isTerminated() && i < 100) {
                        try {
                            Thread.sleep(100L);
                        }
                        catch (InterruptedException interruptedException) {}
                        ++i;
                    }
                    if (!this.fProcess.isTerminated()) {
                        this.fProcess.terminate();
                    }
                }
                catch (DebugException debugException) {}
                this.fProcess = null;
            }
        }
        if (this.fCallbackServer != null) {
            try {
                this.fCallbackServer.requestShutdown();
                this.fCallbackServer.join(20000L);
                this.fCallbackServer = null;
            }
            catch (InterruptedException interruptedException) {}
        }
        this.fConnectionPool.clear();
        this.fRegistryController.deregisterRegistry(this.fRegistryKey);
    }

    public int getServerPort() {
        return this.fServerPort;
    }

    void setServerPort(int serverport) {
        this.fServerPort = serverport;
        if (this.waitRegistrationThread != null) {
            WaitForRegistrationThread waitForRegistrationThread = this.waitRegistrationThread;
            synchronized (waitForRegistrationThread) {
                WaitForRegistrationThread wThread = this.waitRegistrationThread;
                this.waitRegistrationThread = null;
                wThread.notifyAll();
            }
        }
    }

    public IREMConnection getFreeConnection() {
        Stack stack = this.fConnectionPool;
        synchronized (stack) {
            if (!this.fConnectionPool.isEmpty()) {
                return (IREMConnection)this.fConnectionPool.pop();
            }
            return this.createConnection();
        }
    }

    protected IREMConnection createConnection() {
        if (this.fServerPort != 0) {
            final Socket[] scArray = new Socket[1];
            final boolean[] waiting = new boolean[]{true};
            Thread doIt = new Thread(new Runnable(){

                public void run() {
                    try {
                        Socket sc = new Socket("localhost", REMProxyFactoryRegistry.this.fServerPort);
                        2 var2_3 = this;
                        synchronized (var2_3) {
                            if (waiting[0]) {
                                scArray[0] = sc;
                            } else {
                                sc.close();
                            }
                        }
                    }
                    catch (IOException e) {
                        ProxyPlugin.getPlugin().getMsgLogger().log((Object)new Status(2, ProxyPlugin.getPlugin().getDescriptor().getUniqueIdentifier(), 0, "", (Throwable)e));
                    }
                }
            });
            doIt.start();
            while (true) {
                try {
                    doIt.join(!this.fNoTimeouts ? 60000 : 0);
                    Thread thread = doIt;
                    synchronized (thread) {
                        waiting[0] = false;
                    }
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
            if (scArray[0] == null) {
                ProxyPlugin.getPlugin().getMsgLogger().log((Object)new Status(2, ProxyPlugin.getPlugin().getDescriptor().getUniqueIdentifier(), 0, "", (Throwable)new RuntimeException("Connection creation failed.")));
                return null;
            }
            REMConnection connection = new REMConnection(scArray[0], this.fNoTimeouts);
            if (connection.isConnected()) {
                return connection;
            }
            try {
                scArray[0].close();
            }
            catch (IOException iOException) {}
        } else {
            ProxyPlugin.getPlugin().getMsgLogger().log((Object)new Status(1, ProxyPlugin.getPlugin().getDescriptor().getUniqueIdentifier(), 0, "No Server to retrieve a connection.", null));
        }
        return null;
    }

    public void returnConnection(IREMConnection connection) {
        if (connection.isConnected()) {
            Stack stack = this.fConnectionPool;
            synchronized (stack) {
                if (this.fConnectionPool.size() < NUMBER_FREE_CONNECTIONS) {
                    this.fConnectionPool.push(connection);
                } else {
                    connection.close();
                }
            }
        }
    }

    public void closeConnection(IREMConnection connection) {
        connection.close();
    }

    public int connectionCount() {
        Stack stack = this.fConnectionPool;
        synchronized (stack) {
            return this.fConnectionPool.size();
        }
    }

    private class WaitForRegistrationThread
    extends Thread {
        public WaitForRegistrationThread() {
            super("Wait for remote vm registration thread");
        }

        public void run() {
            Stack stack = REMProxyFactoryRegistry.this.fConnectionPool;
            synchronized (stack) {
                Object object = REMProxyFactoryRegistry.this;
                synchronized (object) {
                    ((Object)((Object)REMProxyFactoryRegistry.this)).notifyAll();
                }
                object = this;
                synchronized (object) {
                    long stopTime = System.currentTimeMillis() + 60000L;
                    while (REMProxyFactoryRegistry.this.waitRegistrationThread != null && (REMProxyFactoryRegistry.this.fNoTimeouts || System.currentTimeMillis() < stopTime)) {
                        try {
                            Thread.currentThread().wait(60000L);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                }
            }
            REMProxyFactoryRegistry.this.waitRegistrationThread = null;
        }
    }
}

