/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jem.internal.proxy.remote;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jem.internal.proxy.remote.REMMasterServerThread;
import org.eclipse.jem.internal.proxy.remote.REMProxyFactoryRegistry;
import org.eclipse.jem.internal.proxy.remote.REMStandardBeanProxyFactory;

public class REMRegistryController {
    private Map fActiveRegistries = new HashMap();
    private boolean goingDown = false;
    private Thread processQueueThread = new Thread(new Runnable(){

        public void run() {
            do {
                if (Thread.interrupted()) continue;
                try {
                    Thread.sleep(60000L);
                    REMProxyFactoryRegistry[] registries = null;
                    Map map = REMRegistryController.this.fActiveRegistries;
                    synchronized (map) {
                        registries = REMRegistryController.this.fActiveRegistries.values().toArray(new REMProxyFactoryRegistry[REMRegistryController.this.fActiveRegistries.size()]);
                    }
                    int i = 0;
                    while (i < registries.length) {
                        try {
                            ((REMStandardBeanProxyFactory)registries[i].getBeanProxyFactory()).processQueue();
                        }
                        catch (RuntimeException runtimeException) {}
                        ++i;
                    }
                }
                catch (InterruptedException interruptedException) {}
            } while (!REMRegistryController.this.goingDown);
        }
    }, "Remote VM Cleanup GC'd Proxies Thread");
    protected REMMasterServerThread masterThread = new REMMasterServerThread(this);

    public REMRegistryController() {
        this.masterThread.start();
        this.processQueueThread.setPriority(1);
        this.processQueueThread.setDaemon(true);
        this.processQueueThread.start();
    }

    synchronized Integer registerRegistry(REMProxyFactoryRegistry registry) {
        REMProxyFactoryRegistry existing;
        Integer hashcode = new Integer(((Object)((Object)registry)).hashCode());
        while ((existing = (REMProxyFactoryRegistry)((Object)this.fActiveRegistries.get(hashcode))) != null) {
            if (existing != registry) {
                hashcode = new Integer(hashcode + 1);
                continue;
            }
            return hashcode;
        }
        this.fActiveRegistries.put(hashcode, registry);
        return hashcode;
    }

    synchronized void deregisterRegistry(Integer key) {
        this.fActiveRegistries.remove(key);
    }

    synchronized REMProxyFactoryRegistry getRegistry(Integer key) {
        return (REMProxyFactoryRegistry)((Object)this.fActiveRegistries.get(key));
    }

    public void shutdown() {
        this.goingDown = true;
        this.processQueueThread.interrupt();
        REMProxyFactoryRegistry[] registries = null;
        Map map = this.fActiveRegistries;
        synchronized (map) {
            registries = this.fActiveRegistries.values().toArray(new REMProxyFactoryRegistry[this.fActiveRegistries.size()]);
        }
        int i = 0;
        while (i < registries.length) {
            registries[i].terminateRegistry();
            ++i;
        }
        if (this.masterThread != null) {
            try {
                this.masterThread.requestShutdown();
                this.masterThread.join(20000L);
                this.masterThread = null;
            }
            catch (InterruptedException interruptedException) {}
        }
        try {
            this.processQueueThread.join(5000L);
        }
        catch (InterruptedException interruptedException) {}
    }

    public int getMasterSocketPort() {
        return this.masterThread != null ? this.masterThread.getMasterSocket().getLocalPort() : -1;
    }
}

