/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.emf.workbench;

import com.ibm.etools.emf.workbench.EMFNature;
import com.ibm.etools.emf.workbench.EMFNatureContributor;
import com.ibm.etools.emf.workbench.ResourceSetWorkbenchSynchronizer;
import com.ibm.etools.emf.workbench.plugin.EMFWorkbenchPlugin;
import java.util.Map;
import java.util.WeakHashMap;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectNature;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.ecore.resource.ResourceSet;

public class EMFNatureFactory {
    public static EMFNatureFactory INSTANCE = new EMFNatureFactory();
    private final Class CONTRIBUTOR_CLASS = class$com$ibm$etools$emf$workbench$EMFNatureContributor == null ? (class$com$ibm$etools$emf$workbench$EMFNatureContributor = EMFNatureFactory.class$("com.ibm.etools.emf.workbench.EMFNatureContributor")) : class$com$ibm$etools$emf$workbench$EMFNatureContributor;
    protected Map emfNatureCache = new WeakHashMap();
    static /* synthetic */ Class class$com$ibm$etools$emf$workbench$EMFNatureContributor;

    protected EMFNatureFactory() {
    }

    protected void cacheEMFNature(IProject aProject, EMFNature emfNature) {
        if (aProject != null && emfNature != null) {
            this.emfNatureCache.put(aProject, emfNature);
        }
    }

    protected EMFNature getCachedEMFNature(IProject aProject) {
        if (aProject != null) {
            return (EMFNature)this.emfNatureCache.get(aProject);
        }
        return null;
    }

    protected void removeProject(IProject aProject) {
        if (aProject != null) {
            EMFNature nat = this.getCachedEMFNature(aProject);
            this.emfNatureCache.remove(aProject);
            if (nat != null) {
                nat.dispose();
            }
        }
    }

    public EMFNature createEMFNature(IProject aProject, EMFNatureContributor contributor) {
        EMFNature nature = this.getCachedEMFNature(aProject);
        if (nature == null) {
            nature = this.primCreateEMFNature(aProject);
            this.cacheEMFNature(aProject, nature);
            if (contributor == null) {
                this.initializeEMFNatureFromContributors(aProject, nature);
            }
        }
        if (contributor != null && nature != null) {
            contributor.contributeToNature(nature);
        }
        return nature;
    }

    protected void initializeEMFNatureFromContributors(IProject aProject, EMFNature emfNature) {
        if (aProject == null || emfNature == null) {
            return;
        }
        String[] ids = this.getNatureIds(aProject);
        if (ids == null) {
            return;
        }
        String id = null;
        IProjectNature nature = null;
        int i = 0;
        while (i < ids.length) {
            id = ids[i];
            if (this.isNatureEnabled(aProject, id) && (nature = this.getNature(aProject, id)) != null && this.CONTRIBUTOR_CLASS.isInstance(nature)) {
                ((EMFNatureContributor)nature).contributeToNature(emfNature);
            }
            ++i;
        }
    }

    protected boolean isNatureEnabled(IProject aProject, String natureId) {
        try {
            return aProject.isNatureEnabled(natureId);
        }
        catch (CoreException e) {
            return false;
        }
    }

    protected String[] getNatureIds(IProject aProject) {
        try {
            if (aProject.isAccessible()) {
                return aProject.getDescription().getNatureIds();
            }
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        return null;
    }

    protected IProjectNature getNature(IProject aProject, String natureId) {
        try {
            return aProject.getNature(natureId);
        }
        catch (CoreException e) {
            return null;
        }
    }

    protected EMFNature primCreateEMFNature(IProject aProject) {
        return new EMFNature(aProject);
    }

    public EMFNature getEMFNature(IProject aProject) {
        return this.getCachedEMFNature(aProject);
    }

    public ResourceSetWorkbenchSynchronizer createSynchronizer(ResourceSet aResourceSet, IProject aProject) {
        return new EMFNatureResourceSetWorkbenchSynchronizer(aResourceSet, aProject);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class EMFNatureResourceSetWorkbenchSynchronizer
    extends ResourceSetWorkbenchSynchronizer {
        public EMFNatureResourceSetWorkbenchSynchronizer(ResourceSet resourceSet, IProject aProject) {
            super(resourceSet, aProject);
        }

        protected void release() {
            if (EMFWorkbenchPlugin.isActivated()) {
                EMFNatureFactory.this.removeProject(this.getProject());
                super.release();
            }
        }
    }
}

