/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.emf.workbench;

import com.ibm.etools.emf.workbench.ProjectResourceSetImpl;
import com.ibm.etools.emf.workbench.WorkbenchResourceHelper;
import com.ibm.etools.emf.workbench.plugin.EMFWorkbenchPlugin;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.core.resources.IProject;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;

public class PassthruResourceSet
extends ProjectResourceSetImpl {
    protected boolean isIsolated = false;

    public PassthruResourceSet() {
        this.isIsolated = false;
    }

    public PassthruResourceSet(IProject project) {
        this.setProject(project);
        this.isIsolated = true;
    }

    public boolean isIsolated() {
        return this.isIsolated;
    }

    public Resource createResource(URI uri) {
        Resource result = EMFWorkbenchPlugin.getResourceHelper().getExistingOrCreateResource(uri);
        if (result == null) {
            return super.createResource(uri);
        }
        return result;
    }

    protected Resource demandCreateResource(URI uri) {
        Resource result = EMFWorkbenchPlugin.getResourceHelper().createResource(uri);
        if (result == null) {
            return super.createResource(uri);
        }
        return result;
    }

    public EList getResources() {
        if (this.isIsolated) {
            return super.getResources();
        }
        if (this.resources == null) {
            this.resources = new PassthruResourcesEList();
        }
        return this.resources;
    }

    protected WorkbenchResourceHelper getResourceHelper() {
        return EMFWorkbenchPlugin.getResourceHelper();
    }

    protected Resource createResourceFromHandlers(URI uri) {
        if (!this.isIsolated) {
            return super.createResourceFromHandlers(uri);
        }
        return null;
    }

    protected Resource getResourceFromHandlers(URI uri) {
        if (!this.isIsolated) {
            return super.getResourceFromHandlers(uri);
        }
        return null;
    }

    protected EObject getEObjectFromHandlers(URI uri, boolean loadOnDemand) {
        if (!this.isIsolated) {
            return super.getEObjectFromHandlers(uri, loadOnDemand);
        }
        return null;
    }

    public class PassthruResourcesEList
    extends ResourceSetImpl.ResourcesEList {
        public PassthruResourcesEList() {
            super((ResourceSetImpl)PassthruResourceSet.this);
        }

        public boolean add(Object object) {
            if (object == null) {
                return false;
            }
            ResourceSet set = PassthruResourceSet.this.getResourceHelper().getResourceSet(((Resource)object).getURI());
            if (set != null) {
                return set.getResources().add(object);
            }
            return super.add(object);
        }

        public boolean addAll(Collection collection) {
            if (collection.isEmpty()) {
                return false;
            }
            Iterator it = collection.iterator();
            WorkbenchResourceHelper helper = PassthruResourceSet.this.getResourceHelper();
            while (it.hasNext()) {
                Resource res = (Resource)it.next();
                if (helper.cacheResource(res)) continue;
                super.add((Object)res);
            }
            return true;
        }
    }
}

