/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.emf.workbench;

import com.ibm.etools.emf.workbench.ProjectResourceSet;
import com.ibm.etools.emf.workbench.ReferencedResource;
import com.ibm.etools.emf.workbench.ResourceSetWorkbenchSynchronizer;
import com.ibm.etools.emf.workbench.WorkbenchResourceHelper;
import com.ibm.etools.emf.workbench.nls.ResourceHandler;
import com.ibm.etools.emf.workbench.plugin.EMFWorkbenchPlugin;
import com.ibm.etools.logger.proxy.Logger;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.resource.impl.URIConverterImpl;

public class ProjectResourceSetImpl
extends ResourceSetImpl
implements ProjectResourceSet {
    private static final String copyright = "(c) Copyright IBM Corporation 2002.";
    private boolean isReleasing = false;
    private IProject project;
    private Hashtable lockTable = new Hashtable();
    protected List resourceHandlers = new ArrayList();
    protected ResourceSetWorkbenchSynchronizer synchronizer;

    protected ProjectResourceSetImpl() {
    }

    public ProjectResourceSetImpl(IProject aProject) {
        this.setProject(aProject);
        this.initializeSharedCacheListener();
    }

    protected void initializeSharedCacheListener() {
        EMFWorkbenchPlugin.getSharedCache().beginListening(this);
    }

    protected boolean isReleasing() {
        return this.isReleasing;
    }

    protected Resource delegatedGetResource(URI uri, boolean loadOnDemand) {
        Resource res = super.delegatedGetResource(uri, loadOnDemand);
        if (res == null) {
            res = this.getResourceFromHandlers(uri);
        }
        return res;
    }

    public Resource createResource(URI uri) {
        Resource result;
        if (this.isReleasing) {
            return null;
        }
        boolean isMapped = !((URIConverterImpl.URIMap)this.getURIConverter().getURIMap()).getURI(uri).equals((Object)uri);
        URI converted = uri;
        if (!isMapped) {
            converted = this.getURIConverter().normalize(uri);
        }
        if ((result = this.createResourceFromHandlers(converted)) == null) {
            result = super.createResource(converted);
        }
        if (result != null) {
            this.cacheSynchronizationStamp(result);
        }
        return result;
    }

    protected void demandLoad(Resource resource) throws IOException {
        if (!this.isReleasing) {
            super.demandLoad(resource);
        }
    }

    protected Resource createResourceFromHandlers(URI uri) {
        Resource resource = null;
        com.ibm.etools.emf.workbench.ResourceHandler handler = null;
        int i = 0;
        while (i < this.resourceHandlers.size()) {
            handler = (com.ibm.etools.emf.workbench.ResourceHandler)this.resourceHandlers.get(i);
            resource = handler.createResource(this, uri);
            if (resource != null) {
                return resource;
            }
            ++i;
        }
        return null;
    }

    protected Resource getResourceFromHandlers(URI uri) {
        if (this.isReleasing) {
            return null;
        }
        Resource resource = null;
        com.ibm.etools.emf.workbench.ResourceHandler handler = null;
        int i = 0;
        while (i < this.resourceHandlers.size()) {
            handler = (com.ibm.etools.emf.workbench.ResourceHandler)this.resourceHandlers.get(i);
            resource = handler.getResource(this, uri);
            if (resource != null) {
                return resource;
            }
            ++i;
        }
        return null;
    }

    public void release() {
        this.setIsReleasing(true);
        if (this.synchronizer != null) {
            this.synchronizer.dispose();
        }
        this.synchronizer = null;
        this.removeAndUnloadAllResources();
        this.resourceHandlers = null;
        this.eAdapters().clear();
        this.setProject(null);
        EMFWorkbenchPlugin.getSharedCache().stopListening(this);
    }

    protected void removeAndUnloadAllResources() {
        boolean caughtException = false;
        if (this.getResources().isEmpty()) {
            return;
        }
        ArrayList list = new ArrayList(this.getResources());
        this.getResources().clear();
        int size = list.size();
        int i = 0;
        while (i < size) {
            Resource res = (Resource)list.get(i);
            try {
                res.unload();
            }
            catch (RuntimeException ex) {
                Logger.getLogger().logError((Throwable)ex);
                caughtException = true;
            }
            ++i;
        }
        if (caughtException) {
            throw new RuntimeException("Exception(s) unloading resources - check log files");
        }
    }

    protected void setIsReleasing(boolean aBoolean) {
        this.isReleasing = aBoolean;
    }

    public IProject getProject() {
        return this.project;
    }

    protected void setProject(IProject project) {
        this.project = project;
    }

    public EObject getEObject(URI uri, boolean loadOnDemand) {
        if (this.isReleasing) {
            return null;
        }
        Resource resource = this.getResource(uri.trimFragment(), loadOnDemand);
        EObject result = null;
        if (resource != null && resource.isLoaded()) {
            result = resource.getEObject(uri.fragment());
        }
        if (result == null) {
            result = this.getEObjectFromHandlers(uri, loadOnDemand);
        }
        return result;
    }

    protected EObject getEObjectFromHandlers(URI uri, boolean loadOnDemand) {
        EObject obj = null;
        com.ibm.etools.emf.workbench.ResourceHandler handler = null;
        int i = 0;
        while (i < this.resourceHandlers.size()) {
            handler = (com.ibm.etools.emf.workbench.ResourceHandler)this.resourceHandlers.get(i);
            obj = handler.getEObjectFailed(this, uri, loadOnDemand);
            if (obj != null) {
                return obj;
            }
            ++i;
        }
        return null;
    }

    private void cacheSynchronizationStamp(Resource r) {
        if (r != null) {
            ReferencedResource refResource;
            WorkbenchResourceHelper helper = EMFWorkbenchPlugin.getResourceHelper();
            if (WorkbenchResourceHelper.isReferencedResource(r) && (refResource = (ReferencedResource)r).getSynchronizationStamp() <= 0L) {
                refResource.setSynchronizationStamp(helper.computeModificationStamp(refResource));
            }
        }
    }

    public boolean add(com.ibm.etools.emf.workbench.ResourceHandler resourceHandler) {
        return this.resourceHandlers.add(resourceHandler);
    }

    public void addFirst(com.ibm.etools.emf.workbench.ResourceHandler resourceHandler) {
        this.resourceHandlers.add(0, resourceHandler);
    }

    public boolean remove(com.ibm.etools.emf.workbench.ResourceHandler resourceHandler) {
        return this.resourceHandlers.remove(resourceHandler);
    }

    public ResourceSetWorkbenchSynchronizer getSynchronizer() {
        return this.synchronizer;
    }

    public void setSynchronizer(ResourceSetWorkbenchSynchronizer synchronizer) {
        this.synchronizer = synchronizer;
    }

    public void setResourceFactoryRegistry(Resource.Factory.Registry factoryReg) {
        if (this.resourceFactoryRegistry != null && factoryReg != null) {
            this.preserveEntries(factoryReg.getExtensionToFactoryMap(), this.resourceFactoryRegistry.getExtensionToFactoryMap());
            this.preserveEntries(factoryReg.getProtocolToFactoryMap(), this.resourceFactoryRegistry.getProtocolToFactoryMap());
        }
        super.setResourceFactoryRegistry(factoryReg);
    }

    protected void preserveEntries(Map map1, Map map2) {
        if (map2.isEmpty()) {
            return;
        }
        Iterator it = map2.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            if (map1.containsKey(entry.getKey())) continue;
            map1.put(entry.getKey(), entry.getValue());
        }
    }

    public Resource getResource(URI uri, boolean loadOnDemand) {
        if (this.isReleasing) {
            return null;
        }
        URIConverter theURIConverter = this.getURIConverter();
        URI normalizedURI = theURIConverter.normalize(uri);
        Resource resource = null;
        int size = this.getResources().size();
        int i = 0;
        while (i < size) {
            resource = (Resource)this.resources.get(i);
            if (theURIConverter.normalize(resource.getURI()).equals((Object)normalizedURI)) {
                if (loadOnDemand && !resource.isLoaded()) {
                    try {
                        this.demandLoad(resource);
                    }
                    catch (Resource.IOWrappedException exception) {
                        throw new WrappedException(exception.getWrappedException());
                    }
                    catch (IOException exception) {
                        throw new WrappedException((Exception)exception);
                    }
                }
                return resource;
            }
            ++i;
        }
        resource = this.delegatedGetResource(uri, loadOnDemand);
        if (resource != null) {
            return resource;
        }
        if (loadOnDemand) {
            resource = this.demandCreateResource(uri);
            if (resource == null) {
                throw new RuntimeException(ResourceHandler.getString("Cannot_Create_Resource_Error_", new Object[]{uri}));
            }
            try {
                this.demandLoad(resource);
            }
            catch (Resource.IOWrappedException exception) {
                throw new WrappedException(exception.getWrappedException());
            }
            catch (IOException exception) {
                throw new WrappedException((Exception)exception);
            }
            return resource;
        }
        return null;
    }
}

