/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.emf.workbench;

import com.ibm.etools.emf.workbench.ISynchronizerExtender;
import com.ibm.etools.emf.workbench.ProjectResourceSet;
import com.ibm.etools.emf.workbench.ReferencedResource;
import com.ibm.etools.emf.workbench.WorkbenchResourceHelper;
import com.ibm.etools.emf.workbench.plugin.EMFWorkbenchPlugin;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;

public class ResourceSetWorkbenchSynchronizer
implements IResourceChangeListener,
IResourceDeltaVisitor {
    private static final String copyright = "(c) Copyright IBM Corporation 2002.";
    protected static final String CLASS_EXTENSION = "class";
    protected static final String JAVA_EXTENSION = "java";
    protected IProject project;
    protected ResourceSet resourceSet;
    protected Set recentlySavedFiles = new HashSet();
    protected int currentEventType = -1;
    protected List preBuildFiles = new ArrayList();
    protected List extenders;
    protected IResourceDelta currentProjectDelta;
    protected List deferredRemoveResources = new ArrayList();
    protected List deferredUnloadResources = new ArrayList();

    public ResourceSetWorkbenchSynchronizer(ResourceSet aResourceSet, IProject aProject) {
        this.resourceSet = aResourceSet;
        this.project = aProject;
        if (aResourceSet != null && aResourceSet instanceof ProjectResourceSet) {
            ((ProjectResourceSet)aResourceSet).setSynchronizer(this);
        }
        this.initialize();
    }

    protected IProject getProject() {
        return this.project;
    }

    public void resourceChanged(IResourceChangeEvent event) {
        this.currentEventType = event.getType();
        this.currentProjectDelta = null;
        if ((this.currentEventType == 2 || this.currentEventType == 4) && event.getResource().equals((Object)this.getProject())) {
            this.release();
            this.notifyExtendersOfClose();
        }
        if (this.currentEventType == 8) {
            this.preBuildFiles.clear();
        }
        try {
            try {
                this.acceptDelta(event);
                this.notifyExtendersIfNecessary();
                this.processDeferredResources();
            }
            catch (Exception e) {
                e.printStackTrace();
                Object var4_3 = null;
                this.deferredRemoveResources.clear();
                this.deferredUnloadResources.clear();
            }
            Object var4_2 = null;
            this.deferredRemoveResources.clear();
            this.deferredUnloadResources.clear();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.deferredRemoveResources.clear();
            this.deferredUnloadResources.clear();
            throw throwable;
        }
    }

    private void processDeferredResources() {
        this.processDeferredRemovedResources();
        this.processDeferredUnloadedResources();
    }

    protected void processDeferredRemovedResources() {
        Resource resource = null;
        int i = 0;
        while (i < this.deferredRemoveResources.size()) {
            resource = (Resource)this.deferredRemoveResources.get(i);
            this.resourceSet.getResources().remove(resource);
            resource.unload();
            ++i;
        }
    }

    protected void processDeferredUnloadedResources() {
        Resource resource = null;
        int i = 0;
        while (i < this.deferredUnloadResources.size()) {
            resource = (Resource)this.deferredUnloadResources.get(i);
            resource.unload();
            ++i;
        }
    }

    protected void acceptDelta(IResourceChangeEvent event) {
        IResourceDelta delta = event.getDelta();
        if (delta != null) {
            try {
                delta.accept((IResourceDeltaVisitor)this);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    protected void notifyExtendersIfNecessary() {
        if (this.currentEventType != 8 || this.extenders == null || this.currentProjectDelta == null) {
            return;
        }
        int i = 0;
        while (i < this.extenders.size()) {
            ISynchronizerExtender extender = (ISynchronizerExtender)this.extenders.get(i);
            extender.projectChanged(this.currentProjectDelta);
            ++i;
        }
    }

    protected void notifyExtendersOfClose() {
        if (this.extenders != null && !this.extenders.isEmpty()) {
            int i = 0;
            while (i < this.extenders.size()) {
                ISynchronizerExtender extender = (ISynchronizerExtender)this.extenders.get(i);
                extender.projectClosed();
                ++i;
            }
        }
    }

    public boolean visit(IResourceDelta delta) {
        IResource resource = delta.getResource();
        if (resource != null) {
            if (resource.getType() == 4) {
                IProject project = (IProject)resource;
                if (this.isInterrestedInProject(project)) {
                    this.currentProjectDelta = delta;
                    return true;
                }
                return false;
            }
            if (resource.getType() == 1 && this.isInterrestedInFile((IFile)resource)) {
                if (delta.getKind() == 2) {
                    this.removedResource((IFile)resource);
                } else if (delta.getKind() == 1) {
                    this.addedResource((IFile)resource);
                } else if ((delta.getFlags() & 0x1000) != 0 || (delta.getFlags() & 0x2000) != 0) {
                    this.movedResource((IFile)resource);
                } else if (delta.getKind() == 4 && (delta.getFlags() & 0x100) != 0) {
                    this.changedResource((IFile)resource);
                }
                return false;
            }
        }
        return true;
    }

    protected boolean removedResource(IFile aFile) {
        return this.processResource(aFile, true);
    }

    protected boolean addedResource(IFile aFile) {
        return this.processResource(aFile, false);
    }

    protected boolean processResource(IFile aFile, boolean isRemove) {
        if (this.currentEventType == 1 && this.preBuildFiles.contains(aFile)) {
            return false;
        }
        Resource resource = this.getResource(aFile);
        if (resource != null) {
            if (resource.isModified()) {
                EMFWorkbenchPlugin.getResourceHelper();
                if (WorkbenchResourceHelper.isReferencedResource(resource)) {
                    ReferencedResource refRes = (ReferencedResource)resource;
                    if (!refRes.shouldForceRefresh()) {
                        return false;
                    }
                } else {
                    return false;
                }
            }
            if (this.currentEventType == 8) {
                this.preBuildFiles.add(aFile);
            }
            if (isRemove) {
                this.deferredRemoveResources.add(resource);
            } else {
                this.deferredUnloadResources.add(resource);
            }
            return true;
        }
        return false;
    }

    protected boolean movedResource(IFile aFile) {
        return this.removedResource(aFile);
    }

    protected boolean changedResource(IFile aFile) {
        return this.processResource(aFile, false);
    }

    protected Resource getResource(IFile aFile) {
        return this.resourceSet.getResource(URI.createPlatformResourceURI((String)aFile.getFullPath().toString()), false);
    }

    public void preSave(IFile aFile) {
        if (aFile != null) {
            this.recentlySavedFiles.add(aFile);
        }
    }

    public void postSave(IFile aFile) {
        if (aFile != null && this.currentEventType == 1) {
            this.recentlySavedFiles.remove(aFile);
        }
    }

    protected boolean isInterrestedInProject(IProject aProject) {
        return aProject.equals((Object)this.getProject());
    }

    protected boolean isInterrestedInFile(IFile aFile) {
        String extension = aFile.getFileExtension();
        if (CLASS_EXTENSION.equals(extension) || JAVA_EXTENSION.equals(extension)) {
            return false;
        }
        if (this.recentlySavedFiles.contains(aFile)) {
            this.postSave(aFile);
            return false;
        }
        return true;
    }

    public IWorkspace getWorkspace() {
        if (this.getProject() == null) {
            return ResourcesPlugin.getWorkspace();
        }
        return this.getProject().getWorkspace();
    }

    protected void initialize() {
        this.getWorkspace().addResourceChangeListener((IResourceChangeListener)this, 15);
    }

    public void dispose() {
        this.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
    }

    protected void release() {
        if (EMFWorkbenchPlugin.isActivated()) {
            if (this.resourceSet instanceof ProjectResourceSet) {
                ((ProjectResourceSet)this.resourceSet).release();
            }
            this.dispose();
        }
    }

    public void addExtender(ISynchronizerExtender extender) {
        if (this.extenders == null) {
            this.extenders = new ArrayList(3);
        }
        this.extenders.add(extender);
    }

    public void removeExtender(ISynchronizerExtender extender) {
        if (this.extenders == null) {
            return;
        }
        this.extenders.remove(extender);
    }

    public String toString() {
        return this.getClass().getName() + '(' + this.getProject().getName() + ')';
    }
}

