/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.emf.workbench;

import com.ibm.etools.emf.workbench.ReferencedResource;
import com.ibm.etools.emf.workbench.ResourceStateInputProvider;
import com.ibm.etools.emf.workbench.ResourceStateValidator;
import com.ibm.etools.emf.workbench.ResourceStateValidatorPresenter;
import com.ibm.etools.emf.workbench.WorkbenchResourceHelper;
import com.ibm.etools.emf.workbench.plugin.EMFWorkbenchPlugin;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.ecore.resource.Resource;

public class ResourceStateValidatorImpl
implements ResourceStateValidator {
    protected ResourceStateInputProvider provider;
    protected Map lastNonRefreshStateMap;
    protected boolean isCheckingConsistency;

    public ResourceStateValidatorImpl(ResourceStateInputProvider aProvider) {
        this.provider = aProvider;
    }

    public void checkActivation(ResourceStateValidatorPresenter presenter) throws CoreException {
        this.checkConsistency(presenter);
    }

    public void lostActivation(ResourceStateValidatorPresenter presenter) throws CoreException {
        this.checkConsistency(presenter);
    }

    public boolean checkSave(ResourceStateValidatorPresenter presenter) throws CoreException {
        if (presenter == null) {
            return false;
        }
        if (!this.provider.isDirty()) {
            return false;
        }
        List inconsistentResources = this.getInconsistentResources();
        List inconsistentFiles = this.getFiles(inconsistentResources);
        if ((inconsistentFiles = this.addOtherInconsistentFiles(inconsistentFiles)) == null || inconsistentFiles.isEmpty()) {
            return true;
        }
        return presenter.promptForInconsistentFileOverwrite(inconsistentFiles);
    }

    public boolean checkReadOnly() {
        boolean result = this.checkReadOnlyResources();
        if (!result) {
            result = this.checkReadOnlyNonResourceFiles();
        }
        return result;
    }

    private boolean checkReadOnlyNonResourceFiles() {
        List files = this.provider.getNonResourceFiles();
        if (files == null || files.isEmpty()) {
            return false;
        }
        int size = files.size();
        IFile file = null;
        int i = 0;
        while (i < size) {
            file = (IFile)files.get(i);
            if (file.isReadOnly()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean checkReadOnlyResources() {
        List resources = this.provider.getResources();
        if (resources == null || resources.isEmpty()) {
            return false;
        }
        WorkbenchResourceHelper helper = EMFWorkbenchPlugin.getResourceHelper();
        int size = resources.size();
        Resource res = null;
        IFile file = null;
        int i = 0;
        while (i < size) {
            res = (Resource)resources.get(i);
            file = helper.getFile(res);
            if (file != null && file.isReadOnly()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected void checkConsistency(ResourceStateValidatorPresenter presenter) throws CoreException {
        if (this.isCheckingConsistency || presenter == null) {
            return;
        }
        this.isCheckingConsistency = true;
        try {
            List inconsistentFiles;
            List inconsistentResources;
            block10: {
                block9: {
                    inconsistentResources = this.getInconsistentResources();
                    inconsistentFiles = this.getFiles(inconsistentResources);
                    inconsistentFiles = this.addOtherInconsistentFiles(inconsistentFiles);
                    if (inconsistentFiles == null) break block9;
                    if (!inconsistentFiles.isEmpty()) break block10;
                }
                Object var6_4 = null;
                this.isCheckingConsistency = false;
                return;
            }
            boolean shouldRefreshFiles = true;
            if (!this.anyFileChangedSinceLastRefreshPrompt(inconsistentFiles)) {
                Object var6_5 = null;
                this.isCheckingConsistency = false;
                return;
            }
            this.clearLastNonRefreshStateMap();
            shouldRefreshFiles = presenter.promptForInconsistentFileRefresh(inconsistentFiles);
            if (shouldRefreshFiles) {
                this.refreshFiles(inconsistentFiles, inconsistentResources);
            } else {
                this.cacheLastNonRefreshFileStamps(inconsistentFiles);
            }
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            this.isCheckingConsistency = false;
            throw throwable;
        }
        Object var6_6 = null;
        this.isCheckingConsistency = false;
    }

    private void cacheLastNonRefreshFileStamps(List inconsistentFiles) {
        if (inconsistentFiles != null && !inconsistentFiles.isEmpty()) {
            Map map = this.getLastNonRefreshStateMap();
            WorkbenchResourceHelper helper = EMFWorkbenchPlugin.getResourceHelper();
            IFile file = null;
            long stamp = 0L;
            int i = 0;
            while (i < inconsistentFiles.size()) {
                file = (IFile)inconsistentFiles.get(i);
                stamp = helper.computeModificationStamp(file);
                map.put(file, new Long(stamp));
                ++i;
            }
        }
    }

    private void cacheValidateState(IStatus aStatus, List readOnlyResources, List roNonResourceFiles) {
        if (aStatus.isOK()) {
            if (readOnlyResources != null && !readOnlyResources.isEmpty()) {
                ReferencedResource res = null;
                int i = 0;
                while (i < readOnlyResources.size()) {
                    res = (ReferencedResource)readOnlyResources.get(i);
                    res.setSynchronizationStamp(this.computeModificationStamp(res));
                    ++i;
                }
            }
            this.provider.cacheNonResourceValidateState(roNonResourceFiles);
        }
    }

    private void clearLastNonRefreshStateMap() {
        if (this.lastNonRefreshStateMap != null) {
            this.lastNonRefreshStateMap.clear();
        }
    }

    private boolean anyFileChangedSinceLastRefreshPrompt(List inconsistentFiles) {
        if (inconsistentFiles == null || inconsistentFiles.isEmpty()) {
            return false;
        }
        if (this.lastNonRefreshStateMap == null || this.lastNonRefreshStateMap.isEmpty()) {
            return true;
        }
        int size = inconsistentFiles.size();
        IFile file = null;
        Long stamp = null;
        WorkbenchResourceHelper helper = EMFWorkbenchPlugin.getResourceHelper();
        int i = 0;
        while (i < size) {
            file = (IFile)inconsistentFiles.get(i);
            stamp = (Long)this.getLastNonRefreshStateMap().get(file);
            if (stamp == null) {
                return true;
            }
            if (stamp.longValue() != helper.computeModificationStamp(file)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected List addOtherInconsistentFiles(List inconsistentFiles) {
        if (inconsistentFiles == null || inconsistentFiles.isEmpty()) {
            return this.getNonResourceInconsistentFiles();
        }
        List nonResFiles = this.getNonResourceInconsistentFiles();
        if (nonResFiles != null) {
            inconsistentFiles.addAll(nonResFiles);
        }
        return inconsistentFiles;
    }

    private List getNonResourceInconsistentFiles() {
        List files = this.provider.getNonResourceInconsistentFiles();
        if (files != null && !files.isEmpty()) {
            return files;
        }
        files = this.provider.getNonResourceFiles();
        if (files == null || files.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<IFile> inconsistent = null;
        int size = files.size();
        IFile file = null;
        int i = 0;
        while (i < size) {
            file = (IFile)files.get(i);
            if (file.isAccessible() && !file.isSynchronized(0)) {
                if (inconsistent == null) {
                    inconsistent = new ArrayList<IFile>();
                }
                inconsistent.add(file);
            }
            ++i;
        }
        if (inconsistent == null) {
            inconsistent = Collections.EMPTY_LIST;
        }
        return inconsistent;
    }

    protected List getInconsistentResources() {
        List mofResources = this.provider.getResources();
        ArrayList<ReferencedResource> inconsistent = null;
        int size = mofResources.size();
        Resource res = null;
        ReferencedResource refRes = null;
        WorkbenchResourceHelper helper = EMFWorkbenchPlugin.getResourceHelper();
        int i = 0;
        while (i < size) {
            res = (Resource)mofResources.get(i);
            if (WorkbenchResourceHelper.isReferencedResource(res) && !(refRes = (ReferencedResource)res).isConsistent()) {
                if (inconsistent == null) {
                    inconsistent = new ArrayList<ReferencedResource>();
                }
                inconsistent.add(refRes);
            }
            ++i;
        }
        if (inconsistent == null) {
            inconsistent = Collections.EMPTY_LIST;
        }
        return inconsistent;
    }

    protected List getFiles(List refResources) {
        ArrayList<IFile> files = new ArrayList<IFile>(refResources.size());
        IFile file = null;
        ReferencedResource refRes = null;
        int i = 0;
        while (i < refResources.size()) {
            refRes = (ReferencedResource)refResources.get(i);
            file = refRes.getFile();
            if (file != null) {
                files.add(file);
            }
            ++i;
        }
        return files;
    }

    public IStatus validateState(ResourceStateValidatorPresenter presenter) throws CoreException {
        List roFiles = null;
        List[] readOnly = this.selectReadOnlyResources(this.provider.getResources());
        List roResources = readOnly[0];
        roFiles = readOnly[1];
        List nonResROFiles = this.selectReadOnlyFiles(this.provider.getNonResourceFiles());
        if (nonResROFiles != null) {
            if (roFiles == null) {
                roFiles = nonResROFiles;
            } else {
                roFiles.addAll(nonResROFiles);
            }
        }
        if (roFiles == null || roFiles.isEmpty()) {
            return ResourceStateValidator.OK_STATUS;
        }
        IFile[] files = new IFile[roFiles.size()];
        roFiles.toArray(files);
        Object ctx = presenter != null ? presenter.getValidateEditContext() : null;
        IStatus result = ResourcesPlugin.getWorkspace().validateEdit(files, ctx);
        this.cacheValidateState(result, roResources, nonResROFiles);
        if (!result.isOK()) {
            this.checkConsistency(presenter);
        }
        return result;
    }

    private List selectReadOnlyFiles(List files) {
        if (files == null || files.isEmpty()) {
            return files;
        }
        int size = files.size();
        ArrayList<IFile> readOnly = null;
        IFile file = null;
        int i = 0;
        while (i < size) {
            file = (IFile)files.get(i);
            if (file.isReadOnly()) {
                if (readOnly == null) {
                    readOnly = new ArrayList<IFile>(size);
                }
                readOnly.add(file);
            }
            ++i;
        }
        return readOnly;
    }

    private List[] selectReadOnlyResources(List resources) {
        if (resources == null || resources.isEmpty()) {
            return new List[]{resources, null};
        }
        WorkbenchResourceHelper helper = EMFWorkbenchPlugin.getResourceHelper();
        IFile file = null;
        int size = resources.size();
        Resource res = null;
        ArrayList<Resource> readOnly = null;
        ArrayList<IFile> roFiles = null;
        int i = 0;
        while (i < size) {
            res = (Resource)resources.get(i);
            file = helper.getFile(res);
            if (file != null && file.isReadOnly()) {
                if (readOnly == null) {
                    readOnly = new ArrayList<Resource>(size);
                }
                readOnly.add(res);
                if (roFiles == null) {
                    roFiles = new ArrayList<IFile>(size);
                }
                roFiles.add(file);
            }
            ++i;
        }
        return new List[]{readOnly, roFiles};
    }

    protected long computeModificationStamp(ReferencedResource resource) {
        return EMFWorkbenchPlugin.getResourceHelper().computeModificationStamp(resource);
    }

    private void filterNonReadOnlyResources(List roResources, List roFiles) {
        WorkbenchResourceHelper helper = EMFWorkbenchPlugin.getResourceHelper();
        ArrayList<Resource> removedResources = null;
        Resource res = null;
        IFile file = null;
        int i = 0;
        while (i < roResources.size()) {
            res = (Resource)roResources.get(i);
            file = helper.getFile(res);
            if (file != null) {
                if (file.isReadOnly()) {
                    roFiles.add(file);
                    if (removedResources == null) {
                        removedResources = new ArrayList(roResources.size());
                    }
                    removedResources.add(res);
                } else {
                    if (removedResources == null) {
                        removedResources = new ArrayList<Resource>(roResources.size());
                    }
                    removedResources.add(res);
                }
            }
            ++i;
        }
        if (removedResources != null) {
            roResources.removeAll(removedResources);
        }
    }

    private void filterNonReadOnlyFiles(List roFiles) {
        ArrayList<IFile> removedFiles = null;
        IFile file = null;
        int i = 0;
        while (i < roFiles.size()) {
            file = (IFile)roFiles.get(i);
            if (file.isReadOnly()) {
                if (removedFiles == null) {
                    removedFiles = new ArrayList<IFile>(roFiles.size());
                }
                removedFiles.add(file);
            }
            ++i;
        }
        if (removedFiles != null) {
            roFiles.removeAll(removedFiles);
        }
    }

    protected void refreshFiles(List someFiles, List inconsitentResources) throws CoreException {
        RefreshRunnable runnable = new RefreshRunnable(someFiles, inconsitentResources);
        ResourcesPlugin.getWorkspace().run((IWorkspaceRunnable)runnable, null);
        if (runnable.getThrownException() != null) {
            throw runnable.getThrownException();
        }
    }

    protected void primRefreshFiles(List someFiles) throws CoreException {
        int size = someFiles.size();
        IFile file = null;
        int i = 0;
        while (i < size) {
            file = (IFile)someFiles.get(i);
            if (!file.isSynchronized(0)) {
                file.refreshLocal(1, null);
            } else {
                this.refreshResource(file);
            }
            ++i;
        }
    }

    protected void refreshResource(IFile file) {
        Resource res = EMFWorkbenchPlugin.getResourceHelper().getResource(file);
        if (res != null) {
            res.unload();
        }
    }

    protected void prepareResourcesForRefresh(List refResources) {
        ReferencedResource res = null;
        int i = 0;
        while (i < refResources.size()) {
            res = (ReferencedResource)refResources.get(i);
            res.setForceRefresh(true);
            ++i;
        }
    }

    protected Map getLastNonRefreshStateMap() {
        if (this.lastNonRefreshStateMap == null) {
            this.lastNonRefreshStateMap = new HashMap();
        }
        return this.lastNonRefreshStateMap;
    }

    class RefreshRunnable
    implements IWorkspaceRunnable {
        CoreException thrownException;
        List files;
        List resources;

        RefreshRunnable(List someFiles, List inconsistentResources) {
            this.files = someFiles;
            this.resources = inconsistentResources;
        }

        public CoreException getThrownException() {
            return this.thrownException;
        }

        public void run(IProgressMonitor aMonitor) {
            try {
                ResourceStateValidatorImpl.this.prepareResourcesForRefresh(this.resources);
                ResourceStateValidatorImpl.this.primRefreshFiles(this.files);
            }
            catch (CoreException e) {
                this.thrownException = e;
            }
        }
    }
}

