/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.emf.workbench;

import com.ibm.etools.emf.workbench.ProjectUtilities;
import com.ibm.etools.emf.workbench.ResourceSetWorkbenchSynchronizer;
import com.ibm.etools.emf.workbench.WorkbenchByteArrayOutputStream;
import com.ibm.etools.emf.workbench.WorkbenchResourceHelper;
import com.ibm.etools.emf.workbench.WorkbenchURIConverter;
import com.ibm.etools.emf.workbench.plugin.EMFWorkbenchPlugin;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.URIConverterImpl;

public class WorkbenchURIConverterImpl
extends URIConverterImpl
implements WorkbenchURIConverter {
    private static final String copyright = "(c) Copyright IBM Corporation 2001.";
    private static final IWorkspaceRoot WORKSPACE_ROOT = ResourcesPlugin.getWorkspace().getRoot();
    private static final String FILE_PROTOCOL = "file";
    private static final IPath INVALID_PATH = new Path("!!!!~!!!!");
    private static final IFile INVALID_FILE = WORKSPACE_ROOT.getFile(INVALID_PATH.append(INVALID_PATH));
    protected boolean forceSaveRelative = false;
    protected List inputContainers;
    protected IContainer outputContainer;
    protected ResourceSetWorkbenchSynchronizer resourceSetSynchronizer;

    public WorkbenchURIConverterImpl() {
    }

    public WorkbenchURIConverterImpl(IContainer anInputContainer) {
        this(anInputContainer, (ResourceSetWorkbenchSynchronizer)null);
    }

    public WorkbenchURIConverterImpl(IContainer aContainer, ResourceSetWorkbenchSynchronizer aSynchronizer) {
        this(aContainer, null, aSynchronizer);
    }

    public WorkbenchURIConverterImpl(IContainer anInputContainer, IContainer anOutputContainer) {
        this(anInputContainer, anOutputContainer, null);
    }

    public WorkbenchURIConverterImpl(IContainer anInputContainer, IContainer anOutputContainer, ResourceSetWorkbenchSynchronizer aSynchronizer) {
        this.addInputContainer(anInputContainer);
        this.setOutputContainer(anOutputContainer);
        this.resourceSetSynchronizer = aSynchronizer;
    }

    public void addInputContainer(IContainer aContainer) {
        if (aContainer != null && !this.getInputContainers().contains(aContainer)) {
            this.getInputContainers().add(aContainer);
        }
    }

    public void addInputContainers(List containers) {
        int i = 0;
        while (i < containers.size()) {
            this.addInputContainer((IContainer)containers.get(i));
            ++i;
        }
    }

    public boolean removeInputContainer(IContainer aContainer) {
        return this.getInputContainers().remove(aContainer);
    }

    public List getInputContainers() {
        if (this.inputContainers == null) {
            this.inputContainers = new ArrayList();
        }
        return this.inputContainers;
    }

    public IContainer getInputContainer() {
        if (!this.getInputContainers().isEmpty()) {
            return (IContainer)this.getInputContainers().get(0);
        }
        return null;
    }

    public IContainer getOutputContainer() {
        if (this.outputContainer == null) {
            this.outputContainer = this.getInputContainer();
        }
        return this.outputContainer;
    }

    public void setOutputContainer(IContainer newOutputContainer) {
        this.outputContainer = newOutputContainer;
    }

    public IFile getOutputFile(IPath aPath) {
        IFile file = null;
        if (this.getOutputContainer() != null) {
            if (this.forceSaveRelative) {
                return this.primGetOutputFile(aPath);
            }
            file = this.getOutputFileForPathWithContainerSegments(aPath);
            if (file != null) {
                return file;
            }
            return this.primGetOutputFile(aPath);
        }
        return file;
    }

    protected IFile primGetOutputFile(IPath aPath) {
        return this.primGetFile(this.getOutputContainer(), aPath);
    }

    protected IFile getOutputFileForPathWithContainerSegments(IPath aPath) {
        IContainer out = this.getOutputContainer();
        return this.getFileForPathWithContainerSegments(aPath, out, false);
    }

    protected IFile getFileForPathWithContainerSegments(IPath aPath, IContainer container, boolean testExists) {
        IFile file;
        IPath containerPath = container.getProjectRelativePath();
        if (!containerPath.isEmpty() && (file = this.getFileForMatchingPath(aPath, containerPath, container)) != null) {
            if (testExists && file.exists()) {
                return file;
            }
            return file;
        }
        containerPath = container.getFullPath();
        file = this.getFileForMatchingPath(aPath, containerPath, container);
        return file;
    }

    protected IFile getFileForMatchingPath(IPath containerPath, IPath sourcePath, IContainer container) {
        int matches = 0;
        matches = containerPath.matchingFirstSegments(sourcePath);
        if (matches > 0 && matches == sourcePath.segmentCount()) {
            IPath loadPath = containerPath.removeFirstSegments(matches);
            return this.primGetFile(container, loadPath);
        }
        return null;
    }

    public IFile getFile(String uri) {
        return this.getFile((IPath)new Path(uri));
    }

    public IFile getFile(IPath path) {
        IFile file = null;
        if (this.getInputContainer() != null) {
            path = path.makeRelative();
            Iterator it = this.getInputContainers().iterator();
            while (it.hasNext()) {
                IContainer con = (IContainer)it.next();
                file = this.getInputFile(con, path);
                if (file == null || !file.exists()) continue;
                return file;
            }
        }
        if (file == null) {
            return INVALID_FILE;
        }
        return file;
    }

    public IFile getOutputFile(String uri) {
        return this.getOutputFile((IPath)new Path(uri));
    }

    public IFile getInputFile(IContainer con, IPath path) {
        IFile file = null;
        if (WORKSPACE_ROOT.equals((Object)con) && path.segmentCount() < 2) {
            path = INVALID_PATH.append(path);
        }
        if ((file = this.primGetFile(con, path)) == null || !file.exists()) {
            file = this.getFileForPathWithContainerSegments(path, con, true);
        }
        return file;
    }

    protected IFile primGetFile(IContainer container, IPath path) {
        try {
            return container.getFile(path);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
    }

    public boolean canGetUnderlyingResource(String aFileName) {
        IFile file = this.getFile(aFileName);
        return file != null && file.exists();
    }

    public boolean isForceSaveRelative() {
        return this.forceSaveRelative;
    }

    public void setForceSaveRelative(boolean forceSaveRelative) {
        this.forceSaveRelative = forceSaveRelative;
    }

    public URI normalize(URI uri) {
        URI result = uri;
        String fragment = null;
        if (uri.hasFragment()) {
            fragment = uri.fragment();
            result = uri.trimFragment();
        }
        result = this.getInternalURIMap().getURI(result);
        if (EMFWorkbenchPlugin.getResourceHelper().isPlatformResourceURI(result)) {
            return this.appendFragment(result, fragment);
        }
        String protocol = result.scheme();
        if (protocol == null || FILE_PROTOCOL.equals(protocol)) {
            URI fileSearchURI = this.normalizeFileOrEmptyProtocol(result, fragment);
            if (fileSearchURI != null) {
                return fileSearchURI;
            }
        } else if ("workspace".equals(protocol)) {
            return this.normalizeWorkspaceProtocol(result, fragment);
        }
        return super.normalize(uri);
    }

    protected URI normalizeWorkspaceProtocol(URI aWorkspaceURI, String fragment) {
        String uriString = aWorkspaceURI.toString();
        uriString = uriString.substring("workspace".length() + 1);
        URI result = URI.createPlatformResourceURI((String)uriString);
        if (fragment != null) {
            result = this.appendFragment(aWorkspaceURI, fragment);
        }
        return result;
    }

    protected URI normalizeFileOrEmptyProtocol(URI aFileUri, String fragment) {
        URI result = null;
        Path path = new Path(aFileUri.toString());
        IFile file = this.getFile((IPath)path);
        if (file == null || !file.exists()) {
            file = this.getOutputFile((IPath)path);
        }
        if (file != null) {
            result = URI.createPlatformResourceURI((String)file.getFullPath().toString());
            result = this.appendFragment(result, fragment);
        }
        return result;
    }

    protected URI appendFragment(URI result, String fragment) {
        if (fragment != null) {
            return result.appendFragment(fragment);
        }
        return result;
    }

    public IFile getOutputFileWithMappingApplied(String uri) {
        URI converted = this.getInternalURIMap().getURI(URI.createURI((String)uri));
        return this.getOutputFile((IPath)new Path(converted.toString()));
    }

    public OutputStream createPlatformResourceOutputStream(String platformResourcePath) throws IOException {
        IFile file = WORKSPACE_ROOT.getFile((IPath)new Path(platformResourcePath));
        ProjectUtilities.ensureContainerNotReadOnly((IResource)file);
        return new WorkbenchByteArrayOutputStream(file, this.resourceSetSynchronizer);
    }

    public URI deNormalize(URI uri) {
        IFile aFile;
        WorkbenchResourceHelper helper = EMFWorkbenchPlugin.getResourceHelper();
        if (helper.isPlatformResourceURI(uri) && (aFile = helper.getPlatformFile(uri)) != null) {
            IProject fileProject = aFile.getProject();
            if (this.resourceSetSynchronizer.getProject() == fileProject) {
                return this.getContainerRelativeURI(aFile);
            }
        }
        return uri;
    }

    protected URI getContainerRelativeURI(IFile aFile) {
        IPath path = EMFWorkbenchPlugin.getResourceHelper().getPathFromContainers(this.inputContainers, aFile.getFullPath());
        if (path != null) {
            return URI.createURI((String)path.toString());
        }
        return null;
    }

    public InputStream createPlatformResourceInputStream(String platformResourcePath) throws IOException {
        IFile file = URIConverterImpl.workspaceRoot.getFile((IPath)new Path(platformResourcePath));
        try {
            block5: {
                if (!file.isLocal(1) || !file.isSynchronized(1)) {
                    try {
                        file.refreshLocal(1, null);
                    }
                    catch (CoreException ce) {
                        if (ce.getStatus().getCode() == 380) break block5;
                        throw ce;
                    }
                }
            }
            return file.getContents();
        }
        catch (CoreException exception) {
            throw new Resource.IOWrappedException((Exception)((Object)exception));
        }
    }
}

