/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.emf.workbench;

import com.ibm.etools.emf.workbench.ExceptionHelper;
import com.ibm.etools.emf.workbench.IWrappedException;
import java.io.PrintStream;
import java.io.PrintWriter;

public class WrappedRuntimeException
extends RuntimeException
implements IWrappedException {
    private static final String copyright = "(c) Copyright IBM Corporation 2001.";
    protected Exception nestedException;

    public WrappedRuntimeException() {
    }

    public WrappedRuntimeException(Exception e) {
        this.setNestedException(e);
    }

    public WrappedRuntimeException(String s) {
        super(s);
    }

    public WrappedRuntimeException(String s, Exception e) {
        super(s);
        this.setNestedException(e);
    }

    public String[] getAllMessages() {
        return ExceptionHelper.getAllMessages(this);
    }

    public String getConcatenatedMessages() {
        return ExceptionHelper.getConcatenatedMessages(this);
    }

    public Exception getInnerMostNestedException() {
        Exception n = this.getNestedException();
        if (n == null) {
            return this;
        }
        if (n instanceof IWrappedException) {
            return ((IWrappedException)((Object)n)).getInnerMostNestedException();
        }
        return n;
    }

    public Exception getNestedException() {
        return this.nestedException;
    }

    public void printStackTrace() {
        this.printStackTrace(System.err);
    }

    public void printStackTrace(PrintStream s) {
        if (this.nestedException != null) {
            s.println(this);
            s.println("Stack trace of nested exception:");
            this.nestedException.printStackTrace(s);
        } else {
            super.printStackTrace(s);
        }
    }

    public void printStackTrace(PrintWriter s) {
        if (this.nestedException != null) {
            s.println(this);
            s.println("Stack trace of nested exception:");
            this.nestedException.printStackTrace(s);
        } else {
            super.printStackTrace(s);
        }
    }

    public void setNestedException(Exception newNestedException) {
        this.nestedException = newNestedException;
    }
}

