/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.emf.event.impl;

import com.ibm.etools.emf.event.EObjectDescriptor;
import com.ibm.etools.emf.event.Event;
import com.ibm.etools.emf.event.EventFactory;
import com.ibm.etools.emf.event.FeatureKind;
import com.ibm.etools.emf.event.Setting;
import com.ibm.etools.emf.event.impl.EventHelper;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;

public class EventWriterHelper
extends EventHelper {
    int nextEventId = 0;
    private Map eObjectToDataMap = null;

    private Map getEObjectMap() {
        if (this.eObjectToDataMap == null) {
            this.eObjectToDataMap = new HashMap();
        }
        return this.eObjectToDataMap;
    }

    private EObjectData getEObjectData(EObject eObj) {
        Map eObjectToDataMap = this.getEObjectMap();
        return (EObjectData)eObjectToDataMap.get(eObj);
    }

    private EObjectData createEObjectData(EObject eObj) {
        Map eObjectToDataMap = this.getEObjectMap();
        EObjectData data = new EObjectData();
        eObjectToDataMap.put(eObj, data);
        return data;
    }

    public EventWriterHelper(Notifier topNotifier, ResourceSet defaultResourceSet) {
        super(topNotifier, defaultResourceSet);
    }

    public void scanOriginalObjects(EList objects) {
        int i = 0;
        int size = objects.size();
        while (i < size) {
            EObject obj = (EObject)objects.get(i);
            this.createEObjectData(obj);
            EList contents = obj.eContents();
            this.scanOriginalObjects(contents);
            ++i;
        }
    }

    public void scanOriginalObjects(ResourceSet resSet) {
        int r = 0;
        int size = resSet.getResources().size();
        while (r < size) {
            Resource res = (Resource)resSet.getResources().get(r);
            this.scanOriginalObjects(res.getContents());
            ++r;
        }
    }

    protected boolean isNewObject(EObject obj) {
        EObjectData eObjData = this.getEObjectData(obj);
        return eObjData == null;
    }

    public boolean isNotifierVisible(Notifier notifier) {
        if (notifier.equals(this.topNotifier)) {
            return true;
        }
        if (notifier instanceof EObject) {
            EObject eObj = (EObject)notifier;
            if (this.topNotifier.equals(eObj.eResource())) {
                return true;
            }
            return this.isEObjectVisible(eObj);
        }
        return false;
    }

    protected boolean isEObjectVisible(EObject eObject) {
        if (this.topNotifier.equals(eObject.eContainer())) {
            return true;
        }
        if (eObject.eContainer() != null) {
            return this.isEObjectVisible(eObject.eContainer());
        }
        return false;
    }

    public String convertValueToString(Event e, Object value, boolean isCreate) {
        if (this.getFeatureKind(e) == FeatureKind.ATTRIBUTE_LITERAL) {
            EStructuralFeature sf = this.getFeature(e);
            EDataType sfType = (EDataType)sf.getEType();
            EFactory eFactory = sfType.getEPackage().getEFactoryInstance();
            return eFactory.convertToString(sfType, value);
        }
        EObject eObj = (EObject)value;
        return this.createDescriptorIfNeeded(e, eObj, isCreate);
    }

    protected String createDescriptorIfNeeded(Event e, EObject eObj, boolean isCreate) {
        String value = null;
        if (eObj != null) {
            if (this.isNewObject(eObj)) {
                this.createEObjectData(eObj);
                value = this.createDescriptor(e, eObj, isCreate);
            } else {
                EObjectData eObjData = this.getEObjectData(eObj);
                if (eObj.eResource() == null && !this.isContainedInTopNotifier(eObj)) {
                    if (!isCreate) {
                        if (eObjData.getFirstDeleteEvent() == null) {
                            this.createDescriptor(e, eObj, isCreate);
                            eObjData.setFirstDeleteEvent(e);
                        } else {
                            int nextEObjectPos = e.getRemovedEObjects().size();
                            e.getRemovedEObjects().add(eObjData.getEmptyTemplate(eObj));
                            e.getRemovedDescriptors().add(eObjData.getEmptyDescriptor(eObj, nextEObjectPos));
                            eObjData.unsetLastDeleteEvent();
                            eObjData.setLastDeleteEvent(e);
                        }
                    }
                    value = this.getEObjectData(eObj).getEventId();
                } else {
                    if (eObjData.getFirstDeleteEvent() != null) {
                        this.createDescriptor(e, eObj, isCreate);
                        this.removeIdenticalDescriptors(e, eObjData.getFirstDeleteEvent());
                        eObjData.unsetFirstDeleteEvent();
                        eObjData.unsetLastDeleteEvent();
                    }
                    String eventId = this.getEObjectData(eObj).getEventId();
                    value = this.isContainmentRef(e) && eventId != null ? eventId : this.getURIString(eObj);
                }
            }
        }
        return value;
    }

    private boolean isContainmentRef(Event e) {
        EStructuralFeature sf = this.getFeature(e);
        return sf == null || sf instanceof EReference && ((EReference)sf).isContainment();
    }

    protected EObject createEmptyTemplate(EObject eObj) {
        EObject templateEObj = EcoreUtil.create((EClass)eObj.eClass());
        return templateEObj;
    }

    protected EObjectDescriptor createEmptyDescriptor(EObject eObj) {
        EObjectDescriptor d = EventFactory.eINSTANCE.createEObjectDescriptor();
        d.setEventId(this.getEObjectData(eObj).getEventId());
        return d;
    }

    protected String createDescriptor(Event e, EObject eObj, boolean isCreate) {
        EList templates = isCreate ? e.getAddedEObjects() : e.getRemovedEObjects();
        EList descriptors = isCreate ? e.getAddedDescriptors() : e.getRemovedDescriptors();
        EObject template = this.createEmptyTemplate(eObj);
        int eObjectPos = templates.size();
        templates.add(template);
        EObjectData eObjData = this.getEObjectData(eObj);
        String eventId = eObjData.getEventId();
        if (eventId == null) {
            eventId = this.constructEventId(e, isCreate, template);
            eObjData.setEventId(eventId);
        }
        EObjectDescriptor descriptor = EventFactory.eINSTANCE.createEObjectDescriptor();
        descriptor.setEventId(eventId);
        descriptor.setEObjectPosition(eObjectPos);
        descriptors.add(descriptor);
        EventHelper.copyAttributes(template, eObj);
        EClass c = eObj.eClass();
        EList allRefs = c.getEAllReferences();
        int r = 0;
        int size = allRefs.size();
        while (r < size) {
            EReference refToChild = (EReference)allRefs.get(r);
            Object values = eObj.eGet((EStructuralFeature)refToChild);
            this.createSettings(e, refToChild, descriptor.getSettings(), values, isCreate);
            ++r;
        }
        return eventId;
    }

    protected String constructEventId(Event e, boolean isCreate, EObject eObj) {
        String uri;
        EList list = isCreate ? e.getAddedEObjects() : e.getRemovedEObjects();
        int pos = list.indexOf(eObj);
        if (pos == -1) {
            return null;
        }
        if ((uri = new Integer(this.nextEventId++).toString()).endsWith("#/")) {
            uri = String.valueOf(uri) + "0";
        }
        String eventId = "event:" + uri;
        eventId = String.valueOf(eventId) + "/";
        if (!isCreate) {
            eventId = String.valueOf(eventId) + "-";
        }
        eventId = String.valueOf(eventId) + pos;
        return eventId;
    }

    protected void createSettings(Event e, EReference refToChild, EList settings, Object values, boolean isCreate) {
        if (values != null && !refToChild.isContainer()) {
            if (refToChild.isMany()) {
                EList list = (EList)values;
                int v = 0;
                int size = list.size();
                while (v < size) {
                    Setting setting = EventFactory.eINSTANCE.createSetting();
                    setting.setRefName(refToChild.getName());
                    EObject child = (EObject)list.get(v);
                    setting.setValue(this.createDescriptorIfNeeded(e, child, isCreate));
                    setting.setPosition(v);
                    settings.add(setting);
                    ++v;
                }
            } else {
                Setting setting = EventFactory.eINSTANCE.createSetting();
                setting.setRefName(refToChild.getName());
                EObject child = (EObject)values;
                setting.setValue(this.createDescriptorIfNeeded(e, child, isCreate));
                setting.setPosition(-1);
                settings.add(setting);
            }
        }
    }

    protected int findMatchingId(String thisId, EList list) {
        int i = 0;
        int size = list.size();
        while (i < size) {
            EObjectDescriptor otherDescriptor = (EObjectDescriptor)list.get(i);
            if (thisId.equals(otherDescriptor.getEventId())) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    protected void removeIdenticalDescriptors(Event createEvent, Event deleteEvent) {
        EList createTemplates = createEvent.getAddedEObjects();
        EList deleteTemplates = deleteEvent.getRemovedEObjects();
        EList createDescriptors = createEvent.getAddedDescriptors();
        EList deleteDescriptors = deleteEvent.getRemovedDescriptors();
        int createDescPos = 0;
        while (createDescPos < createDescriptors.size()) {
            EObjectDescriptor createDescriptor = (EObjectDescriptor)createDescriptors.get(createDescPos);
            int createTemplatePos = createDescriptor.getEObjectPosition();
            EObject createTemplate = createTemplatePos == -1 ? null : (EObject)createTemplates.get(createTemplatePos);
            int deleteDescPos = this.findMatchingId(createDescriptor.getEventId(), deleteDescriptors);
            if (deleteDescPos != -1) {
                boolean referencesMatch;
                EObjectDescriptor deleteDescriptor = (EObjectDescriptor)deleteDescriptors.get(deleteDescPos);
                int deleteTemplatePos = deleteDescriptor.getEObjectPosition();
                EObject deleteTemplate = deleteTemplatePos == -1 ? null : (EObject)deleteTemplates.get(deleteTemplatePos);
                boolean attributesMatch = EventHelper.identicalAttributes(createTemplate, deleteTemplate);
                if (attributesMatch) {
                    this.removeTemplate(createDescriptor, createTemplatePos, createTemplates, createDescriptors);
                    this.removeTemplate(deleteDescriptor, deleteTemplatePos, deleteTemplates, deleteDescriptors);
                }
                if (referencesMatch = this.compareReferences(createDescriptor.getSettings(), deleteDescriptor.getSettings())) {
                    createDescriptor.getSettings().clear();
                    deleteDescriptor.getSettings().clear();
                }
                if (attributesMatch && referencesMatch) {
                    createDescriptors.remove(createDescPos--);
                    deleteDescriptors.remove(deleteDescPos);
                }
            }
            ++createDescPos;
        }
    }

    private void removeTemplate(EObjectDescriptor desc, int templatePos, EList templates, EList descriptors) {
        if (templatePos == -1) {
            return;
        }
        desc.setEObjectPosition(-1);
        templates.remove(templatePos);
        int d = 0;
        int size = descriptors.size();
        while (d < size) {
            EObjectDescriptor otherDesc = (EObjectDescriptor)descriptors.get(d);
            if (otherDesc.getEObjectPosition() > templatePos) {
                otherDesc.setEObjectPosition(otherDesc.getEObjectPosition() - 1);
            }
            ++d;
        }
    }

    protected boolean compareReferences(EList settings1, EList settings2) {
        boolean referencesMatch = true;
        if (settings1.size() != settings2.size()) {
            return false;
        }
        int i = 0;
        int size = settings1.size();
        while (i < size) {
            Setting rs1 = (Setting)settings1.get(i);
            Setting rs2 = (Setting)settings2.get(i);
            if (!rs1.getRefName().equals(rs2.getRefName())) {
                return false;
            }
            if (!rs1.getValue().equals(rs2.getValue())) {
                return false;
            }
            ++i;
        }
        return true;
    }

    protected class EObjectData {
        String eventId = null;
        Event firstDeleteEvent = null;
        Event lastDeleteEvent = null;
        EObject emptyTemplate = null;
        EObjectDescriptor emptyDescriptor = null;

        EObjectData() {
        }

        public void setEventId(String eventId) {
            this.eventId = eventId;
        }

        public void setFirstDeleteEvent(Event firstDeleteEvent) {
            this.firstDeleteEvent = firstDeleteEvent;
        }

        public void unsetFirstDeleteEvent() {
            this.firstDeleteEvent = null;
        }

        public void setLastDeleteEvent(Event lastDeleteEvent) {
            this.lastDeleteEvent = lastDeleteEvent;
        }

        public void unsetLastDeleteEvent() {
            if (this.getLastDeleteEvent() != null) {
                EList templates = this.getLastDeleteEvent().getRemovedEObjects();
                EList descriptors = this.getLastDeleteEvent().getRemovedDescriptors();
                int templatePos = templates.indexOf(this.emptyTemplate);
                templates.remove(this.emptyTemplate);
                descriptors.remove(this.emptyDescriptor);
                int d = 0;
                int size = descriptors.size();
                while (d < size) {
                    EObjectDescriptor desc = (EObjectDescriptor)descriptors.get(d);
                    if (desc.getEObjectPosition() > templatePos) {
                        desc.setEObjectPosition(desc.getEObjectPosition() - 1);
                    }
                    ++d;
                }
                this.setLastDeleteEvent(null);
            }
        }

        public String getEventId() {
            return this.eventId;
        }

        public Event getFirstDeleteEvent() {
            return this.firstDeleteEvent;
        }

        public Event getLastDeleteEvent() {
            return this.lastDeleteEvent;
        }

        public EObject getEmptyTemplate(EObject eObj) {
            if (this.emptyTemplate == null) {
                this.emptyTemplate = EventWriterHelper.this.createEmptyTemplate(eObj);
            }
            return this.emptyTemplate;
        }

        public EObject getEmptyDescriptor(EObject eObj, int eObjectPos) {
            if (this.emptyDescriptor == null) {
                this.emptyDescriptor = EventWriterHelper.this.createEmptyDescriptor(eObj);
            }
            this.emptyDescriptor.setEObjectPosition(eObjectPos);
            return this.emptyDescriptor;
        }
    }
}

