/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.jfc.vm;

import java.awt.Component;
import java.awt.Container;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.FocusManager;
import javax.swing.JFrame;

public class TabOrderCalculator {
    protected List fComponentOrders;
    protected JFrame fFrame;
    protected Component fFirstComponent;
    protected List fAllFocusableComponents;
    protected FileOutputStream outputStream;
    protected String fileSeparator;

    public TabOrderCalculator(JFrame aFrame) {
        this.fFrame = aFrame;
        try {
            File output = new File("C:/temp/taborder/taboutputfile.txt");
            try {
                output.delete();
            }
            catch (Exception exception) {}
            output.createNewFile();
            this.outputStream = new FileOutputStream(output);
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
        this.fileSeparator = System.getProperty("line.separator");
    }

    protected void addFocusableChildrenTo(Container aContainer) {
        if (aContainer.isFocusTraversable() && this.fFrame.getContentPane() != aContainer) {
            this.fAllFocusableComponents.add(aContainer);
        }
        Component[] children = aContainer.getComponents();
        int i = 0;
        while (i < children.length) {
            if (children[i] instanceof Container) {
                this.addFocusableChildrenTo((Container)children[i]);
            }
            ++i;
        }
    }

    protected void calculateFocusableComponents() {
        this.fAllFocusableComponents = new ArrayList();
        this.addFocusableChildrenTo(this.fFrame.getContentPane());
    }

    protected boolean componentListsInclude(Component aComponent) {
        Iterator iter = this.fComponentOrders.iterator();
        while (iter.hasNext()) {
            if (!((List)iter.next()).contains(aComponent)) continue;
            return true;
        }
        return false;
    }

    protected void generateComponentOrderFrom(Component aComponent) {
        List componentsList = this.getComponentsListContaining(aComponent);
        FocusManager.getCurrentManager().focusNextComponent(aComponent);
        Component nextComponent = this.fFrame.getFocusOwner();
        while (nextComponent != null) {
            if (this.componentListsInclude(nextComponent)) {
                componentsList.add(nextComponent);
                return;
            }
            componentsList.add(nextComponent);
            this.fAllFocusableComponents.remove(nextComponent);
            FocusManager.getCurrentManager().focusNextComponent(nextComponent);
            nextComponent = this.fFrame.getFocusOwner();
        }
    }

    public Object[] getComponentOrder() {
        Object[] components;
        this.fComponentOrders = new ArrayList();
        this.fFirstComponent = null;
        this.calculateFocusableComponents();
        this.fFrame.requestFocus();
        FocusManager.getCurrentManager().focusNextComponent(this.fFrame.getContentPane());
        Component fFirstComponent = this.fFrame.getFocusOwner();
        this.generateComponentOrderFrom(fFirstComponent);
        while (!this.fAllFocusableComponents.isEmpty()) {
            this.generateComponentOrderFrom((Component)this.fAllFocusableComponents.get(0));
        }
        Object[] result = this.fComponentOrders.toArray();
        int i = 0;
        while (i < result.length) {
            components = (Object[])result[i];
            result[i] = components.toArray();
            ++i;
        }
        i = 0;
        while (i < result.length) {
            components = (Object[])result[i];
            int j = 0;
            while (j < components.length) {
                this.write(String.valueOf(i) + "> Component(" + j + ") = " + components[j]);
                ++j;
            }
            ++i;
        }
        try {
            this.outputStream.close();
        }
        catch (IOException iOException) {}
        return result;
    }

    protected void write(String aString) {
        try {
            this.outputStream.write(this.fileSeparator.getBytes());
            this.outputStream.write(aString.getBytes());
        }
        catch (IOException iOException) {}
    }

    protected List getComponentsListContaining(Component aComponent) {
        Iterator iter = this.fComponentOrders.iterator();
        while (iter.hasNext()) {
            List components = (List)iter.next();
            if (!components.contains(aComponent)) continue;
            return components;
        }
        ArrayList<Component> newList = new ArrayList<Component>();
        newList.add(aComponent);
        this.fAllFocusableComponents.remove(aComponent);
        this.fComponentOrders.add(newList);
        return newList;
    }
}

