/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.java.choosebean;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.impl.EStringToStringMapEntryImpl;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.ITypeNameRequestor;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.internal.corext.util.Strings;
import org.eclipse.jdt.internal.corext.util.TypeInfo;
import org.eclipse.jdt.internal.corext.util.TypeInfoFactory;
import org.eclipse.jdt.internal.corext.util.TypeInfoRequestor;
import org.eclipse.jdt.internal.ui.util.StringMatcher;
import org.eclipse.jdt.internal.ui.util.TypeInfoLabelProvider;
import org.eclipse.jem.internal.beaninfo.adapters.Utilities;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.AbstractElementListSelectionDialog;
import org.eclipse.ui.dialogs.FilteredList;
import org.eclipse.ui.dialogs.TwoPaneElementSelector;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ve.internal.cde.core.CDEUtilities;
import org.eclipse.ve.internal.cde.core.EditDomain;
import org.eclipse.ve.internal.cde.emf.EMFEditDomainHelper;
import org.eclipse.ve.internal.cdm.AnnotationEMF;
import org.eclipse.ve.internal.cdm.CDMFactory;
import org.eclipse.ve.internal.cdm.DiagramData;
import org.eclipse.ve.internal.java.choosebean.ChooseBeanMessages;
import org.eclipse.ve.internal.java.core.JavaVEPlugin;
import org.eclipse.ve.internal.java.rules.IBeanNameProposalRule;

public class ChooseBeanDialog
extends TwoPaneElementSelector {
    public static final String JBCF_CHOOSEBEAN_SELHIST_KEY = "JBCF_CHOOSEBEAN_SELHIST_KEY";
    public static final Color green = Display.getCurrent().getSystemColor(6);
    public static final Color red = Display.getCurrent().getSystemColor(4);
    public static int CHOICE_ALL = 0;
    public static int CHOICE_SWING = 1;
    public static int CHOICE_AWT = 2;
    public static int CHOICE_WEBPROXY = 3;
    public static int CHOICE_DEFAULT = CHOICE_ALL;
    public static final String EmptyString = new String();
    private String[] choices = new String[]{ChooseBeanMessages.getString("SelectionAreaHelper.SelectType.ALL"), ChooseBeanMessages.getString("SelectionAreaHelper.SelectType.SWING"), ChooseBeanMessages.getString("SelectionAreaHelper.SelectType.AWT"), ChooseBeanMessages.getString("SelectionAreaHelper.SelectType.WebProxy")};
    public static String WEB_SERVICE_PROXY_PACKAGE = "proxy.soap";
    private static TypeInfoLabelProvider classLabelProvider = new TypeInfoLabelProvider(16);
    private static TypeInfoLabelProvider packageLabelProvider = new TypeInfoLabelProvider(40);
    private ResourceSet resourceSet;
    private IJavaProject project;
    private IPackageFragment pkg;
    private IJavaElement file;
    private List selectionHistory;
    private IJavaSearchScope scope = null;
    private WebServicesHelper wsHelper = null;
    private Button[] typeChoices = null;
    private int selectedChoice = 0;
    private boolean disableOthers = false;
    private String[] awtBaseClasses = new String[]{"java.awt", "Component"};
    private String[] swingBaseClasses = new String[]{"javax.swing", "JComponent", "javax.swing", "JFrame", "javax.swing", "JDialog", "javax.swing", "JWindow", "javax.swing", "JApplet", "javax.swing.table", "TableColumn"};
    private List awtTypeInfos = new ArrayList();
    private List swingTypeInfos = new ArrayList();
    private List webServicesTypes = null;
    private List swingTypes = null;
    private List awtTypes = null;
    private List allTypes = new ArrayList();
    private Text superFilterText = null;
    private Combo filterCombo = null;
    private Label className = null;
    private String beanLabelText = null;
    private Text beanLabel = null;
    private FilteredList.FilterMatcher currentFilterMatcher = null;
    private TypeFilterMatcher anTypeFilterMatcher = new TypeFilterMatcher();
    private ShowAllTypeChoiceFilter anShowAllTypeChoiceFilter = new ShowAllTypeChoiceFilter();
    private EditDomain feditDomain = null;
    static /* synthetic */ Class class$0;

    public ChooseBeanDialog(Shell shell, IPackageFragment packageFragment, int choice, boolean disableOthers) {
        super(shell, (ILabelProvider)classLabelProvider, (ILabelProvider)packageLabelProvider);
        this.pkg = packageFragment;
        this.project = packageFragment.getJavaProject();
        this.selectedChoice = choice;
        this.selectionHistory = new ArrayList();
        this.disableOthers = disableOthers;
        this.setTitle(ChooseBeanMessages.getString("MainDialog.title"));
        this.setMessage(ChooseBeanMessages.getString("MainDialog.message"));
        this.setStatusLineAboveButtons(true);
        this.loadSelectionHistory();
        this.wsHelper = new WebServicesHelper(this.project);
    }

    private void loadSelectionHistory() {
        try {
            String selhists = this.project.getProject().getPersistentProperty(this.getQualifiedName());
            if (selhists != null) {
                StringTokenizer spacer = new StringTokenizer(selhists, " ", false);
                while (spacer.hasMoreTokens()) {
                    this.selectionHistory.add(spacer.nextToken());
                }
            }
        }
        catch (CoreException coreException) {}
    }

    private void storeSelectionHistory() {
        try {
            StringBuffer buff = new StringBuffer();
            int i = 0;
            while (i < this.selectionHistory.size() && i < 10) {
                buff.append(this.selectionHistory.get(i) + " ");
                ++i;
            }
            this.project.getProject().setPersistentProperty(this.getQualifiedName(), buff.toString());
        }
        catch (CoreException coreException) {}
    }

    private QualifiedName getQualifiedName() {
        return new QualifiedName(JavaVEPlugin.getPlugin().getDescriptor().getUniqueIdentifier(), JBCF_CHOOSEBEAN_SELHIST_KEY);
    }

    public ChooseBeanDialog(Shell shell, IFile file, ResourceSet resourceSet, int choice, boolean disableOthers) {
        this(shell, (IPackageFragment)JavaCore.create((IFile)file).getParent(), choice, disableOthers);
        this.file = JavaCore.create((IFile)file);
        this.resourceSet = resourceSet;
    }

    public ChooseBeanDialog(Shell shell, EditDomain ed, int choice, boolean disableOthers) {
        this(shell, ((FileEditorInput)ed.getEditorPart().getEditorInput()).getFile(), EMFEditDomainHelper.getResourceSet((EditDomain)ed), choice, disableOthers);
        this.feditDomain = ed;
    }

    protected FilteredList createFilteredList(Composite parent) {
        FilteredList list = super.createFilteredList(parent);
        this.currentFilterMatcher = this.anTypeFilterMatcher;
        list.setFilterMatcher(this.currentFilterMatcher);
        list.setComparator((Comparator)new StringComparator());
        return list;
    }

    public Control createDialogArea(Composite parent) {
        Composite topComponent = new Composite(parent, 0);
        GridLayout topComponentLayout = new GridLayout();
        topComponent.setLayout((Layout)topComponentLayout);
        Group classGroup = new Group(topComponent, 0);
        GridData gd = new GridData(1808);
        classGroup.setLayoutData((Object)gd);
        classGroup.setText(ChooseBeanMessages.getString("SelectionAreaHelper.GroupTitle"));
        classGroup.setLayout((Layout)new GridLayout());
        Composite c = (Composite)super.createDialogArea((Composite)classGroup);
        if (c.getLayout() instanceof GridLayout) {
            GridLayout gl = (GridLayout)c.getLayout();
            gl.marginHeight = 0;
            gl.marginWidth = 0;
        }
        this.createClassArea((Composite)classGroup);
        this.createBeanLabelArea(topComponent);
        this.className = new Label(topComponent, 0);
        gd = new GridData(768);
        this.className.setLayoutData((Object)gd);
        return topComponent;
    }

    private void createBeanLabelArea(Composite parent) {
        int numCols = 2;
        Group group = new Group(parent, 0);
        group.setLayout((Layout)new GridLayout(numCols, false));
        group.setLayoutData((Object)new GridData(1808));
        group.setText(ChooseBeanMessages.getString("ChooseBeanDialog.Group.Properties.Title"));
        Label label = new Label((Composite)group, 0);
        GridData gd = new GridData();
        gd.horizontalSpan = 1;
        label.setLayoutData((Object)gd);
        label.setText(ChooseBeanMessages.getString("ChooseBeanDialog.Group.Properties.VariableName.text"));
        this.beanLabel = new Text((Composite)group, 2052);
        gd = new GridData(768);
        gd.horizontalSpan = numCols - 1;
        this.beanLabel.setLayoutData((Object)gd);
        this.beanLabel.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (e.widget instanceof Text) {
                    Text text = (Text)e.widget;
                    ChooseBeanDialog.this.beanLabelText = text.getText();
                    ChooseBeanDialog.this.updateOkState();
                }
            }
        });
        if (this.resourceSet == null) {
            group.setEnabled(false);
            label.setEnabled(false);
            this.beanLabel.setEnabled(false);
        }
    }

    protected void createClassArea(Composite parent) {
        int numCols = 4;
        Composite c = new Composite(parent, 0);
        GridData gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        c.setLayoutData((Object)gd);
        GridLayout cLayout = new GridLayout(numCols, true);
        cLayout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        cLayout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        c.setLayout((Layout)cLayout);
        this.typeChoices = new Button[4];
        int i = 0;
        while (i < this.typeChoices.length) {
            this.typeChoices[i] = new Button(c, 16);
            gd = new GridData();
            gd.horizontalSpan = numCols / 4;
            this.typeChoices[i].setLayoutData((Object)gd);
            this.typeChoices[i].setText(this.choices[i]);
            this.typeChoices[i].addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    if (e.widget instanceof Button) {
                        Button choice = (Button)e.widget;
                        if (choice.getSelection()) {
                            if (ChooseBeanDialog.this.typeChoices != null) {
                                int i = 0;
                                while (i < ChooseBeanDialog.this.typeChoices.length) {
                                    if (choice.equals(ChooseBeanDialog.this.typeChoices[i])) {
                                        ChooseBeanDialog.this.selectedChoice = i;
                                    }
                                    ++i;
                                }
                            }
                            ChooseBeanDialog.this.updateElements();
                        } else {
                            ChooseBeanDialog.this.selectedChoice = -1;
                        }
                    }
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                    this.widgetSelected(e);
                }
            });
            if (this.disableOthers && this.selectedChoice != i) {
                this.typeChoices[i].setEnabled(false);
            }
            ++i;
        }
        this.typeChoices[this.selectedChoice].setSelection(true);
        this.updateElements();
    }

    protected void createFileArea(Composite parent) {
    }

    private void updateElements() {
        if (this.typeChoices[0].getSelection() && !(this.currentFilterMatcher instanceof TypeFilterMatcher)) {
            this.currentFilterMatcher = this.anTypeFilterMatcher;
            ((AbstractElementListSelectionDialog)this).fFilteredList.setFilterMatcher(this.currentFilterMatcher);
        }
        if (this.typeChoices[1].getSelection()) {
            if (!(this.currentFilterMatcher instanceof ShowAllTypeChoiceFilter)) {
                this.currentFilterMatcher = this.anShowAllTypeChoiceFilter;
                ((AbstractElementListSelectionDialog)this).fFilteredList.setFilterMatcher(this.currentFilterMatcher);
            }
            if (this.swingTypes == null) {
                BusyIndicator.showWhile((Display)Display.getDefault(), (Runnable)new Runnable(){

                    public void run() {
                        ChooseBeanDialog.this.swingTypes = ChooseBeanDialog.this.getSubTypes(ChooseBeanDialog.this.swingTypeInfos);
                    }
                });
            }
        }
        if (this.typeChoices[2].getSelection()) {
            if (!(this.currentFilterMatcher instanceof ShowAllTypeChoiceFilter)) {
                this.currentFilterMatcher = this.anShowAllTypeChoiceFilter;
                ((AbstractElementListSelectionDialog)this).fFilteredList.setFilterMatcher(this.currentFilterMatcher);
            }
            if (this.awtTypes == null) {
                BusyIndicator.showWhile((Display)Display.getDefault(), (Runnable)new Runnable(){

                    public void run() {
                        ChooseBeanDialog.this.awtTypes = ChooseBeanDialog.this.getSubTypes(ChooseBeanDialog.this.awtTypeInfos);
                        ChooseBeanDialog.this.swingTypes = ChooseBeanDialog.this.getSubTypes(ChooseBeanDialog.this.swingTypeInfos);
                    }
                });
            }
        }
        if (this.typeChoices[3].getSelection()) {
            if (!(this.currentFilterMatcher instanceof ShowAllTypeChoiceFilter)) {
                this.currentFilterMatcher = this.anShowAllTypeChoiceFilter;
                ((AbstractElementListSelectionDialog)this).fFilteredList.setFilterMatcher(this.currentFilterMatcher);
            }
            if (this.webServicesTypes == null) {
                BusyIndicator.showWhile((Display)Display.getDefault(), (Runnable)new Runnable(){

                    public void run() {
                        ChooseBeanDialog.this.webServicesTypes = ChooseBeanDialog.this.getWebServicesTypes();
                    }
                });
            }
        }
        this.setFilter(this.getFilter());
    }

    protected List getAllElements() {
        final TypeInfoFactory typeInfoFactory = new TypeInfoFactory();
        TypeInfoRequestor requestor = new TypeInfoRequestor(this.allTypes){

            private void check(char[] packageName, char[] typeName, char[][] enclosingTypeNames, String path, boolean isInterface) {
                int i = 0;
                while (i < ChooseBeanDialog.this.swingBaseClasses.length) {
                    if (new String(packageName).equals(ChooseBeanDialog.this.swingBaseClasses[i]) && new String(typeName).equals(ChooseBeanDialog.this.swingBaseClasses[i + 1])) {
                        ChooseBeanDialog.this.swingTypeInfos.add(typeInfoFactory.create(packageName, typeName, enclosingTypeNames, isInterface, path));
                    }
                    i += 2;
                }
                i = 0;
                while (i < ChooseBeanDialog.this.awtBaseClasses.length) {
                    if (new String(packageName).equals(ChooseBeanDialog.this.awtBaseClasses[i]) && new String(typeName).equals(ChooseBeanDialog.this.awtBaseClasses[i + 1])) {
                        ChooseBeanDialog.this.awtTypeInfos.add(typeInfoFactory.create(packageName, typeName, enclosingTypeNames, isInterface, path));
                    }
                    i += 2;
                }
            }

            public void acceptClass(char[] packageName, char[] typeName, char[][] enclosingTypeNames, String path) {
                super.acceptClass(packageName, typeName, enclosingTypeNames, path);
                this.check(packageName, typeName, enclosingTypeNames, path, false);
            }
        };
        try {
            new SearchEngine().searchAllTypeNames(ResourcesPlugin.getWorkspace(), null, null, 2, false, 5, this.getJavaSearchScope(), (ITypeNameRequestor)requestor, 3, null);
        }
        catch (JavaModelException javaModelException) {}
        return this.allTypes;
    }

    private List getSubTypes(List tis) {
        ArrayList<String> list = new ArrayList<String>();
        int i = 0;
        while (i < tis.size()) {
            try {
                TypeInfo ti = (TypeInfo)tis.get(i);
                IType type = ti.resolveType(this.getJavaSearchScope());
                ITypeHierarchy th = type.newTypeHierarchy(null);
                IType[] types = th.getAllSubtypes(type);
                list.add(type.getFullyQualifiedName());
                int j = 0;
                while (j < types.length) {
                    list.add(types[j].getFullyQualifiedName());
                    ++j;
                }
            }
            catch (JavaModelException javaModelException) {}
            ++i;
        }
        return list;
    }

    protected static List getSubTypes(ITypeHierarchy th, IType fromType, boolean isClass) {
        IType[] types = th.getAllSubtypes(fromType);
        ArrayList<IType> list = new ArrayList<IType>();
        int i = 0;
        while (i < types.length) {
            try {
                if (isClass && types[i].isClass()) {
                    list.add(types[i]);
                }
                if (!isClass && types[i].isInterface()) {
                    list.add(types[i]);
                }
            }
            catch (JavaModelException e) {
                JavaVEPlugin.log(e, 4);
            }
            ++i;
        }
        return list;
    }

    private List getWebServicesTypes() {
        if (this.wsHelper != null) {
            return this.wsHelper.getValidServices();
        }
        return new ArrayList();
    }

    protected IJavaSearchScope getJavaSearchScope() {
        if (this.scope == null) {
            this.scope = SearchEngine.createJavaSearchScope((IJavaElement[])new IJavaElement[]{this.project});
        }
        return this.scope;
    }

    public int open() {
        this.setElements(this.getAllElements().toArray());
        return super.open();
    }

    public Object[] getResult() {
        Object[] results = super.getResult();
        if (this.resourceSet != null) {
            Object[] newResults = new Object[results.length * 2];
            int i = 0;
            while (i < results.length) {
                TypeInfo ti = (TypeInfo)results[i];
                if (this.selectionHistory != null) {
                    if (this.selectionHistory.contains(classLabelProvider.getText((Object)ti))) {
                        this.selectionHistory.remove(classLabelProvider.getText((Object)ti));
                    }
                    this.selectionHistory.add(0, classLabelProvider.getText((Object)ti));
                    this.storeSelectionHistory();
                }
                String realFQN = this.getFullSelectionName(ti);
                EClass eclass = (EClass)Utilities.getJavaClass((String)realFQN, (ResourceSet)this.resourceSet);
                EObject eObject = eclass.getEPackage().getEFactoryInstance().create(eclass);
                this.setBeanName(eObject, this.beanLabelText);
                newResults[i * 2] = eObject;
                newResults[i * 2 + 1] = eclass;
                ++i;
            }
            return newResults;
        }
        return results;
    }

    protected void setBeanName(EObject obj, String name) {
        CDMFactory fact;
        AnnotationEMF an;
        if (obj != null && (an = (fact = CDMFactory.eINSTANCE).createAnnotationEMF()) != null) {
            EStringToStringMapEntryImpl sentry = (EStringToStringMapEntryImpl)EcoreFactory.eINSTANCE.create(EcorePackage.eINSTANCE.getEStringToStringMapEntry());
            sentry.setKey((Object)"org.eclipse.ve.internal.cde.core.nameincomposition");
            sentry.setValue((Object)name);
            CDEUtilities.putEMapEntry((EMap)an.getKeyedValues(), (Map.Entry)sentry);
            an.setAnnotates(obj);
        }
    }

    protected String getFieldProposal(String className) {
        if (this.feditDomain != null && this.resourceSet != null) {
            DiagramData o = this.feditDomain.getDiagramData();
            IType javaElement = null;
            Iterator iter = o.eAdapters().iterator();
            while (iter.hasNext()) {
                Object je;
                Object a = iter.next();
                if (!(a instanceof IAdaptable)) continue;
                IAdaptable iAdaptable = (IAdaptable)a;
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = Class.forName("[Lorg.eclipse.jdt.core.IJavaElement;").getComponentType();
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (!((je = iAdaptable.getAdapter((Class)clazz)) instanceof IType)) continue;
                javaElement = (IType)je;
                break;
            }
            if (javaElement != null) {
                IBeanNameProposalRule pp = (IBeanNameProposalRule)this.feditDomain.getRuleRegistry().getRule("ruleBeanNameProposal");
                String result = pp.getProspectInstanceVariableName(className, new Object[]{javaElement}, this.resourceSet);
                return result == null ? EmptyString : result;
            }
        }
        return EmptyString;
    }

    protected void setClassName(String name, boolean validClass) {
        if (validClass) {
            this.className.setForeground(green);
        } else {
            this.className.setForeground(red);
        }
        if (name == null || name.length() == 0) {
            String t = name == null ? EmptyString : name;
            this.className.setText(t);
            this.beanLabel.setText(t);
        } else {
            if (validClass) {
                this.beanLabel.setText(this.getFieldProposal(name));
            } else {
                this.beanLabel.setText(EmptyString);
            }
            this.className.setText(name);
        }
    }

    protected IStatus getClassStatus(Object selected) {
        JavaModelException t = null;
        String message = new String();
        boolean isInstantiable = true;
        if (selected == null) {
            isInstantiable = false;
            this.setClassName(null, false);
            message = ChooseBeanMessages.getString("SelectionAreaHelper.SecondaryMsg.NoSelectionMade");
        } else {
            try {
                TypeInfo ti = (TypeInfo)selected;
                IType type = ti.resolveType(this.getJavaSearchScope());
                boolean isTypePublic = Flags.isPublic((int)type.getFlags());
                boolean isTypeAbstract = Flags.isAbstract((int)type.getFlags());
                boolean isInPresentPackage = type.getPackageFragment().getElementName().equals(this.pkg.getElementName());
                boolean isTypeStatic = Flags.isStatic((int)type.getFlags());
                boolean isTypeInner = type.getDeclaringType() != null;
                boolean isPublicNullConstructorPresent = false;
                boolean isAnyConstructorPresent = false;
                IMethod[] methods = type.getMethods();
                int m = 0;
                while (m < methods.length) {
                    if (methods[m].isConstructor() && methods[m].getParameterTypes().length < 1 && Flags.isPublic((int)methods[m].getFlags())) {
                        isPublicNullConstructorPresent = true;
                    }
                    if (methods[m].isConstructor()) {
                        isAnyConstructorPresent = true;
                    }
                    ++m;
                }
                if (!isPublicNullConstructorPresent && isAnyConstructorPresent) {
                    if (message.length() > 0) {
                        message = message.concat(" : ");
                    }
                    message = message.concat(ChooseBeanMessages.getString("SelectionAreaHelper.SecondaryMsg.NoPublicNullConstructor"));
                }
                if (!isTypePublic) {
                    if (message.length() > 0) {
                        message = message.concat(" : ");
                    }
                    message = message.concat(ChooseBeanMessages.getString("SelectionAreaHelper.SecondaryMsg.TypeNonPublic"));
                }
                if (isTypeAbstract) {
                    if (message.length() > 0) {
                        message = message.concat(" : ");
                    }
                    message = message.concat(ChooseBeanMessages.getString("ChooseBeanDialog.Message.AbstractType"));
                }
                if (isTypeInner && !isTypeStatic) {
                    if (message.length() > 0) {
                        message = message.concat(" : ");
                    }
                    message = message.concat(ChooseBeanMessages.getString("ChooseBeanDialog.Message.NonStaticType"));
                }
                boolean bl = isInstantiable = !(isAnyConstructorPresent && !isPublicNullConstructorPresent || !isTypePublic && !isInPresentPackage || isTypeAbstract || isTypeInner && (!isTypeInner || !isTypeStatic));
                if (isInstantiable) {
                    message = new String();
                }
                this.setClassName(this.getFullSelectionName(ti), isInstantiable);
            }
            catch (JavaModelException e) {
                t = e;
                isInstantiable = false;
                if (message.length() > 0) {
                    message = message.concat(" : ");
                }
                message = ChooseBeanMessages.getString("SelectionAreaHelper.SecondaryMsg.UnknownError");
            }
        }
        Status status = new Status(isInstantiable ? 0 : 4, JavaVEPlugin.getPlugin().getDescriptor().getUniqueIdentifier(), 0, message, (Throwable)t);
        return status;
    }

    protected String getFullSelectionName(TypeInfo ti) {
        String falseFQN = ti.getFullyQualifiedName();
        String correctResolve = null;
        IType type = null;
        try {
            type = this.project.findType(falseFQN);
        }
        catch (JavaModelException javaModelException) {
            type = null;
        }
        if (type != null) {
            correctResolve = type.getFullyQualifiedName('$');
        }
        if (correctResolve == null) {
            correctResolve = falseFQN;
        }
        return correctResolve;
    }

    protected Text createFilterText(Composite parent) {
        Composite c = new Composite(parent, 0);
        GridData data = new GridData();
        data.heightHint = 0;
        data.widthHint = 0;
        c.setLayoutData((Object)data);
        this.superFilterText = super.createFilterText(c);
        this.filterCombo = new Combo(parent, 4);
        data = new GridData();
        data.grabExcessVerticalSpace = false;
        data.grabExcessHorizontalSpace = true;
        data.horizontalAlignment = 4;
        data.verticalAlignment = 1;
        this.filterCombo.setLayoutData((Object)data);
        this.filterCombo.setText(this.getFilter() == null ? "" : this.getFilter());
        int i = 0;
        while (i < this.selectionHistory.size()) {
            if (this.selectionHistory.get(i) != null) {
                this.filterCombo.add((String)this.selectionHistory.get(i));
            }
            ++i;
        }
        this.filterCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ChooseBeanDialog.this.superFilterText.setText(ChooseBeanDialog.this.filterCombo.getText());
            }
        });
        this.filterCombo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                ChooseBeanDialog.this.handleDefaultSelected();
            }
        });
        return this.superFilterText;
    }

    public void setFilter(String filter) {
        super.setFilter(filter);
        this.filterCombo.setText(filter);
    }

    public void create() {
        super.create();
        if (this.filterCombo != null) {
            this.filterCombo.setFocus();
        }
    }

    protected void handleEmptyList() {
        super.handleEmptyList();
        this.filterCombo.setEnabled(false);
    }

    protected Table createLowerList(Composite parent) {
        Table table = super.createLowerList(parent);
        table.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ChooseBeanDialog.this.updateStatus(ChooseBeanDialog.this.getClassStatus(ChooseBeanDialog.this.getLowerSelectedElement()));
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                ChooseBeanDialog.this.updateStatus(ChooseBeanDialog.this.getClassStatus(ChooseBeanDialog.this.getLowerSelectedElement()));
            }
        });
        return table;
    }

    protected void handleSelectionChanged() {
        super.handleSelectionChanged();
        this.updateStatus(this.getClassStatus(this.getLowerSelectedElement()));
    }

    protected void updateOkState() {
        if (this.beanLabelText != null && this.beanLabelText.length() != 0 && !JavaConventions.validateFieldName((String)this.beanLabelText).isOK()) {
            Button okButton = this.getOkButton();
            if (okButton != null) {
                okButton.setEnabled(false);
            }
            return;
        }
        super.updateOkState();
    }

    protected void handleDefaultSelected() {
        if (this.getOkButton().isEnabled()) {
            super.handleDefaultSelected();
        }
    }

    public static class WebServicesHelper {
        public static String[] SERVICE_INTERFACE = new String[]{"javax.xml.rpc", "Service"};
        public static String[] REMOTE_INTERFACE = new String[]{"java.rmi", "Remote"};
        protected IJavaProject javaProject = null;
        protected IType serviceType = null;
        protected IType remoteType = null;
        protected ITypeHierarchy serviceTypeHierarchy = null;
        protected ITypeHierarchy remoteTypeHierarchy = null;

        public WebServicesHelper(IJavaProject javaProject) {
            try {
                this.init(javaProject.findType(SERVICE_INTERFACE[0], SERVICE_INTERFACE[1]), javaProject.findType(REMOTE_INTERFACE[0], REMOTE_INTERFACE[1]), javaProject);
            }
            catch (JavaModelException e) {
                JavaVEPlugin.log(e, 2);
            }
        }

        protected void init(IType serviceType, IType remoteType, IJavaProject javaProject) {
            this.serviceType = serviceType;
            this.remoteType = remoteType;
            this.javaProject = javaProject;
            if (javaProject != null && serviceType != null) {
                try {
                    this.serviceTypeHierarchy = serviceType.newTypeHierarchy(javaProject, null);
                }
                catch (JavaModelException e) {
                    JavaVEPlugin.log(e, 2);
                }
            }
            if (javaProject != null && remoteType != null) {
                try {
                    this.remoteTypeHierarchy = remoteType.newTypeHierarchy(javaProject, null);
                }
                catch (JavaModelException e1) {
                    JavaVEPlugin.log(e1, 2);
                }
            }
        }

        public List getValidServices() {
            List serviceClasses;
            ArrayList<String> wsTypes = new ArrayList<String>();
            if (this.remoteType != null && this.remoteTypeHierarchy != null && this.serviceType != null && this.serviceTypeHierarchy != null && (serviceClasses = ChooseBeanDialog.getSubTypes(this.serviceTypeHierarchy, this.serviceType, true)) != null) {
                int i = 0;
                while (i < serviceClasses.size()) {
                    IType serviceClass = (IType)serviceClasses.get(i);
                    if (this.isValidService(serviceClass) && !wsTypes.contains(serviceClass.getFullyQualifiedName())) {
                        wsTypes.add(serviceClass.getFullyQualifiedName());
                    }
                    ++i;
                }
            }
            return wsTypes;
        }

        public boolean isValidProxySoapService(IType type) {
            return type.getPackageFragment().getElementName().equals(WEB_SERVICE_PROXY_PACKAGE);
        }

        public boolean isValidJAXRPCService(IType type) {
            return this.isExtendingService(type) && this.getRemoteReturnedByService(type) != null;
        }

        public boolean isValidService(IType type) {
            return this.isValidProxySoapService(type) || this.isValidJAXRPCService(type);
        }

        public boolean isExtendingService(IType type) {
            if (this.serviceTypeHierarchy != null) {
                IType[] subTypes = this.serviceTypeHierarchy.getAllSubtypes(this.serviceType);
                int i = 0;
                while (i < subTypes.length) {
                    if (subTypes[i].equals(type)) {
                        return true;
                    }
                    ++i;
                }
            }
            return false;
        }

        public IType getRemoteReturnedByService(IType inputService) {
            try {
                List remoteExtendingInterfaces = ChooseBeanDialog.getSubTypes(this.remoteTypeHierarchy, this.remoteType, false);
                ITypeHierarchy typeHierarchy = inputService.newSupertypeHierarchy(null);
                IType[] allSuperClasses = typeHierarchy.getAllSuperclasses(inputService);
                IType[] superClasses = new IType[allSuperClasses.length + 1];
                System.arraycopy(allSuperClasses, 0, superClasses, 1, allSuperClasses.length);
                superClasses[0] = inputService;
                int sc = 0;
                while (sc < superClasses.length) {
                    int mc = 0;
                    while (mc < superClasses[sc].getMethods().length) {
                        String retType;
                        String[][] resolvedTypes;
                        IMethod method = superClasses[sc].getMethods()[mc];
                        if (method.getParameterTypes().length <= 0 && !"V".equals(method.getReturnType()) && method.getReturnType().indexOf(91) <= -1 && Flags.isPublic((int)method.getFlags()) && (resolvedTypes = superClasses[sc].resolveType(retType = Signature.toString((String)Signature.getReturnType((String)method.getSignature())))) != null && resolvedTypes.length > 0) {
                            int rtc = 0;
                            while (rtc < resolvedTypes.length) {
                                String pkg = resolvedTypes[rtc][0];
                                String cls = resolvedTypes[rtc][1];
                                int reic = 0;
                                while (reic < remoteExtendingInterfaces.size()) {
                                    IType remoteExtendingInterface = (IType)remoteExtendingInterfaces.get(reic);
                                    if (remoteExtendingInterface.getElementName().equals(cls) && remoteExtendingInterface.getPackageFragment().getElementName().equals(pkg)) {
                                        return remoteExtendingInterface;
                                    }
                                    ++reic;
                                }
                                ++rtc;
                            }
                        }
                        ++mc;
                    }
                    ++sc;
                }
            }
            catch (JavaModelException e) {
                JavaVEPlugin.log(e, 2);
            }
            catch (IllegalArgumentException e) {
                JavaVEPlugin.log(e, 2);
            }
            return null;
        }
    }

    private static class TypeFilterMatcher
    implements FilteredList.FilterMatcher {
        private static final char END_SYMBOL = '<';
        private static final char ANY_STRING = '*';
        private StringMatcher fMatcher;
        private StringMatcher fQualifierMatcher;

        TypeFilterMatcher() {
        }

        public void setFilter(String pattern, boolean ignoreCase, boolean igoreWildCards) {
            int qualifierIndex = pattern.lastIndexOf(".");
            if (qualifierIndex == -1) {
                this.fQualifierMatcher = null;
                this.fMatcher = new StringMatcher(this.adjustPattern(pattern), ignoreCase, igoreWildCards);
            } else {
                this.fQualifierMatcher = new StringMatcher(pattern.substring(0, qualifierIndex), ignoreCase, igoreWildCards);
                this.fMatcher = new StringMatcher(this.adjustPattern(pattern.substring(qualifierIndex + 1)), ignoreCase, igoreWildCards);
            }
        }

        public boolean match(Object element) {
            if (!(element instanceof TypeInfo)) {
                return false;
            }
            TypeInfo type = (TypeInfo)element;
            if (!this.fMatcher.match(type.getTypeName())) {
                return false;
            }
            if (this.fQualifierMatcher == null) {
                return true;
            }
            return this.fQualifierMatcher.match(type.getTypeContainerName());
        }

        private String adjustPattern(String pattern) {
            int length = pattern.length();
            if (length > 0) {
                switch (pattern.charAt(length - 1)) {
                    case '<': {
                        pattern = pattern.substring(0, length - 1);
                        break;
                    }
                    case '*': {
                        break;
                    }
                    default: {
                        pattern = String.valueOf(pattern) + '*';
                    }
                }
            }
            return pattern;
        }
    }

    private static class StringComparator
    implements Comparator {
        StringComparator() {
        }

        public int compare(Object left, Object right) {
            String leftString = (String)left;
            String rightString = (String)right;
            if (Strings.isLowerCase((char)leftString.charAt(0)) && !Strings.isLowerCase((char)rightString.charAt(0))) {
                return 1;
            }
            if (Strings.isLowerCase((char)rightString.charAt(0)) && !Strings.isLowerCase((char)leftString.charAt(0))) {
                return -1;
            }
            int result = leftString.compareToIgnoreCase(rightString);
            if (result == 0) {
                result = leftString.compareTo(rightString);
            }
            return result;
        }
    }

    protected final class ShowAllTypeChoiceFilter
    implements FilteredList.FilterMatcher {
        private StringMatcher fMatcher;
        private StringMatcher fQualifierMatcher;

        protected ShowAllTypeChoiceFilter() {
        }

        public void setFilter(String pattern, boolean ignoreCase, boolean igoreWildCards) {
            int qualifierIndex = pattern.lastIndexOf(".");
            if (qualifierIndex == -1) {
                this.fQualifierMatcher = null;
                this.fMatcher = new StringMatcher(String.valueOf(pattern) + '*', ignoreCase, igoreWildCards);
            } else {
                this.fQualifierMatcher = new StringMatcher(pattern.substring(0, qualifierIndex), ignoreCase, igoreWildCards);
                this.fMatcher = new StringMatcher(pattern.substring(qualifierIndex + 1), ignoreCase, igoreWildCards);
            }
        }

        public boolean match(Object element) {
            if (!(element instanceof TypeInfo)) {
                return false;
            }
            TypeInfo typeInfo = (TypeInfo)element;
            if (!this.fMatcher.match(typeInfo.getTypeName())) {
                return false;
            }
            if (this.fQualifierMatcher != null && !this.fQualifierMatcher.match(typeInfo.getTypeContainerName())) {
                return false;
            }
            boolean matched = false;
            switch (ChooseBeanDialog.this.selectedChoice) {
                case 0: {
                    matched = true;
                    break;
                }
                case 1: {
                    if (ChooseBeanDialog.this.swingTypes == null || !ChooseBeanDialog.this.swingTypes.contains(typeInfo.getFullyQualifiedName())) break;
                    matched = true;
                    break;
                }
                case 2: {
                    if (ChooseBeanDialog.this.awtTypes == null || !ChooseBeanDialog.this.awtTypes.contains(typeInfo.getFullyQualifiedName()) || ChooseBeanDialog.this.swingTypes.contains(typeInfo.getFullyQualifiedName())) break;
                    matched = true;
                    break;
                }
                case 3: {
                    if (typeInfo.getPackageName().equals(WEB_SERVICE_PROXY_PACKAGE)) {
                        matched = true;
                    }
                    if (!ChooseBeanDialog.this.webServicesTypes.contains(typeInfo.getFullyQualifiedName())) break;
                    matched = true;
                    break;
                }
            }
            return matched;
        }
    }
}

