/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.java.core;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jem.internal.instantiation.base.IJavaInstance;
import org.eclipse.jem.internal.instantiation.base.IJavaObjectInstance;
import org.eclipse.jem.internal.java.JavaClass;
import org.eclipse.jem.internal.java.JavaDataType;
import org.eclipse.jem.internal.java.JavaHelpers;
import org.eclipse.jem.internal.java.impl.JavaClassImpl;
import org.eclipse.jem.internal.java.impl.JavaFactoryImpl;
import org.eclipse.ve.internal.java.core.BeanProxyUtilities;

public class BeanUtilities {
    public static IJavaInstance createJavaObject(String qualifiedClassName, ResourceSet aResourceSet, String javaInitializationString) {
        return BeanUtilities.createJavaObject(JavaClassImpl.reflect((String)qualifiedClassName, (ResourceSet)aResourceSet), aResourceSet, javaInitializationString);
    }

    public static IJavaInstance createJavaObject(JavaHelpers javaHelpers, ResourceSet aResourceSet, String javaInitializationString) {
        IJavaInstance result = null;
        if (javaHelpers.isPrimitive()) {
            result = (IJavaInstance)((JavaFactoryImpl)javaHelpers.getEPackage().getEFactoryInstance()).createFromString((JavaDataType)javaHelpers, javaInitializationString);
        } else {
            JavaClass javaClass = (JavaClass)javaHelpers;
            IJavaObjectInstance newInstance = (IJavaObjectInstance)javaClass.getEPackage().getEFactoryInstance().create((EClass)javaClass);
            if (javaInitializationString != null) {
                newInstance.setInitializationString(javaInitializationString);
            }
            result = newInstance;
        }
        if (aResourceSet != null) {
            BeanProxyUtilities.getBeanProxyHost(result, aResourceSet);
        }
        return result;
    }

    public static IJavaObjectInstance createString(ResourceSet aResourceSet, String unquotedInitializationString) {
        return (IJavaObjectInstance)BeanUtilities.createJavaObject("java.lang.String", aResourceSet, BeanUtilities.createStringInitString(unquotedInitializationString));
    }

    public static String createStringInitString(String value) {
        StringBuffer sb = new StringBuffer(value.length());
        sb.append('\"');
        int sl = value.length();
        int i = 0;
        while (i < sl) {
            char c = value.charAt(i);
            if (c == '\"' || c == '\\') {
                sb.append('\\');
            }
            sb.append(c);
            ++i;
        }
        sb.append('\"');
        return sb.toString();
    }

    public static String getUnqualifiedClassName(String aQualifiedClassName) {
        int indexOfLastPeriod = aQualifiedClassName.lastIndexOf(46);
        if (indexOfLastPeriod >= 0) {
            return aQualifiedClassName.substring(indexOfLastPeriod + 1, aQualifiedClassName.length());
        }
        return aQualifiedClassName;
    }

    public static boolean isThisPart(IJavaObjectInstance aBean) {
        EReference containerSF = aBean.eContainmentFeature();
        return containerSF.getName().equals("thisPart");
    }
}

