/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.java.core;

import java.text.MessageFormat;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class ComboBoxCellEditor
extends CellEditor {
    private String[] items;
    private int selection;
    private CCombo comboBox;

    public ComboBoxCellEditor(Composite parent, String[] items) {
        super(parent);
        Assert.isNotNull((Object)items);
        this.items = items;
        this.selection = 0;
        this.populateComboBoxItems();
    }

    protected Control createControl(Composite parent) {
        this.comboBox = new CCombo(parent, 8);
        this.comboBox.setFont(parent.getFont());
        this.comboBox.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                ComboBoxCellEditor.this.keyReleaseOccured(e);
            }
        });
        this.comboBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent event) {
                ComboBoxCellEditor.this.selection = ComboBoxCellEditor.this.comboBox.getSelectionIndex();
                Object newValue = ComboBoxCellEditor.this.doGetValue();
                boolean newValidState = ComboBoxCellEditor.this.isCorrect(newValue);
                if (newValidState) {
                    ComboBoxCellEditor.this.doSetValue(newValue);
                } else {
                    ComboBoxCellEditor.this.setErrorMessage(MessageFormat.format(ComboBoxCellEditor.this.getErrorMessage(), ComboBoxCellEditor.this.items[ComboBoxCellEditor.this.selection]));
                }
                ComboBoxCellEditor.this.fireApplyEditorValue();
            }
        });
        this.comboBox.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.detail == 2 || e.detail == 4) {
                    e.doit = false;
                }
            }
        });
        return this.comboBox;
    }

    protected Object doGetValue() {
        return new Integer(this.selection);
    }

    protected void doSetFocus() {
        this.comboBox.setFocus();
    }

    public CellEditor.LayoutData getLayoutData() {
        CellEditor.LayoutData layoutData = super.getLayoutData();
        layoutData.minimumWidth = 50;
        return layoutData;
    }

    protected void doSetValue(Object value) {
        Assert.isTrue((this.comboBox != null && value instanceof Integer ? 1 : 0) != 0);
        this.selection = (Integer)value;
        this.comboBox.select(this.selection);
    }

    private void populateComboBoxItems() {
        if (this.comboBox != null && this.items != null) {
            int i = 0;
            while (i < this.items.length) {
                this.comboBox.add(this.items[i], i);
                ++i;
            }
            this.setValueValid(true);
        }
    }
}

