/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.java.core;

import org.eclipse.jem.internal.instantiation.base.IJavaInstance;
import org.eclipse.jem.internal.java.JavaClass;
import org.eclipse.jem.internal.java.JavaHelpers;
import org.eclipse.jem.internal.proxy.core.IArrayBeanProxy;
import org.eclipse.jem.internal.proxy.core.IBeanProxy;
import org.eclipse.jem.internal.proxy.core.IBeanTypeProxy;
import org.eclipse.jem.internal.proxy.core.IStringBeanProxy;
import org.eclipse.jem.internal.proxy.core.ThrowableProxy;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.ve.internal.cde.core.EditDomain;
import org.eclipse.ve.internal.cde.emf.EMFEditDomainHelper;
import org.eclipse.ve.internal.java.core.BeanProxyUtilities;
import org.eclipse.ve.internal.java.core.JavaMessages;
import org.eclipse.ve.internal.java.core.JavaVEPlugin;
import org.eclipse.ve.internal.propertysheet.INeedData;

public class EnumeratedLabelProvider
extends LabelProvider
implements INeedData {
    protected String[] fDisplayNames;
    protected String[] fInitStrings;
    protected IBeanProxy[] fBeanProxies;
    protected JavaHelpers fFeatureType;
    protected EditDomain editDomain;

    public EnumeratedLabelProvider(IArrayBeanProxy aBeanInfoValuesArray, JavaHelpers aFeatureType) {
        this.fFeatureType = aFeatureType;
        int length = aBeanInfoValuesArray.getLength();
        int j = 0;
        this.fDisplayNames = new String[length / 3];
        this.fInitStrings = new String[length / 3];
        try {
            int i = 0;
            while (i < length) {
                this.fDisplayNames[j] = ((IStringBeanProxy)aBeanInfoValuesArray.get(i)).stringValue();
                this.fInitStrings[j] = ((IStringBeanProxy)aBeanInfoValuesArray.get(i + 2)).stringValue();
                ++j;
                i += 3;
            }
        }
        catch (ThrowableProxy exc) {
            JavaVEPlugin.log("Unable to determine enumeration values", 5);
            JavaVEPlugin.log(exc, 5);
        }
    }

    public String getText(Object aJavaInstance) {
        IBeanProxy valueProxy = BeanProxyUtilities.getBeanProxy((IJavaInstance)aJavaInstance, EMFEditDomainHelper.getResourceSet((EditDomain)this.editDomain));
        if (this.fBeanProxies == null) {
            String featureTypeName = null;
            featureTypeName = this.fFeatureType instanceof JavaClass ? ((JavaClass)this.fFeatureType).getQualifiedNameForReflection() : this.fFeatureType.getQualifiedName();
            IBeanTypeProxy aBeanTypeProxy = valueProxy.getProxyFactoryRegistry().getBeanTypeProxyFactory().getBeanTypeProxy(featureTypeName);
            this.fBeanProxies = new IBeanProxy[this.fInitStrings.length];
            int index = 0;
            try {
                int i = 0;
                while (i < this.fInitStrings.length) {
                    index = i;
                    this.fBeanProxies[i] = aBeanTypeProxy.newInstance(this.fInitStrings[i]);
                    ++i;
                }
            }
            catch (ThrowableProxy exc) {
                JavaVEPlugin.log("Unable to create enumeration value for " + this.fInitStrings[index], 5);
                JavaVEPlugin.log(exc, 5);
            }
            catch (InstantiationException exc) {
                JavaVEPlugin.log("Unable to create enumeration value for " + this.fInitStrings[index], 5);
                JavaVEPlugin.log(exc, 5);
            }
        }
        if (this.fBeanProxies == null) {
            return JavaMessages.getString("LabelProvider.Enumerated.getText_ERROR_");
        }
        int i = 0;
        while (i < this.fBeanProxies.length) {
            if (this.fBeanProxies[i] == null ? valueProxy == null : this.fBeanProxies[i].equals((Object)valueProxy)) {
                return this.fDisplayNames[i];
            }
            ++i;
        }
        return JavaMessages.getString("LabelProvider.Enumerated.getText_ERROR_");
    }

    public void setData(Object data) {
        this.editDomain = (EditDomain)data;
    }
}

