/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.java.core;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.editparts.AbstractEditPart;
import org.eclipse.jem.internal.instantiation.base.IJavaInstance;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IActionFilter;
import org.eclipse.ve.internal.cde.emf.DefaultGraphicalEditPart;
import org.eclipse.ve.internal.cde.utility.ToolTipContentHelper;
import org.eclipse.ve.internal.java.core.BeanProxyUtilities;
import org.eclipse.ve.internal.java.core.IBeanProxyHost;
import org.eclipse.ve.internal.java.core.IErrorNotifier;
import org.eclipse.ve.internal.java.core.IJavaBeanGraphicalContextMenuContributor;
import org.eclipse.ve.internal.java.core.JavaBeanActionFilter;
import org.eclipse.ve.internal.java.core.JavaBeanTreeEditPart;
import org.eclipse.ve.internal.java.core.ToolTipAssistFactory;

public class JavaBeanGraphicalEditPart
extends DefaultGraphicalEditPart
implements IJavaBeanGraphicalContextMenuContributor {
    protected IErrorNotifier.ErrorListener fBeanProxyErrorListener;
    protected Image fOverlayImage;
    protected int fOverlaySeverity;
    static /* synthetic */ Class class$0;

    public JavaBeanGraphicalEditPart(Object model) {
        this.setModel(model);
    }

    public void activate() {
        super.activate();
        IBeanProxyHost beanProxyHost = BeanProxyUtilities.getBeanProxyHost((IJavaInstance)this.getModel());
        if (this.fBeanProxyErrorListener == null) {
            this.fBeanProxyErrorListener = new IErrorNotifier.ErrorListenerAdapter(){

                public void errorStatus(int severity) {
                    JavaBeanGraphicalEditPart.this.refreshVisuals();
                }
            };
        }
        beanProxyHost.addErrorListener(this.fBeanProxyErrorListener);
    }

    public void deactivate() {
        if (this.fBeanProxyErrorListener != null) {
            IBeanProxyHost beanProxyHost = BeanProxyUtilities.getBeanProxyHost((IJavaInstance)this.getModel());
            beanProxyHost.removeErrorListener(this.fBeanProxyErrorListener);
        }
        if (this.fOverlayImage != null) {
            this.fOverlayImage.dispose();
        }
        super.deactivate();
    }

    protected void setFigureImage(Label aLabel, Image anImage) {
        IBeanProxyHost beanProxyHost = BeanProxyUtilities.getBeanProxyHost((IJavaInstance)this.getModel());
        int beanProxyStatus = beanProxyHost.getErrorStatus();
        if (beanProxyStatus == 0) {
            super.setFigureImage(aLabel, anImage);
        } else {
            if (this.fOverlayImage != null && this.fOverlaySeverity != beanProxyStatus) {
                this.fOverlayImage.dispose();
                this.fOverlayImage = null;
            }
            if (this.fOverlayImage == null && anImage != null) {
                this.fOverlayImage = new Image((Device)this.getViewer().getControl().getDisplay(), new JavaBeanTreeEditPart.JavaBeansImageDescriptor(anImage, beanProxyStatus).getImageData());
                this.fOverlaySeverity = beanProxyStatus;
            }
            super.setFigureImage(aLabel, this.fOverlayImage);
        }
    }

    public Object getAdapter(Class aKey) {
        Object result = super.getAdapter(aKey);
        if (result != null) {
            return result;
        }
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("[Lorg.eclipse.ui.IActionFilter;").getComponentType();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (aKey == clazz) {
            return this.getJavaActionFilter();
        }
        Iterator mofAdapters = ((IJavaInstance)this.getModel()).eAdapters().iterator();
        while (mofAdapters.hasNext()) {
            Object mofAdapterAdapter;
            Object mofAdapter = mofAdapters.next();
            if (!(mofAdapter instanceof IAdaptable) || (mofAdapterAdapter = ((IAdaptable)mofAdapter).getAdapter(aKey)) == null) continue;
            return mofAdapterAdapter;
        }
        return null;
    }

    protected IActionFilter getJavaActionFilter() {
        return JavaBeanActionFilter.INSTANCE;
    }

    public List getEditPolicies() {
        ArrayList<EditPolicy> result = new ArrayList<EditPolicy>();
        AbstractEditPart.EditPolicyIterator i = this.getEditPolicyIterator();
        while (i.hasNext()) {
            result.add(i.next());
        }
        return result;
    }

    protected IFigure createFigure() {
        IFigure fig = super.createFigure();
        IFigure ToolTipFig = ToolTipContentHelper.createToolTip(null, (IContentAssistProcessor[])ToolTipAssistFactory.createToolTipProcessors((EditPart)this));
        fig.setToolTip(ToolTipFig);
        return fig;
    }
}

