/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.java.core;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.ElementChangedEvent;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IElementChangedListener;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaElementDelta;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jem.internal.adapters.jdom.JavaModelListener;
import org.eclipse.jem.internal.proxy.core.IStandardBeanTypeProxyFactory;
import org.eclipse.ve.internal.java.core.IBeanProxyDomain;

public class JavaModelSynchronizer
extends JavaModelListener {
    protected IBeanProxyDomain proxyDomain;
    protected IJavaProject fProject;
    protected IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
    private static final IPath CLASSPATH_PATH = new Path(".classpath");
    private boolean recycleVM = false;
    private Runnable terminateRun;

    public JavaModelSynchronizer(IBeanProxyDomain proxyDomain, IJavaProject aProject, Runnable terminateRun) {
        this.proxyDomain = proxyDomain;
        this.terminateRun = terminateRun;
        this.fProject = aProject;
        JavaCore.removeElementChangedListener((IElementChangedListener)this);
        JavaCore.addElementChangedListener((IElementChangedListener)this, (int)1);
    }

    public void setProject(IJavaProject project) {
        this.fProject = project;
    }

    public void stopSynchronizer() {
        JavaCore.removeElementChangedListener((IElementChangedListener)this);
    }

    protected IJavaProject getJavaProject(IClasspathEntry entry) {
        IProject proj = this.workspaceRoot.getProject(entry.getPath().segment(0));
        if (proj != null) {
            return JavaCore.create((IProject)proj);
        }
        return null;
    }

    private boolean isClassPathChange(IJavaElementDelta delta) {
        int flags = delta.getFlags();
        return delta.getKind() == 4 && (flags & 0x40) != 0 || (flags & 0x80) != 0 || (flags & 0x100) != 0;
    }

    protected boolean isInClasspath(IJavaProject javaProject) {
        IJavaProject adapterJavaProject = this.fProject;
        if (javaProject.equals(adapterJavaProject)) {
            return true;
        }
        return this.isInClasspath(javaProject, adapterJavaProject, true, new HashSet());
    }

    protected boolean isInClasspath(IJavaProject testProject, IJavaProject targetProject, boolean isFirstLevel, Set visited) {
        if (visited.contains(targetProject)) {
            return false;
        }
        visited.add(targetProject);
        IClasspathEntry[] entries = null;
        try {
            entries = targetProject.getRawClasspath();
        }
        catch (JavaModelException javaModelException) {
            return false;
        }
        IJavaProject proj = null;
        ArrayList<IJavaProject> projects = null;
        int i = 0;
        while (i < entries.length) {
            IClasspathEntry entry = entries[i];
            if (entry.getEntryKind() == 2) {
                IClasspathEntry resEntry = JavaCore.getResolvedClasspathEntry((IClasspathEntry)entry);
                proj = this.getJavaProject(resEntry);
                if (isFirstLevel || resEntry.isExported()) {
                    if (proj.equals(testProject)) {
                        return true;
                    }
                    if (projects == null) {
                        projects = new ArrayList<IJavaProject>();
                    }
                    projects.add(proj);
                }
            }
            ++i;
        }
        return this.isInClasspath(testProject, projects, false, visited);
    }

    protected boolean isInClasspath(IJavaProject testProject, List someJavaProjects, boolean isFirstLevel, Set visited) {
        if (someJavaProjects == null) {
            return false;
        }
        int size = someJavaProjects.size();
        IJavaProject javaProj = null;
        int i = 0;
        if (i < size) {
            javaProj = (IJavaProject)someJavaProjects.get(i);
            return this.isInClasspath(testProject, javaProj, isFirstLevel, visited);
        }
        return false;
    }

    private boolean isClasspathResourceChange(IJavaElementDelta delta) {
        IResourceDelta[] resources = delta.getResourceDeltas();
        if (resources == null) {
            return false;
        }
        IPath path = null;
        int i = 0;
        while (i < resources.length) {
            if (resources[i].getKind() == 4 && (path = resources[i].getProjectRelativePath()).equals((Object)CLASSPATH_PATH)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected void processJavaElementChanged(IJavaProject element, IJavaElementDelta delta) {
        if (this.isInClasspath(element)) {
            if (delta.getKind() == 2 || delta.getKind() == 1) {
                if (!element.equals(this.fProject)) {
                    this.recycleVM = true;
                    return;
                }
                return;
            }
            if (this.isClasspathResourceChange(delta)) {
                this.recycleVM = true;
                return;
            }
            this.processChildren((IJavaElement)element, delta);
        }
    }

    protected void processJavaElementChanged(ICompilationUnit element, IJavaElementDelta delta) {
        if (!element.isWorkingCopy()) {
            if (delta.getKind() == 4 || delta.getKind() == 1) {
                try {
                    IType[] flushTypes = element.getAllTypes();
                    IStandardBeanTypeProxyFactory btypeFactory = this.proxyDomain.getProxyFactoryRegistry().getBeanTypeProxyFactory();
                    int i = 0;
                    while (i < flushTypes.length) {
                        String typeName = flushTypes[i].getFullyQualifiedName();
                        if (btypeFactory.isBeanTypeRegistered(typeName) || btypeFactory.isBeanTypeNotFound(typeName)) {
                            this.recycleVM = true;
                            return;
                        }
                        ++i;
                    }
                }
                catch (JavaModelException javaModelException) {}
            }
            if (delta.getKind() == 2) {
                this.testForInnerClasses(this.getFullNameFromElement((IJavaElement)element));
                return;
            }
            this.processChildren((IJavaElement)element, delta);
        }
    }

    protected void testForInnerClasses(String sourceName) {
        String sourceNameForInner = String.valueOf(sourceName) + '$';
        IStandardBeanTypeProxyFactory btypeFactory = this.proxyDomain.getProxyFactoryRegistry().getBeanTypeProxyFactory();
        Iterator itr = btypeFactory.registeredTypes().iterator();
        while (itr.hasNext()) {
            String entryName = (String)itr.next();
            if (!entryName.equals(sourceName) && !entryName.startsWith(sourceNameForInner)) continue;
            this.recycleVM = true;
            return;
        }
    }

    protected void processJavaElementChanged(IClassFile element, IJavaElementDelta delta) {
        if (delta.getKind() == 2) {
            this.testForInnerClasses(this.getFullNameFromElement((IJavaElement)element));
            return;
        }
        this.processChildren((IJavaElement)element, delta);
    }

    protected String getFullNameFromElement(IJavaElement element) {
        String name = element.getElementName();
        if (!(element instanceof ICompilationUnit) && !(element instanceof IClassFile)) {
            return name;
        }
        int periodNdx = name.lastIndexOf(46);
        if (periodNdx == -1) {
            return name;
        }
        String typeName = null;
        String parentName = element.getParent().getElementName();
        typeName = parentName == null || parentName.length() == 0 ? name.substring(0, periodNdx) : String.valueOf(parentName) + "." + name.substring(0, periodNdx);
        return typeName;
    }

    protected void processJavaElementChanged(IPackageFragmentRoot element, IJavaElementDelta delta) {
        if (this.isClassPathChange(delta)) {
            this.recycleVM = true;
        } else {
            super.processJavaElementChanged(element, delta);
        }
    }

    protected void processJavaElementChanged(IType element, IJavaElementDelta delta) {
        String typeName;
        IStandardBeanTypeProxyFactory btypeFactory;
        if (!this.recycleVM && ((btypeFactory = this.proxyDomain.getProxyFactoryRegistry().getBeanTypeProxyFactory()).isBeanTypeRegistered(typeName = element.getFullyQualifiedName()) || btypeFactory.isBeanTypeNotFound(typeName))) {
            this.recycleVM = true;
        }
    }

    public String toString() {
        return String.valueOf(super.toString()) + " " + this.fProject.getElementName();
    }

    public void elementChanged(ElementChangedEvent event) {
        if (!this.proxyDomain.getProxyFactoryRegistry().isValid()) {
            return;
        }
        this.recycleVM = false;
        super.elementChanged(event);
        if (this.recycleVM) {
            this.recycleVM = false;
            this.terminateRun.run();
        }
    }
}

