/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.java.rules;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gef.commands.Command;
import org.eclipse.ve.internal.cde.commands.CommandBuilder;
import org.eclipse.ve.internal.cde.commands.NoOpCommand;
import org.eclipse.ve.internal.cde.core.EditDomain;
import org.eclipse.ve.internal.java.rules.IChildRule;
import org.eclipse.ve.internal.java.rules.IPropertyRule;
import org.eclipse.ve.internal.propertysheet.common.commands.CommandWrapper;
import org.eclipse.ve.internal.propertysheet.common.commands.CompoundCommand;

public class RuledCommandBuilder
extends CommandBuilder {
    protected EditDomain domain;
    protected CompoundCommand postCommand;
    private boolean regularCmd = true;
    private boolean propertyRule = true;
    private boolean applyRules = true;

    public RuledCommandBuilder(EditDomain domain, String name, boolean regularCmd) {
        super(name, regularCmd);
        this.domain = domain;
        this.regularCmd = regularCmd;
    }

    public RuledCommandBuilder(EditDomain domain, String name) {
        super(name);
        this.domain = domain;
    }

    public RuledCommandBuilder(EditDomain domain) {
        this.domain = domain;
    }

    public RuledCommandBuilder(boolean regularCmd) {
        super(regularCmd);
        this.regularCmd = regularCmd;
    }

    public void appendPost(Command post) {
        if (post != null) {
            if (this.postCommand == null) {
                this.postCommand = new CompoundCommand("Postset of properties");
            }
            this.postCommand.append(post);
        }
    }

    protected CompoundCommand appendPre(Command preCmd, CompoundCommand buildUp) {
        if (this.regularCmd) {
            this.internalAppend(preCmd);
        } else {
            if (buildUp == null) {
                buildUp = new CompoundCommand();
            }
            buildUp.append(preCmd);
        }
        return buildUp;
    }

    protected CompoundCommand propertySet(EObject target, EStructuralFeature feature, Object newValue, CompoundCommand buildUp) {
        if (feature instanceof EReference) {
            boolean isSet = target.eIsSet(feature);
            EObject oldValue = (EObject)target.eGet(feature);
            if (!isSet || oldValue != newValue) {
                buildUp = this.appendPre(this.createPre(target, feature, newValue), buildUp);
            }
            if (isSet && oldValue != newValue) {
                this.appendPost(this.createPost(oldValue));
            }
        }
        return buildUp;
    }

    protected Command createPre(EObject target, EStructuralFeature feature, Object newValue) {
        return this.isPropertyRule() ? ((IPropertyRule)this.domain.getRuleRegistry().getRule(IPropertyRule.RULE_ID)).preSet(this.domain, target, (EObject)newValue, (EReference)feature) : ((IChildRule)this.domain.getRuleRegistry().getRule(IChildRule.RULE_ID)).preCreateChild(this.domain, target, (EObject)newValue, (EReference)feature);
    }

    protected Command createPost(Object oldValue) {
        return this.isPropertyRule() ? ((IPropertyRule)this.domain.getRuleRegistry().getRule(IPropertyRule.RULE_ID)).postSet(this.domain, (EObject)oldValue) : ((IChildRule)this.domain.getRuleRegistry().getRule(IChildRule.RULE_ID)).postDeleteChild(this.domain, (EObject)oldValue);
    }

    protected void propertyUnset(EObject target, EStructuralFeature feature) {
        if (feature instanceof EReference && target.eIsSet(feature)) {
            this.appendPost(this.createPost(target.eGet(feature)));
        }
    }

    protected void propertyUnset(EObject target, EStructuralFeature feature, Object oldValue) {
        if (feature instanceof EReference) {
            this.appendPost(this.createPost(oldValue));
        }
    }

    protected CompoundCommand propertyAdd(EObject target, EStructuralFeature feature, Object newValue, CompoundCommand buildUp) {
        if (feature instanceof EReference) {
            buildUp = this.appendPre(this.createPre(target, feature, newValue), buildUp);
        }
        return buildUp;
    }

    protected CompoundCommand propertyAdds(EObject target, EStructuralFeature feature, List values, CompoundCommand buildUp) {
        if (feature instanceof EReference) {
            Iterator itr = values.iterator();
            while (itr.hasNext()) {
                buildUp = this.appendPre(this.createPre(target, feature, itr.next()), buildUp);
            }
        }
        return buildUp;
    }

    public void applyAttributeSetting(EObject target, EStructuralFeature feature, Object value, int index) {
        CompoundCommand buildUp = null;
        if (this.applyRules) {
            buildUp = this.propertyAdd(target, feature, value, buildUp);
        }
        if (buildUp == null) {
            super.applyAttributeSetting(target, feature, value, index);
        } else {
            buildUp.append(this.internalApplyAttributeSetting(target, feature, value, index));
            this.internalAppend((Command)buildUp);
        }
    }

    public void applyAttributeSetting(EObject target, EStructuralFeature feature, Object value, Object before) {
        CompoundCommand buildUp = null;
        if (this.applyRules) {
            buildUp = this.propertyAdd(target, feature, value, buildUp);
        }
        if (buildUp == null) {
            super.applyAttributeSetting(target, feature, value, before);
        } else {
            buildUp.append(this.internalApplyAttributeSetting(target, feature, value, before));
            this.internalAppend((Command)buildUp);
        }
    }

    public void applyAttributeSetting(EObject target, EStructuralFeature feature, Object value) {
        CompoundCommand buildUp = null;
        if (this.applyRules) {
            buildUp = !feature.isMany() ? this.propertySet(target, feature, value, buildUp) : this.propertyAdd(target, feature, value, buildUp);
        }
        if (buildUp == null) {
            super.applyAttributeSetting(target, feature, value);
        } else {
            buildUp.append(this.internalApplyAttributeSetting(target, feature, value));
            this.internalAppend((Command)buildUp);
        }
    }

    public void applyAttributeSettings(EObject target, EStructuralFeature feature, List values, int index) {
        CompoundCommand buildUp = null;
        if (this.applyRules) {
            buildUp = this.propertyAdds(target, feature, values, buildUp);
        }
        if (buildUp == null) {
            super.applyAttributeSettings(target, feature, values, index);
        } else {
            buildUp.append(this.internalApplyAttributeSettings(target, feature, values, index));
            this.internalAppend((Command)buildUp);
        }
    }

    public void applyAttributeSettings(EObject target, EStructuralFeature feature, List values, Object before) {
        CompoundCommand buildUp = null;
        if (this.applyRules) {
            buildUp = this.propertyAdds(target, feature, values, buildUp);
        }
        if (buildUp == null) {
            super.applyAttributeSettings(target, feature, values, before);
        } else {
            buildUp.append(this.internalApplyAttributeSettings(target, feature, values, before));
            this.internalAppend((Command)buildUp);
        }
    }

    public void applyAttributeSettings(EObject target, EStructuralFeature feature, List values) {
        CompoundCommand buildUp = null;
        if (this.applyRules) {
            buildUp = this.propertyAdds(target, feature, values, buildUp);
        }
        if (buildUp == null) {
            super.applyAttributeSettings(target, feature, values);
        } else {
            buildUp.append(this.internalApplyAttributeSettings(target, feature, values));
            this.internalAppend((Command)buildUp);
        }
    }

    public void cancelAttributeSetting(EObject target, EStructuralFeature feature, Object value) {
        if (this.applyRules) {
            this.propertyUnset(target, feature, value);
        }
        super.cancelAttributeSetting(target, feature, value);
    }

    public void cancelAttributeSetting(EObject target, EStructuralFeature feature) {
        if (this.applyRules && feature instanceof EReference) {
            if (feature.isMany()) {
                this.listClear(target, feature);
            } else if (target.eIsSet(feature)) {
                this.appendPost(this.createPost(target.eGet(feature)));
            }
        }
        super.cancelAttributeSetting(target, feature);
    }

    protected void listClear(EObject target, EStructuralFeature feature) {
        ClearAttributeSettingPostCommand post = new ClearAttributeSettingPostCommand(this.domain, this.isPropertyRule());
        this.internalAppend((Command)new GatherClearAttributeSettingCommand((List)target.eGet(feature), post));
        this.appendPost((Command)post);
    }

    public void cancelAttributeSettings(EObject target, EStructuralFeature feature, List values) {
        if (this.applyRules && feature instanceof EReference) {
            Iterator itr = values.iterator();
            while (itr.hasNext()) {
                this.appendPost(this.createPost(itr.next()));
            }
        }
        super.cancelAttributeSettings(target, feature, values);
    }

    public void cancelGroupAttributeSetting(List targets, EStructuralFeature feature) {
        if (this.applyRules) {
            Iterator iter = targets.iterator();
            while (iter.hasNext()) {
                EObject object = (EObject)iter.next();
                this.cancelAttributeSetting(object, feature);
            }
        } else {
            super.cancelGroupAttributeSetting(targets, feature);
        }
    }

    public Command getCommand() {
        if (this.postCommand != null) {
            CompoundCommand c = new CompoundCommand();
            c.append(super.getCommand());
            c.append(this.postCommand.unwrap());
            return c.unwrap();
        }
        return super.getCommand();
    }

    public boolean isEmpty() {
        return super.isEmpty() && (this.postCommand == null || this.postCommand.isEmpty());
    }

    public void replaceAttributeSetting(EObject target, EStructuralFeature feature, Object newValue, int index) {
        CompoundCommand buildUp = null;
        if (this.applyRules) {
            buildUp = this.propertyAdd(target, feature, newValue, buildUp);
            this.propertyUnset(target, feature, ((List)target.eGet(feature)).get(index));
        }
        if (buildUp == null) {
            super.replaceAttributeSetting(target, feature, newValue, index);
        } else {
            buildUp.append(this.internalReplaceAttributeSetting(target, feature, newValue, index));
            this.internalAppend((Command)buildUp);
        }
    }

    public void replaceEntireAttributeSettingList(EObject target, EStructuralFeature feature, List list) {
        CompoundCommand buildUp = null;
        if (this.applyRules) {
            buildUp = this.propertyAdds(target, feature, list, buildUp);
            this.listClear(target, feature);
        }
        if (buildUp == null) {
            super.replaceEntireAttributeSettingList(target, feature, list);
        } else {
            buildUp.append(this.internalReplaceEntireAttributeSettingList(target, feature, list));
            this.internalAppend((Command)buildUp);
        }
    }

    public boolean setPropertyRule(boolean propertyRule) {
        boolean oldPropertyRule = this.propertyRule;
        this.propertyRule = propertyRule;
        return oldPropertyRule;
    }

    public boolean isPropertyRule() {
        return this.propertyRule;
    }

    public boolean setApplyRules(boolean applyRules) {
        boolean oldApplyRules = this.applyRules;
        this.applyRules = applyRules;
        return oldApplyRules;
    }

    public boolean isApplyRules() {
        return this.applyRules;
    }

    protected static class ClearAttributeSettingPostCommand
    extends CommandWrapper {
        protected List unsetValues;
        protected EditDomain domain;
        protected boolean isProperty;

        public ClearAttributeSettingPostCommand(EditDomain domain, boolean isProperty) {
            this.domain = domain;
            this.isProperty = isProperty;
        }

        public void execute() {
            if (this.unsetValues != null && !this.unsetValues.isEmpty()) {
                CompoundCommand c = new CompoundCommand();
                Iterator itr = this.unsetValues.iterator();
                while (itr.hasNext()) {
                    c.append(this.isProperty ? ((IPropertyRule)this.domain.getRuleRegistry().getRule(IPropertyRule.RULE_ID)).postSet(this.domain, (EObject)itr.next()) : ((IChildRule)this.domain.getRuleRegistry().getRule(IChildRule.RULE_ID)).postDeleteChild(this.domain, (EObject)itr.next()));
                }
                this.command = c.isEmpty() ? NoOpCommand.INSTANCE : c.unwrap();
            } else {
                this.command = NoOpCommand.INSTANCE;
            }
            super.execute();
        }

        protected boolean prepare() {
            return true;
        }
    }

    protected static class GatherClearAttributeSettingCommand
    extends CommandWrapper {
        protected List values;
        protected ClearAttributeSettingPostCommand clearPostCmd;

        public GatherClearAttributeSettingCommand(List values, ClearAttributeSettingPostCommand clearPostCmd) {
            this.values = values;
            this.clearPostCmd = clearPostCmd;
        }

        public void execute() {
            if (!this.values.isEmpty()) {
                this.clearPostCmd.unsetValues = new ArrayList(this.values);
            }
            this.command = NoOpCommand.INSTANCE;
            super.execute();
        }

        protected boolean prepare() {
            return true;
        }
    }
}

