/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.java.vce;

import java.util.ArrayList;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.ve.internal.cde.core.CDEPlugin;
import org.eclipse.ve.internal.java.core.JavaVEPlugin;

public class VCEPreferences {
    public static final String SWING_LOOKANDFEEL = "SWING_LOOKANDFEEL";
    public static final String USER_DEFINED_LOOKANDFEEL = "USER_DEFINED_LOOKANDFEEL";
    public static final String SHOW_LIVE_WINDOW = "SHOW_LIVE_WINDOW";
    public static final String OPEN_PROPERTIES_VIEW = "OPEN_PROPERTIES_VIEW";
    public static final String OPEN_JAVABEANS_VIEW = "OPEN_JAVABEANS_VIEW";
    public static final String NOTEBOOK_PAGE = "NOTEBOOK_PAGE";
    public static final String SELECT_SOURCE = "SELECT_SOURCE";
    public static final String SPLITPANE_SHOW_GEF_PALETTE = "SPLITPANE_SHOW_GEF_PALETTE";
    public static final String NOTEBOOK_SHOW_GEF_PALETTE = "NOTEBOOK_SHOW_GEF_PALETTE";
    public static final String SOURCE_SYNC_DELAY = "SOURCE_SYNC_DELAY";
    public static final int DEFAULT_SYNC_DELAY = 500;
    public static final String SOURCE_DELAY_FACTOR = "SOURCE_DELAY_FACTOR";
    public static final int DEFAULT_L2R_FACTOR = 2;
    public static final String GENERATE_COMMENT = "GENERATE_EXPRESSION_COMMENT";
    public static final String GENERATE_TRY_CATCH_BLOCK = "GENERATE_TRY_CATCH_BLOCK";
    public static final String PALETTE_SASH_LEFT_RATIO = "PALETTE_SASH_LEFT_RATIO";
    public static final String PALETTE_SASH_RIGHT_RATIO = "PALETE_SASH_RIGHT_RATIO";
    public static final int DEFAULT_PALETTE_SASH_LEFT_RATIO = 1;
    public static final int DEFAULT_PALETTE_SASH_RIGHT_RATIO = 4;
    public static final String LOOK_AND_FEEL = "lookandfeel";
    public static final String LF_NAME = "name";
    public static final String LF_CLASS = "class";
    public static final String MAX_AWT_COMPONENT_IMAGE_WIDTH = "MAX_AWT_COMPONENT_IMAGE_WIDTH";
    public static final int DEFAULT_MAX_AWT_COMPONENT_IMAGE_WIDTH = 3000;
    public static final String MAX_AWT_COMPONENT_IMAGE_HEIGHT = "MAX_AWT_COMPONENT_IMAGE_HEIGHT";
    public static final int DEFAULT_MAX_AWT_COMPONENT_IMAGE_HEIGHT = 3000;
    public static final String DEBUG_CONSOLE_ECHO = "/debug/consolelog";
    public static final String DEBUG_XMITEXT_OPTION = "/debug/xmltext";
    public static final String DEBUG_LIVEWINDOW_OPTION = "/debug/livewindow";
    public static final String JVE_PATTERN_STYLE_ID = "JVA_PATTERN_STYLE_ID";

    public static String[][] getPluginLookAndFeelClasses() {
        IExtensionPoint lookAndFeelExtensionPoint = VCEPreferences.getPlugin().getDescriptor().getExtensionPoint(LOOK_AND_FEEL);
        if (lookAndFeelExtensionPoint == null) {
            return new String[0][];
        }
        IConfigurationElement[] lookAndFeelElements = lookAndFeelExtensionPoint.getConfigurationElements();
        String[][] result = new String[lookAndFeelElements.length][];
        int i = 0;
        while (i < lookAndFeelElements.length) {
            try {
                IConfigurationElement pointConfig = lookAndFeelElements[i];
                result[i] = new String[]{pointConfig.getAttributeAsIs(LF_NAME), pointConfig.getAttributeAsIs(LF_CLASS)};
            }
            catch (Exception exception) {}
            ++i;
        }
        return result;
    }

    public static String[][] getUserLookAndFeelClasses() {
        ArrayList<String[]> result = new ArrayList<String[]>(0);
        String userDefinedLookAndFeel = VCEPreferences.getPlugin().getPluginPreferences().getString(USER_DEFINED_LOOKANDFEEL);
        if (userDefinedLookAndFeel != null) {
            StringTokenizer tokenizer = new StringTokenizer(userDefinedLookAndFeel, ",");
            while (tokenizer.hasMoreElements()) {
                String lfName = (String)tokenizer.nextElement();
                if (!tokenizer.hasMoreElements()) continue;
                String lfClass = (String)tokenizer.nextElement();
                result.add(new String[]{lfName, lfClass});
            }
        }
        if (result.size() > 0) {
            return (String[][])result.toArray((T[])new String[result.size()][]);
        }
        return new String[0][];
    }

    public static void setUserLookAndFeelClasses(String[][] nameClassPairs) {
        if (nameClassPairs == null) {
            VCEPreferences.getPlugin().getPluginPreferences().setToDefault(USER_DEFINED_LOOKANDFEEL);
        } else {
            StringBuffer buffer = new StringBuffer();
            int i = 0;
            while (i < nameClassPairs.length) {
                String[] lfNameClass = nameClassPairs[i];
                if (i > 0) {
                    buffer.append(',');
                }
                buffer.append(lfNameClass[0]);
                buffer.append(',');
                buffer.append(lfNameClass[1]);
                ++i;
            }
            VCEPreferences.getPlugin().getPluginPreferences().setValue(USER_DEFINED_LOOKANDFEEL, buffer.toString());
        }
    }

    public static JavaVEPlugin getPlugin() {
        return JavaVEPlugin.getPlugin();
    }

    public static void initializeDefaultPluginPreferences(Preferences aStore) {
        aStore.setDefault(NOTEBOOK_SHOW_GEF_PALETTE, true);
        aStore.setDefault(SPLITPANE_SHOW_GEF_PALETTE, true);
        aStore.setDefault(OPEN_JAVABEANS_VIEW, true);
        aStore.setDefault(OPEN_PROPERTIES_VIEW, true);
        aStore.setDefault(SOURCE_SYNC_DELAY, 500);
        aStore.setDefault(SOURCE_DELAY_FACTOR, 2);
        aStore.setDefault(PALETTE_SASH_LEFT_RATIO, 1);
        aStore.setDefault(PALETTE_SASH_RIGHT_RATIO, 4);
        aStore.setDefault(JVE_PATTERN_STYLE_ID, "GetterStyle");
        aStore.setDefault(MAX_AWT_COMPONENT_IMAGE_WIDTH, 3000);
        aStore.setDefault(MAX_AWT_COMPONENT_IMAGE_HEIGHT, 3000);
    }

    public static boolean isOptionSet(String option) {
        String fullOption = String.valueOf(VCEPreferences.getPlugin().getDescriptor().getUniqueIdentifier()) + option;
        return "true".equalsIgnoreCase(Platform.getDebugOption((String)fullOption));
    }

    protected static boolean isXMLText() {
        return VCEPreferences.isOptionSet(DEBUG_XMITEXT_OPTION);
    }

    public static boolean isXMLTextOn() {
        return VCEPreferences.isXMLText() && CDEPlugin.getPlugin().getPluginPreferences().getBoolean("SHOW_XML");
    }

    public static boolean isLiveWindow() {
        return VCEPreferences.isOptionSet(DEBUG_LIVEWINDOW_OPTION);
    }

    public static boolean isLiveWindowOn() {
        return VCEPreferences.isLiveWindow() && VCEPreferences.getPlugin().getPluginPreferences().getBoolean(SHOW_LIVE_WINDOW);
    }

    public static String getStyleID() {
        return VCEPreferences.getPlugin().getPluginPreferences().getString(JVE_PATTERN_STYLE_ID);
    }
}

