/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.java.vce.launcher;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Locale;
import javax.swing.UIManager;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.debug.ui.launcher.JavaLaunchConfigurationTab;
import org.eclipse.jdt.internal.launching.JavaLaunchConfigurationUtils;
import org.eclipse.jdt.internal.ui.util.BusyIndicatorRunnableContext;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jdt.ui.JavaElementLabelProvider;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.ve.internal.java.core.JavaVEPlugin;
import org.eclipse.ve.internal.java.vce.VCEPreferencePage;
import org.eclipse.ve.internal.java.vce.VCEPreferences;
import org.eclipse.ve.internal.java.vce.launcher.JavaBeanFinder;
import org.eclipse.ve.internal.java.vce.launcher.JavaBeanLaunchConfigurationDelegate;
import org.eclipse.ve.internal.java.vce.launcher.JavaBeanTypeFinderDialog;
import org.eclipse.ve.internal.java.vce.launcher.VCELauncherMessages;

public class JavaBeanTab
extends JavaLaunchConfigurationTab {
    private Label fProjLabel;
    private Text fProjText;
    private Button fProjButton;
    private Label fMainLabel;
    private Text fMainText;
    private Button fSearchButton;
    private Button fSearchExternalJarsCheckButton;
    protected List fLookAndFeelList;
    protected ArrayList fLookAndFeelClasses;
    protected Button fPackWindow;
    protected Text fLocaleText;
    protected Button fDefaultLocaleButton;
    private static final String EMPTY_STRING = "";

    public void createControl(Composite parent) {
        Composite comp = new Composite(parent, 0);
        this.setControl((Control)comp);
        GridLayout topLayout = new GridLayout();
        comp.setLayout((Layout)topLayout);
        this.createVerticalSpacer(comp);
        Composite projComp = new Composite(comp, 0);
        GridLayout projLayout = new GridLayout();
        projLayout.numColumns = 2;
        projLayout.marginHeight = 0;
        projLayout.marginWidth = 0;
        projComp.setLayout((Layout)projLayout);
        GridData gd = new GridData(768);
        projComp.setLayoutData((Object)gd);
        this.fProjLabel = new Label(projComp, 0);
        this.fProjLabel.setText(VCELauncherMessages.getString("BeanTab.project.label"));
        gd = new GridData();
        gd.horizontalSpan = 2;
        this.fProjLabel.setLayoutData((Object)gd);
        this.fProjText = new Text(projComp, 2052);
        gd = new GridData(768);
        this.fProjText.setLayoutData((Object)gd);
        this.fProjText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent evt) {
                JavaBeanTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.fProjButton = this.createPushButton(projComp, VCELauncherMessages.getString("BeanTab.browse.label"), null);
        this.fProjButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                JavaBeanTab.this.handleProjectButtonSelected();
            }
        });
        Composite mainComp = new Composite(comp, 0);
        GridLayout mainLayout = new GridLayout();
        mainLayout.numColumns = 3;
        mainLayout.marginHeight = 0;
        mainLayout.marginWidth = 0;
        mainComp.setLayout((Layout)mainLayout);
        gd = new GridData(768);
        mainComp.setLayoutData((Object)gd);
        this.fMainLabel = new Label(mainComp, 0);
        this.fMainLabel.setText(VCELauncherMessages.getString("BeanTab.bean.label"));
        gd = new GridData();
        gd.horizontalSpan = 3;
        this.fMainLabel.setLayoutData((Object)gd);
        this.fMainText = new Text(mainComp, 2052);
        gd = new GridData(768);
        this.fMainText.setLayoutData((Object)gd);
        this.fMainText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent evt) {
                JavaBeanTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.fSearchButton = this.createPushButton(mainComp, VCELauncherMessages.getString("BeanTab.search.label"), null);
        this.fSearchButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                JavaBeanTab.this.handleSearchButtonSelected();
            }
        });
        this.fSearchExternalJarsCheckButton = new Button(mainComp, 32);
        this.fSearchExternalJarsCheckButton.setText(VCELauncherMessages.getString("BeanTab.externaljars.label"));
        this.fSearchExternalJarsCheckButton.setToolTipText(VCELauncherMessages.getString("BeanTab.externaljars.tooltip"));
        Label fJavaBeanLabel = new Label(mainComp, 0);
        fJavaBeanLabel.setText(VCELauncherMessages.getString("BeanTab.lookfeel.label"));
        gd = new GridData();
        gd.horizontalSpan = 3;
        fJavaBeanLabel.setLayoutData((Object)gd);
        this.fLookAndFeelClasses = new ArrayList();
        this.fLookAndFeelList = new List(mainComp, 2048);
        GridData data = new GridData(768);
        data.horizontalAlignment = 4;
        data.verticalAlignment = 1;
        data.horizontalSpan = 3;
        this.fLookAndFeelList.setLayoutData((Object)data);
        Label fLocaleLabel = new Label(comp, 0);
        fLocaleLabel.setText(VCELauncherMessages.getString("BeanTab.locale.label"));
        gd = new GridData();
        fLocaleLabel.setLayoutData((Object)gd);
        Composite localeComp = new Composite(comp, 0);
        GridLayout localeLayout = new GridLayout();
        localeLayout.numColumns = 3;
        localeLayout.marginHeight = 0;
        localeLayout.marginWidth = 0;
        localeComp.setLayout((Layout)localeLayout);
        gd = new GridData(768);
        localeComp.setLayoutData((Object)gd);
        this.fDefaultLocaleButton = new Button(localeComp, 32);
        data = new GridData();
        this.fDefaultLocaleButton.setData((Object)data);
        this.fDefaultLocaleButton.setText(VCELauncherMessages.getString("BeanTab.default.label"));
        this.fDefaultLocaleButton.setSelection(true);
        this.fLocaleText = new Text(localeComp, 2048);
        this.fLocaleText.setEnabled(false);
        data = new GridData(768);
        data.grabExcessHorizontalSpace = true;
        data.horizontalAlignment = 256;
        this.fLocaleText.setData((Object)data);
        Label fSuggestionLabel = new Label(localeComp, 0);
        fSuggestionLabel.setText(VCELauncherMessages.getString("BeanTab.localesuggest.label"));
        gd = new GridData(768);
        fSuggestionLabel.setLayoutData((Object)gd);
        this.fDefaultLocaleButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                JavaBeanTab.this.fLocaleText.setEnabled(!JavaBeanTab.this.fDefaultLocaleButton.getSelection());
            }
        });
        this.fLocaleText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                JavaBeanTab.this.updateLaunchConfigurationDialog();
            }
        });
        Label fSizeLabel = new Label(comp, 0);
        fSizeLabel.setText(VCELauncherMessages.getString("BeanTab.size.label"));
        Composite visualComp = new Composite(comp, 0);
        GridLayout visualLayout = new GridLayout();
        visualLayout.numColumns = 1;
        visualLayout.marginHeight = 0;
        visualLayout.marginWidth = 0;
        visualComp.setLayout((Layout)visualLayout);
        gd = new GridData(768);
        visualComp.setLayoutData((Object)gd);
        this.fPackWindow = new Button(visualComp, 32);
        this.fPackWindow.setText(VCELauncherMessages.getString("BeanTab.pack.label"));
        this.fPackWindow.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                JavaBeanTab.this.updateLaunchConfigurationDialog();
            }
        });
    }

    protected boolean validateLocale() {
        String newLocaleText = this.fLocaleText.getText();
        if (newLocaleText.equals(EMPTY_STRING)) {
            this.setErrorMessage(null);
            return true;
        }
        boolean localeIsValid = false;
        int i = 0;
        while (i < Locale.getAvailableLocales().length) {
            if (newLocaleText.trim().equals(Locale.getAvailableLocales()[i].toString().trim())) {
                localeIsValid = true;
                this.setErrorMessage(null);
            }
            ++i;
        }
        if (!localeIsValid) {
            this.setErrorMessage(String.valueOf(VCELauncherMessages.getString("BeanTab.badlocale.msg_ERROR_")) + this.fLocaleText.getText());
        }
        return localeIsValid;
    }

    public void initializeFrom(ILaunchConfiguration config) {
        this.updateProjectFromConfig(config);
        this.updateMainTypeFromConfig(config);
        this.fLookAndFeelList.removeAll();
        this.fLookAndFeelList.add(VCEPreferencePage.LnF_DEFAULT);
        UIManager.LookAndFeelInfo[] lnfs = UIManager.getInstalledLookAndFeels();
        int i = 0;
        while (i < lnfs.length) {
            this.fLookAndFeelList.add(lnfs[i].getName());
            this.fLookAndFeelClasses.add(lnfs[i].getClassName());
            ++i;
        }
        String[][] userLookAndFeelClasses = VCEPreferences.getUserLookAndFeelClasses();
        int i2 = 0;
        while (i2 < userLookAndFeelClasses.length) {
            this.fLookAndFeelList.add(userLookAndFeelClasses[i2][0]);
            this.fLookAndFeelClasses.add(userLookAndFeelClasses[i2][1]);
            ++i2;
        }
        String[][] pluginLookAndFeelClasses = VCEPreferences.getPluginLookAndFeelClasses();
        int i3 = 0;
        while (i3 < pluginLookAndFeelClasses.length) {
            this.fLookAndFeelList.add(pluginLookAndFeelClasses[i3][0]);
            this.fLookAndFeelClasses.add(pluginLookAndFeelClasses[i3][1]);
            ++i3;
        }
        try {
            String lookAndFeel = config.getAttribute("SWING_LOOKANDFEEL", EMPTY_STRING);
            if (lookAndFeel.equals(EMPTY_STRING)) {
                this.fLookAndFeelList.setSelection(0);
            } else {
                int i4 = 0;
                while (i4 < this.fLookAndFeelClasses.size()) {
                    if (this.fLookAndFeelClasses.get(i4).equals(lookAndFeel)) {
                        this.fLookAndFeelList.setSelection(i4 + 1);
                        break;
                    }
                    ++i4;
                }
            }
            this.fLookAndFeelList.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    JavaBeanTab.this.updateLaunchConfigurationDialog();
                }
            });
            String locale = config.getAttribute(JavaBeanLaunchConfigurationDelegate.LOCALE, EMPTY_STRING);
            if (locale.equals(EMPTY_STRING)) {
                this.fDefaultLocaleButton.setSelection(true);
                this.fLocaleText.setText(EMPTY_STRING);
            } else {
                this.fDefaultLocaleButton.setSelection(false);
                this.fLocaleText.setEnabled(true);
                this.fLocaleText.setText(locale);
            }
            boolean pack = config.getAttribute(JavaBeanLaunchConfigurationDelegate.PACK, false);
            this.fPackWindow.setSelection(pack);
        }
        catch (CoreException coreException) {
            this.fLookAndFeelList.setSelection(0);
        }
    }

    protected void updateProjectFromConfig(ILaunchConfiguration config) {
        String projectName = EMPTY_STRING;
        try {
            projectName = config.getAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, EMPTY_STRING);
        }
        catch (CoreException ce) {
            JavaVEPlugin.log(ce.getStatus(), 5);
        }
        this.fProjText.setText(projectName);
    }

    protected void updateMainTypeFromConfig(ILaunchConfiguration config) {
        String mainTypeName = EMPTY_STRING;
        try {
            mainTypeName = config.getAttribute(IJavaLaunchConfigurationConstants.ATTR_MAIN_TYPE_NAME, EMPTY_STRING);
        }
        catch (CoreException ce) {
            JavaVEPlugin.log(ce.getStatus(), 5);
        }
        this.fMainText.setText(mainTypeName);
    }

    public void performApply(ILaunchConfigurationWorkingCopy config) {
        config.setAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, this.fProjText.getText());
        config.setAttribute(IJavaLaunchConfigurationConstants.ATTR_MAIN_TYPE_NAME, this.fMainText.getText());
        if (this.fLookAndFeelList.getSelectionIndex() == 0) {
            config.setAttribute("SWING_LOOKANDFEEL", EMPTY_STRING);
        } else {
            config.setAttribute("SWING_LOOKANDFEEL", (String)this.fLookAndFeelClasses.get(this.fLookAndFeelList.getSelectionIndex() - 1));
        }
        if (this.fDefaultLocaleButton.getSelection()) {
            config.setAttribute(JavaBeanLaunchConfigurationDelegate.LOCALE, EMPTY_STRING);
        } else {
            config.setAttribute(JavaBeanLaunchConfigurationDelegate.LOCALE, this.fLocaleText.getText());
        }
        config.setAttribute(JavaBeanLaunchConfigurationDelegate.PACK, this.fPackWindow.getSelection());
    }

    public void dispose() {
    }

    protected void createVerticalSpacer(Composite comp) {
        new Label(comp, 0);
    }

    protected void handleSearchButtonSelected() {
        IJavaProject javaProject = this.getJavaProject();
        IJavaProject elem = null;
        if (javaProject != null && javaProject.exists()) {
            elem = javaProject;
        }
        int constraints = 8;
        if (this.fSearchExternalJarsCheckButton.getSelection()) {
            constraints |= 0x10;
        }
        Shell shell = this.getShell();
        JavaBeanTypeFinderDialog dialog = new JavaBeanTypeFinderDialog(shell, (IRunnableContext)this.getLaunchConfigurationDialog(), (IJavaElement)elem, constraints);
        dialog.setFilter(this.fMainText.getText());
        dialog.setTitle(VCELauncherMessages.getString("BeanTab.search.title"));
        dialog.setMessage(VCELauncherMessages.getString("BeanTab.search.msg"));
        if (dialog.open() == 1) {
            return;
        }
        Object[] results = dialog.getResult();
        if (results == null || results.length < 1) {
            return;
        }
        IType type = (IType)results[0];
        if (type != null) {
            this.fMainText.setText(type.getFullyQualifiedName());
            javaProject = type.getJavaProject();
            this.fProjText.setText(javaProject.getElementName());
        }
    }

    protected void handleProjectButtonSelected() {
        IJavaProject project = this.chooseJavaProject();
        if (project == null) {
            return;
        }
        String projectName = project.getElementName();
        this.fProjText.setText(projectName);
    }

    protected IJavaProject chooseJavaProject() {
        Object[] projects;
        try {
            projects = JavaCore.create((IWorkspaceRoot)this.getWorkspaceRoot()).getJavaProjects();
        }
        catch (JavaModelException e) {
            JavaVEPlugin.log(e.getStatus(), 5);
            projects = new IJavaProject[]{};
        }
        JavaElementLabelProvider labelProvider = new JavaElementLabelProvider(JavaElementLabelProvider.SHOW_DEFAULT);
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(this.getShell(), (ILabelProvider)labelProvider);
        dialog.setTitle(VCELauncherMessages.getString("BeanTab.project.search.title"));
        dialog.setMessage(VCELauncherMessages.getString("BeanTab.project.search.msg"));
        dialog.setElements(projects);
        IJavaProject javaProject = this.getJavaProject();
        if (javaProject != null) {
            dialog.setInitialSelections(new Object[]{javaProject});
        }
        if (dialog.open() == 0) {
            return (IJavaProject)dialog.getFirstResult();
        }
        return null;
    }

    protected IJavaProject getJavaProject() {
        String projectName = this.fProjText.getText().trim();
        if (projectName.length() < 1) {
            return null;
        }
        return this.getJavaModel().getJavaProject(projectName);
    }

    private IWorkspaceRoot getWorkspaceRoot() {
        return ResourcesPlugin.getWorkspace().getRoot();
    }

    private IJavaModel getJavaModel() {
        return JavaCore.create((IWorkspaceRoot)this.getWorkspaceRoot());
    }

    public boolean isValid(ILaunchConfiguration config) {
        boolean isValidLocale;
        this.setErrorMessage(null);
        this.setMessage(null);
        String name = this.fProjText.getText().trim();
        if (name.length() > 0 && !ResourcesPlugin.getWorkspace().getRoot().getProject(name).exists()) {
            this.setErrorMessage(VCELauncherMessages.getString("BeanTab.badproject.msg_ERROR_"));
            return false;
        }
        name = this.fMainText.getText().trim();
        if (name.length() == 0) {
            this.setErrorMessage(VCELauncherMessages.getString("BeanTab.nobean.msg_ERROR_"));
            return false;
        }
        IJavaProject jp = this.getJavaProject();
        if (jp != null) {
            try {
                JavaLaunchConfigurationUtils.getMainType((String)name, (IJavaProject)jp);
            }
            catch (CoreException coreException) {
                this.setErrorMessage(VCELauncherMessages.getString("BeanTab.badbean.msg_ERROR_"));
                return false;
            }
        }
        return isValidLocale = this.validateLocale();
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy config) {
        IJavaElement je = this.getContext();
        if (je != null) {
            this.initializeJavaProject(je, config);
        } else {
            config.setAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, EMPTY_STRING);
        }
        this.initializeHardCodedDefaults(config);
        this.initializeMainTypeAndName(je, config);
    }

    protected void initializeMainTypeAndName(IJavaElement javaElement, ILaunchConfigurationWorkingCopy config) {
        String name = null;
        if (javaElement instanceof IMember) {
            IMember member = (IMember)javaElement;
            javaElement = member.isBinary() ? member.getClassFile() : member.getCompilationUnit();
        }
        if (javaElement instanceof ICompilationUnit || javaElement instanceof IClassFile) {
            try {
                IType[] types = JavaBeanFinder.findTargets((IRunnableContext)new BusyIndicatorRunnableContext(), new Object[]{javaElement});
                if (types != null && types.length > 0) {
                    name = types[0].getFullyQualifiedName();
                }
            }
            catch (InterruptedException interruptedException) {
            }
            catch (InvocationTargetException invocationTargetException) {}
        }
        if (name == null) {
            name = EMPTY_STRING;
        }
        config.setAttribute(IJavaLaunchConfigurationConstants.ATTR_MAIN_TYPE_NAME, name);
        if (name.length() > 0) {
            int index = name.lastIndexOf(46);
            if (index > 0) {
                name = name.substring(index + 1);
            }
            name = this.getLaunchConfigurationDialog().generateName(name);
            config.rename(name);
        }
    }

    public String getName() {
        return VCELauncherMessages.getString("BeanTab.title");
    }

    protected void initializeHardCodedDefaults(ILaunchConfigurationWorkingCopy config) {
        String lookAndFeel = VCEPreferences.getPlugin().getPluginPreferences().getString("SWING_LOOKANDFEEL");
        if (lookAndFeel != null) {
            config.setAttribute("SWING_LOOKANDFEEL", lookAndFeel);
        }
        config.setAttribute(JavaBeanLaunchConfigurationDelegate.LOCALE, EMPTY_STRING);
    }

    public Image getImage() {
        return JavaVEPlugin.getJavaBeanImage();
    }
}

