/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jem.internal.adapters.jdom;

import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.XMIResource;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jem.internal.adapters.jdom.JDOMAdaptor;
import org.eclipse.jem.internal.adapters.jdom.JDOMSearchHelper;
import org.eclipse.jem.internal.adapters.jdom.JavaClassJDOMAdaptor;
import org.eclipse.jem.internal.java.JavaClass;
import org.eclipse.jem.internal.java.JavaVisibilityKind;
import org.eclipse.jem.internal.java.Method;
import org.eclipse.jem.internal.java.adapters.JavaReflectionAdaptor;
import org.eclipse.jem.internal.java.adapters.ReflectionAdaptor;
import org.eclipse.jem.internal.java.adapters.nls.ResourceHandler;
import org.eclipse.jem.internal.java.impl.MethodImpl;

public class JavaMethodJDOMAdaptor
extends JDOMAdaptor {
    protected IMethod sourceMethod = null;
    protected IType parentType = null;

    public JavaMethodJDOMAdaptor(Notifier target, IJavaProject workingProject) {
        super(target, workingProject);
    }

    protected void addExceptions() {
        try {
            IMethod sourceMethod = this.getSourceMethod();
            String[] exceptionNames = sourceMethod.getExceptionTypes();
            EList exceptions = ((MethodImpl)this.getTarget()).getJavaExceptionsGen();
            int i = 0;
            while (i < exceptionNames.length) {
                exceptions.add(this.createJavaClassRef(this.typeNameFromSignature(exceptionNames[i])));
                ++i;
            }
        }
        catch (JavaModelException javaModelException) {}
    }

    protected void addParameters() {
        String[] parmNames = new String[]{};
        String[] parmTypeNames = this.getSourceMethod().getParameterTypes();
        try {
            parmNames = this.getSourceMethod().getParameterNames();
        }
        catch (JavaModelException javaModelException) {}
        if (parmNames == null || parmNames.length == 0) {
            parmNames = new String[parmTypeNames.length];
            int i = 0;
            while (i < parmTypeNames.length) {
                parmNames[i] = "arg" + i;
                ++i;
            }
        }
        MethodImpl javaMethodTarget = (MethodImpl)this.getTarget();
        EList params = javaMethodTarget.getParametersGen();
        int i = 0;
        while (i < parmNames.length) {
            params.add(this.createJavaParameter((Method)javaMethodTarget, parmNames[i], this.typeNameFromSignature(parmTypeNames[i])));
            ++i;
        }
    }

    protected void clearSource() {
        this.sourceMethod = null;
    }

    protected JavaClass getContainingJavaClass() {
        return ((Method)this.getTarget()).getContainingJavaClass();
    }

    protected IType getParentType() {
        Method targetMethod;
        JavaClass parentJavaClass;
        JavaClassJDOMAdaptor pa;
        if (this.parentType == null && (pa = (JavaClassJDOMAdaptor)EcoreUtil.getAdapter((List)(parentJavaClass = (targetMethod = (Method)this.getTarget()).getContainingJavaClass()).eAdapters(), (Object)"JavaReflection")) != null) {
            this.parentType = pa.getSourceType();
        }
        return this.parentType;
    }

    protected String[] getParmTypeSignatures() {
        Method javaMethodTarget = (Method)this.getTarget();
        String[] typeNames = JavaReflectionAdaptor.getTypeNamesFromMethodID((String)((XMIResource)javaMethodTarget.eResource()).getID((EObject)javaMethodTarget));
        if (typeNames == null) {
            return ReflectionAdaptor.emptyStringArray;
        }
        int n = typeNames.length;
        if (n == 0) {
            return ReflectionAdaptor.emptyStringArray;
        }
        String[] typeSigs = new String[n];
        try {
            int i = 0;
            while (i < n) {
                typeSigs[i] = Signature.createTypeSignature((String)new String(typeNames[i]), (boolean)this.getParentType().isBinary());
                ++i;
            }
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        return typeSigs;
    }

    public Object getReflectionSource() {
        return this.getSourceMethod();
    }

    public IMethod getSourceMethod() {
        if (this.sourceMethod == null || !this.sourceMethod.exists()) {
            try {
                IType parent = this.getParentType();
                if (parent != null) {
                    String[] parmNames = this.getParmTypeSignatures();
                    this.sourceMethod = JDOMSearchHelper.searchForMatchingMethod(parent, ((Method)this.getTarget()).getName(), parmNames);
                }
            }
            catch (JavaModelException javaModelException) {}
        }
        return this.sourceMethod;
    }

    protected IType getType() {
        return this.getParentType();
    }

    protected Map getTypeResolutionCache() {
        JDOMAdaptor classAdaptor;
        JavaClass javaClass;
        Method method = (Method)this.getTarget();
        if (method != null && (javaClass = method.getJavaClass()) != null && (classAdaptor = (JDOMAdaptor)ReflectionAdaptor.retrieveAdaptorFrom((EObject)javaClass)) != null) {
            return classAdaptor.getTypeResolutionCache();
        }
        return null;
    }

    public Object getValueIn(EObject object, EObject attribute) {
        return super.getValueIn(object, attribute);
    }

    public boolean reflectValues() {
        if (this.getSourceProject() != null && this.getSourceMethod() != null && this.sourceMethod.exists()) {
            this.setGeneratedFlag();
            this.setModifiers();
            this.setNaming();
            this.setReturnType();
            this.addParameters();
            this.addExceptions();
            return true;
        }
        return false;
    }

    protected void setGeneratedFlag() {
        Method methodTarget = (Method)this.getTarget();
        try {
            int index;
            String source = this.getSourceMethod().getSource();
            if (source != null && (index = source.indexOf("@generated")) > 0) {
                methodTarget.setIsGenerated(true);
            }
        }
        catch (JavaModelException javaModelException) {}
    }

    protected void setModifiers() {
        Method methodTarget = (Method)this.getTarget();
        try {
            methodTarget.setFinal(Flags.isFinal((int)this.getSourceMethod().getFlags()));
            methodTarget.setNative(Flags.isNative((int)this.getSourceMethod().getFlags()));
            methodTarget.setStatic(Flags.isStatic((int)this.getSourceMethod().getFlags()));
            methodTarget.setSynchronized(Flags.isSynchronized((int)this.getSourceMethod().getFlags()));
            methodTarget.setConstructor(this.getSourceMethod().isConstructor());
            JavaClass javaClass = this.getContainingJavaClass();
            if (javaClass.getKind().getValue() == 2) {
                methodTarget.setAbstract(true);
            } else {
                methodTarget.setAbstract(Flags.isAbstract((int)this.getSourceMethod().getFlags()));
            }
            if (javaClass.getKind().getValue() == 2 || Flags.isPublic((int)this.getSourceMethod().getFlags())) {
                methodTarget.setJavaVisibility(JavaVisibilityKind.PUBLIC_LITERAL);
            } else if (Flags.isPrivate((int)this.getSourceMethod().getFlags())) {
                methodTarget.setJavaVisibility(JavaVisibilityKind.PRIVATE_LITERAL);
            } else if (Flags.isProtected((int)this.getSourceMethod().getFlags())) {
                methodTarget.setJavaVisibility(JavaVisibilityKind.PROTECTED_LITERAL);
            } else {
                methodTarget.setJavaVisibility(JavaVisibilityKind.PACKAGE_LITERAL);
            }
        }
        catch (JavaModelException npe) {
            System.out.println(ResourceHandler.getString((String)"Error_Introspecting_Flags_ERROR_", (Object[])new Object[]{((XMIResource)methodTarget.eResource()).getID((EObject)methodTarget), npe.getMessage()}));
        }
    }

    protected void setNaming() {
    }

    protected void setReturnType() {
        String typeName = null;
        try {
            typeName = this.typeNameFromSignature(this.getSourceMethod().getReturnType());
        }
        catch (JavaModelException javaModelException) {}
        if (typeName != null) {
            Method javaMethodTarget = (Method)this.getTarget();
            javaMethodTarget.setEType((EClassifier)this.createJavaClassRef(typeName));
        }
    }

    public void setSourceMethod(IMethod newSourceMethod) {
        this.sourceMethod = newSourceMethod;
    }
}

