/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jem.internal.adapters.jdom;

import org.eclipse.jdt.core.ElementChangedEvent;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IElementChangedListener;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaElementDelta;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;

public class JavaModelListener
implements IElementChangedListener {
    public JavaModelListener() {
        JavaCore.addElementChangedListener((IElementChangedListener)this, (int)7);
    }

    public void elementChanged(ElementChangedEvent event) {
        this.processDelta((IJavaElementDelta)event.getSource());
    }

    protected void processChildren(IJavaElement element, IJavaElementDelta delta) {
        IJavaElementDelta[] children = delta.getAffectedChildren();
        int i = 0;
        while (i < children.length) {
            this.processDelta(children[i]);
            ++i;
        }
    }

    protected void processContentChanged(IJavaElementDelta delta) {
    }

    public void processDelta(IJavaElementDelta delta) {
        IJavaElement element = delta.getElement();
        switch (element.getElementType()) {
            case 1: {
                this.processJavaElementChanged((IJavaModel)element, delta);
                break;
            }
            case 2: {
                this.processJavaElementChanged((IJavaProject)element, delta);
                break;
            }
            case 3: {
                this.processJavaElementChanged((IPackageFragmentRoot)element, delta);
                break;
            }
            case 4: {
                this.processJavaElementChanged((IPackageFragment)element, delta);
                break;
            }
            case 5: {
                this.processJavaElementChanged((ICompilationUnit)element, delta);
                this.processContentChanged(delta);
                break;
            }
            case 6: {
                this.processJavaElementChanged((IClassFile)element, delta);
                break;
            }
            case 7: {
                this.processJavaElementChanged((IType)element, delta);
            }
        }
    }

    protected void processJavaElementChanged(IClassFile element, IJavaElementDelta delta) {
    }

    protected void processJavaElementChanged(ICompilationUnit element, IJavaElementDelta delta) {
        this.processChildren((IJavaElement)element, delta);
    }

    protected void processJavaElementChanged(IJavaModel element, IJavaElementDelta delta) {
        this.processChildren((IJavaElement)element, delta);
    }

    protected void processJavaElementChanged(IJavaProject element, IJavaElementDelta delta) {
        this.processChildren((IJavaElement)element, delta);
    }

    protected void processJavaElementChanged(IPackageFragment element, IJavaElementDelta delta) {
        this.processChildren((IJavaElement)element, delta);
    }

    protected void processJavaElementChanged(IPackageFragmentRoot element, IJavaElementDelta delta) {
        this.processChildren((IJavaElement)element, delta);
    }

    protected void processJavaElementChanged(IType element, IJavaElementDelta delta) {
    }
}

