/* @(#) DisplayStyleEditor.java        Ver 1.0    01,April,1998
 *
 * Copyright (c) 1998 International Business Machines.
 * All Rights Reserved.
 *
 * Author : Sunanda Bera & P.Sushma
 * Last Modified : 01,April,1998
 *
 * Purpose : Defines class DisplayStyleEditor.
 *
 *
 * Revision History 
 * ======== ======= 
 *
 * Date        By            Description
 * ----        --            -----------
 *
 *
 */
package com.ibm.clock.editors;

import java.beans.PropertyEditorSupport;

import com.ibm.clock.DigitalDisplay;

public class DisplayStyleEditor
extends PropertyEditorSupport
{
    private int value;
    public String getAsText()
    {   
       String returnValue = new String();
       value = ( ( Integer )(getValue( ) ) ).intValue();
       if ( value == DigitalDisplay.FULL )
       {
       returnValue =  "FULL";
       }
       if ( value == DigitalDisplay.LONG )
       {
       returnValue =  "LONG";
       }
       if ( value == DigitalDisplay.SHORT )
       {
       returnValue = "SHORT";
       }
       return returnValue; 
    }//end of getAsText
    
    public String [] getTags()
    {
        String [] displayStyles = { "FULL", "LONG", "SHORT" };
        return displayStyles;
    }//end of getTags
    
    public boolean supportsCustomEditor()
    {
        return false;
    }//end supportsCustomEditor
                                                                             
    public void setAsText( String style )
    {
        int returnvalue;
        if( style.equals( "FULL"))
        {
            returnvalue = DigitalDisplay.FULL;
        }   // End if .
        else if( style.equals( "LONG"))
        {
            returnvalue = DigitalDisplay.LONG;
        }   // end else if .
        else if ( style.equals( "SHORT"))
        {
            returnvalue = DigitalDisplay.SHORT;
        }   // End else-if.
        else
        {
            returnvalue = -1;
        }   // End else.
                
        setValue( new Integer( returnvalue));                             
    }   //End method setAsText
    

    
    public String getJavaInitializationString()
    {
        int value = ((Integer )getValue( )).intValue( );    
        return "" + value;
    }   // End of getJavaInitializationString.
    
}//end of DigitalDisplayStyleEditor 
