package com.ibm.calendar.editors;

import java.awt.*;
import java.awt.event.*;
import java.beans.*;

public class DateEditorPanel extends Panel
{  
   private Choice yearChoice;
   private Choice monthChoice;
   private Choice dayChoice;
   PropertyEditorSupport editor;
  public DateEditorPanel(PropertyEditorSupport ed)
  {  

	editor = ed;
	yearChoice = new Choice();
	monthChoice = new Choice();
	dayChoice = new Choice();
	initLists();

	java.util.Calendar tempCal = java.util.Calendar.getInstance();
	tempCal.setTime((java.util.Date)editor.getValue());
	  	
// in the case of setting a holiday, getValue() may return "Mar 3 04:05:06 1799". We only set the choices when this is not the case.
	if (!(tempCal.get(java.util.Calendar.YEAR) == -100 && tempCal.get(java.util.Calendar.MONTH) == 2 
	   && tempCal.get(java.util.Calendar.DATE) == 3    && tempCal.get(java.util.Calendar.HOUR) == 4
	   && tempCal.get(java.util.Calendar.MINUTE) == 5  && tempCal.get(java.util.Calendar.SECOND) == 6))
	{ 
		yearChoice.select("" + tempCal.get(java.util.Calendar.YEAR));
		monthChoice.select(tempCal.get(java.util.Calendar.MONTH));
		dayChoice.select(tempCal.get(java.util.Calendar.DATE) - 1); 
	}
	else { // today's values
		tempCal = java.util.Calendar.getInstance();
		yearChoice.select("" + tempCal.get(java.util.Calendar.YEAR));
		monthChoice.select(tempCal.get(java.util.Calendar.MONTH));
		dayChoice.select(tempCal.get(java.util.Calendar.DATE) - 1); 
	}

	Panel p = new Panel();
	p.add(yearChoice);
	p.add(monthChoice);
	p.add(dayChoice);

	setLayout(new BorderLayout());

	add(p);

	Button b = new Button("Set new value");
	add("South",b);
/*
	b.addActionListener(new ActionListener()
		 {  public void actionPerformed(ActionEvent event)
			{  editor.setValue(new java.util.Date(
			yearChoice.getSelectedIndex(),
			monthChoice.getSelectedIndex(),  
			dayChoice.getSelectedIndex()+1
					));
			   editor.firePropertyChange();
			}
		 });
*/
/*
	tempCal.set(yearChoice.getSelectedIndex(),monthChoice.getSelectedIndex(),dayChoice.getSelectedIndex()+1);

	b.addActionListener(new ActionListener()
	{
		public void actionPerformed(ActionEvent event)
		{
			editor.setValue(new java.util.Date(tempCal.getTimeInMillis()));
			editor.firePropertyChange();
		}
	});
*/

//	tempCal.set(yearChoice.getSelectedIndex(),monthChoice.getSelectedIndex(),dayChoice.getSelectedIndex()+1);

	b.addActionListener(new ActionListener()
	{
		public void actionPerformed(ActionEvent event)
		{
			java.util.Calendar tempCal = java.util.Calendar.getInstance();
			tempCal.set(yearChoice.getSelectedIndex() + 1900,monthChoice.getSelectedIndex(),dayChoice.getSelectedIndex()+1);
			editor.setValue(tempCal.getTime());
			editor.firePropertyChange();
		}
	});

   }                                                                                       
  private void initLists()
  {

	monthChoice.add("Jan");
	monthChoice.add("Feb");
	monthChoice.add("Mar");
	monthChoice.add("Apr");
	monthChoice.add("May");
	monthChoice.add("Jun");
	monthChoice.add("Jul");
	monthChoice.add("Aug");
	monthChoice.add("Sep");
	monthChoice.add("Oct");
	monthChoice.add("Nov");
	monthChoice.add("Dec");
	for (int i = 1900; i < 2041; i++)
		yearChoice.add("" + i);
	for (int i = 1; i < 32; i++)
		dayChoice.add("" + i);
  }            
}