/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jem.internal.proxy.remote;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.launching.IRuntimeClasspathEntry;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jem.internal.proxy.core.IConfigurationContributionController;
import org.eclipse.jem.internal.proxy.core.ProxyLaunchSupport;
import org.eclipse.jem.internal.proxy.core.ProxyPlugin;
import org.osgi.framework.Bundle;

public class LocalFileConfigurationContributorController
implements IConfigurationContributionController {
    private URL[] classpathInfo;
    private URL[][] bootpathInfo;
    private List classpath;
    private List prependBootpath;
    private List appendBootpath;
    private List javaLibraryPath;
    private ProxyLaunchSupport.LaunchInfo launchInfo;

    public LocalFileConfigurationContributorController(URL[] classpathInfo, URL[][] bootpathInfo, ProxyLaunchSupport.LaunchInfo launchInfo) {
        this.classpathInfo = classpathInfo;
        this.bootpathInfo = bootpathInfo;
        this.launchInfo = launchInfo;
    }

    public URL[] getFinalClasspath() {
        if (this.classpath == null) {
            return this.classpathInfo;
        }
        return this.classpath.toArray(new URL[this.classpath.size()]);
    }

    public URL[] getFinalPrependBootpath() {
        if (this.prependBootpath == null) {
            return this.bootpathInfo[0];
        }
        return this.prependBootpath.toArray(new URL[this.prependBootpath.size()]);
    }

    public URL[] getFinalAppendBootpath() {
        if (this.appendBootpath == null) {
            return this.bootpathInfo[2];
        }
        return this.prependBootpath.toArray(new URL[this.appendBootpath.size()]);
    }

    public List getFinalJavaLibraryPath() {
        if (this.javaLibraryPath == null) {
            return Collections.EMPTY_LIST;
        }
        return this.javaLibraryPath;
    }

    protected List getClasspath() {
        if (this.classpath == null) {
            this.classpath = new ArrayList(this.classpathInfo.length);
            this.addAll(this.classpath, this.classpathInfo, -1);
        }
        return this.classpath;
    }

    protected List getPrependBootpath() {
        if (this.prependBootpath == null) {
            if (this.bootpathInfo[0] != null) {
                this.prependBootpath = new ArrayList(this.bootpathInfo[0].length);
                this.addAll(this.prependBootpath, this.bootpathInfo[0], -1);
            } else {
                this.prependBootpath = new ArrayList(1);
            }
        }
        return this.prependBootpath;
    }

    protected List getAppendBootpath() {
        if (this.appendBootpath == null) {
            if (this.bootpathInfo[2] != null) {
                this.appendBootpath = new ArrayList(this.bootpathInfo[2].length);
                this.addAll(this.appendBootpath, this.bootpathInfo[2], -1);
            } else {
                this.appendBootpath = new ArrayList(1);
            }
        }
        return this.appendBootpath;
    }

    protected List getJavaLibraryPath() {
        if (this.javaLibraryPath == null) {
            this.javaLibraryPath = new ArrayList(3);
        }
        return this.javaLibraryPath;
    }

    protected void addAll(List toList, Object[] array, int loc) {
        int i = 0;
        while (i < array.length) {
            if (!toList.contains(array[i])) {
                if (loc == -1) {
                    toList.add(array[i]);
                } else {
                    toList.add(loc++, array[i]);
                }
            }
            ++i;
        }
    }

    protected void addLocations(List toList, IRuntimeClasspathEntry[] entries) {
        int i = 0;
        while (i < entries.length) {
            IRuntimeClasspathEntry entry = entries[i];
            URL location = ProxyLaunchSupport.convertStringPathToURL((String)entry.getLocation());
            if (location != null && !toList.contains(location)) {
                toList.add(location);
            }
            ++i;
        }
    }

    public IJavaProject getJavaProject() {
        return this.launchInfo.getJavaProject();
    }

    public void contributeProject(IProject project) throws CoreException {
        IJavaProject jproject = JavaCore.create((IProject)project);
        IRuntimeClasspathEntry[] projPath = JavaRuntime.computeUnresolvedRuntimeClasspath((IJavaProject)jproject);
        boolean jreContainerFound = false;
        int i = 0;
        while (i < projPath.length) {
            IRuntimeClasspathEntry entry = projPath[i];
            if (entry.getClasspathProperty() == 2 || entry.getClasspathProperty() == 1) {
                int entryKind = entry.getClasspathEntry().getEntryKind();
                String segment0 = entry.getPath().segment(0);
                if (entryKind == 5 && JavaRuntime.JRE_CONTAINER.equals(segment0) || entryKind == 4 && "JRE_LIB".equals(segment0)) {
                    jreContainerFound = true;
                } else if (jreContainerFound) {
                    this.addLocations(this.getAppendBootpath(), JavaRuntime.resolveRuntimeClasspathEntry((IRuntimeClasspathEntry)entry, (IJavaProject)jproject));
                } else {
                    this.addLocations(this.getPrependBootpath(), JavaRuntime.resolveRuntimeClasspathEntry((IRuntimeClasspathEntry)entry, (IJavaProject)jproject));
                }
            } else {
                this.addLocations(this.getClasspath(), JavaRuntime.resolveRuntimeClasspathEntry((IRuntimeClasspathEntry)entry, (IJavaProject)jproject));
            }
            ++i;
        }
    }

    public void contributeClasspath(String classpath, int typeFlag) {
        this.contributeClasspath(ProxyLaunchSupport.convertStringPathToURL((String)classpath), typeFlag);
    }

    public void contributeClasspath(URL classpathURL, int typeFlag) {
        if (classpathURL == null) {
            return;
        }
        switch (typeFlag) {
            case 3: {
                if (this.getPrependBootpath().contains(classpathURL)) break;
                this.getPrependBootpath().add(classpathURL);
                break;
            }
            case 1: {
                if (this.getClasspath().contains(classpathURL)) break;
                this.getClasspath().add(0, classpathURL);
                break;
            }
            case 0: {
                if (this.getClasspath().contains(classpathURL)) break;
                this.getClasspath().add(classpathURL);
                break;
            }
            case 2: {
                if (this.getAppendBootpath().contains(classpathURL)) break;
                this.getAppendBootpath().add(classpathURL);
                break;
            }
            case 4: {
                if (this.getJavaLibraryPath().contains(classpathURL)) break;
                this.getJavaLibraryPath().add(classpathURL);
            }
        }
    }

    public void contributeClasspath(Bundle bundle, String relativePath, int typeFlag, boolean nlsLocalize) {
        if (!nlsLocalize || typeFlag == 4) {
            this.contributeClasspath(ProxyPlugin.getPlugin().urlLocalizeFromBundle(bundle, relativePath), typeFlag);
        } else {
            this.contributeClasspath(ProxyPlugin.getPlugin().urlLocalizeFromBundleAndFragments(bundle, relativePath), typeFlag);
        }
    }

    public void contributeClasspath(Bundle bundle, IPath relativePath, int typeFlag, boolean nlsLocalize) {
        if (!nlsLocalize || typeFlag == 4) {
            this.contributeClasspath(ProxyPlugin.getPlugin().urlLocalizeFromBundle(bundle, relativePath), typeFlag);
        } else {
            this.contributeClasspath(ProxyPlugin.getPlugin().urlLocalizeFromBundleAndFragments(bundle, relativePath), typeFlag);
        }
    }

    public void contributeClasspath(String[] classpaths, int typeFlag) {
        this.contributeClasspath(ProxyLaunchSupport.convertStringPathsToURL((String[])classpaths), typeFlag);
    }

    public void contributeClasspath(URL[] classpathURLs, int typeFlag) {
        if (classpathURLs == null) {
            return;
        }
        switch (typeFlag) {
            case 3: {
                this.addAll(this.getPrependBootpath(), classpathURLs, -1);
                break;
            }
            case 1: {
                this.addAll(this.getClasspath(), classpathURLs, 0);
                break;
            }
            case 0: {
                this.addAll(this.getClasspath(), classpathURLs, -1);
                break;
            }
            case 2: {
                this.addAll(this.getAppendBootpath(), classpathURLs, -1);
                break;
            }
            case 4: {
                this.addAll(this.getJavaLibraryPath(), classpathURLs, -1);
            }
        }
    }
}

