/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jem.internal.proxy.remote;

import org.eclipse.core.runtime.Status;
import org.eclipse.jem.internal.proxy.common.CommandException;
import org.eclipse.jem.internal.proxy.common.remote.Commands;
import org.eclipse.jem.internal.proxy.common.remote.TransmitableArray;
import org.eclipse.jem.internal.proxy.core.IBeanProxy;
import org.eclipse.jem.internal.proxy.core.IBeanTypeProxy;
import org.eclipse.jem.internal.proxy.core.IBooleanBeanProxy;
import org.eclipse.jem.internal.proxy.core.IConstructorProxy;
import org.eclipse.jem.internal.proxy.core.IFieldProxy;
import org.eclipse.jem.internal.proxy.core.IInvokable;
import org.eclipse.jem.internal.proxy.core.IMethodProxy;
import org.eclipse.jem.internal.proxy.core.IStandardBeanTypeProxyFactory;
import org.eclipse.jem.internal.proxy.core.ProxyFactoryRegistry;
import org.eclipse.jem.internal.proxy.core.ProxyPlugin;
import org.eclipse.jem.internal.proxy.core.ThrowableProxy;
import org.eclipse.jem.internal.proxy.remote.IREMBeanTypeProxy;
import org.eclipse.jem.internal.proxy.remote.IREMMethodProxy;
import org.eclipse.jem.internal.proxy.remote.REMMethodProxyFactory;
import org.eclipse.jem.internal.proxy.remote.REMProxyFactoryRegistry;
import org.eclipse.jem.internal.proxy.remote.REMStandardBeanProxyConstants;
import org.eclipse.jem.internal.proxy.remote.REMStandardBeanProxyFactory;
import org.eclipse.jem.internal.proxy.remote.REMStandardBeanTypeProxyFactory;

public abstract class REMAbstractBeanTypeProxy
implements IREMBeanTypeProxy {
    private Integer fID;
    protected final REMProxyFactoryRegistry fRegistry;
    protected final String fClassname;
    private IBeanTypeProxy fSuperType;

    protected REMAbstractBeanTypeProxy(REMProxyFactoryRegistry aRegistry, Integer anID, String aClassname, IBeanTypeProxy aSuperType) {
        this.fRegistry = aRegistry;
        this.fID = anID;
        this.fClassname = aClassname;
        this.fSuperType = aSuperType;
    }

    public boolean equals(Object anObject) {
        return super.equals(anObject);
    }

    public boolean sameAs(IBeanProxy aBeanProxy) {
        return this == aBeanProxy;
    }

    public Integer getID() {
        return this.fID;
    }

    public boolean isValid() {
        return this.fID != null;
    }

    public void release() {
        this.fID = null;
        this.fSuperType = null;
    }

    public IConstructorProxy getConstructorProxy(String[] argumentClassNames) {
        if (this.isInterface()) {
            return null;
        }
        IBeanTypeProxy[] argTypes = null;
        if (argumentClassNames != null) {
            IStandardBeanTypeProxyFactory typeFactory = this.fRegistry.getBeanTypeProxyFactory();
            argTypes = new IBeanTypeProxy[argumentClassNames.length];
            int i = 0;
            while (i < argumentClassNames.length) {
                argTypes[i] = typeFactory.getBeanTypeProxy(argumentClassNames[i]);
                IBeanTypeProxy type = argTypes[i];
                if (type == null) {
                    return null;
                }
                ++i;
            }
        }
        return this.getConstructorProxy(argTypes);
    }

    public IConstructorProxy getConstructorProxy(IBeanTypeProxy[] argumentTypes) {
        Object[] objectArray;
        if (this.isInterface()) {
            return null;
        }
        IREMMethodProxy getCtorMethod = (IREMMethodProxy)REMStandardBeanProxyConstants.getConstants(this.fRegistry).getClassConstructor();
        if (argumentTypes != null) {
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = new TransmitableArray(22, (Object[])argumentTypes);
        } else {
            objectArray = null;
        }
        Object[] getParms = objectArray;
        try {
            return (IConstructorProxy)getCtorMethod.invokeWithParms(this, getParms);
        }
        catch (ThrowableProxy e) {
            this.fRegistry.releaseProxy((IBeanProxy)e);
            return null;
        }
    }

    public IFieldProxy getDeclaredFieldProxy(String fieldName) {
        return (IFieldProxy)REMStandardBeanProxyConstants.getConstants(this.fRegistry).getClassGetDeclaredField().invokeCatchThrowableExceptions((IBeanProxy)this, (IBeanProxy)this.fRegistry.getBeanProxyFactory().createBeanProxyWith(fieldName));
    }

    public IFieldProxy getFieldProxy(String fieldName) {
        return (IFieldProxy)REMStandardBeanProxyConstants.getConstants(this.fRegistry).getClassGetField().invokeCatchThrowableExceptions((IBeanProxy)this, (IBeanProxy)this.fRegistry.getBeanProxyFactory().createBeanProxyWith(fieldName));
    }

    public IMethodProxy getMethodProxy(String methodName) {
        return ((REMMethodProxyFactory)this.fRegistry.getMethodProxyFactory()).getMethodProxy((IREMBeanTypeProxy)this, methodName, (IBeanTypeProxy[])null);
    }

    public IMethodProxy getMethodProxy(String methodName, String[] argumentClassNames) {
        return ((REMMethodProxyFactory)this.fRegistry.getMethodProxyFactory()).getMethodProxy((IREMBeanTypeProxy)this, methodName, argumentClassNames);
    }

    public IMethodProxy getMethodProxy(String methodName, String argumentQualifiedTypeName) {
        return this.getMethodProxy(methodName, new String[]{argumentQualifiedTypeName});
    }

    public IMethodProxy getMethodProxy(String methodName, IBeanTypeProxy[] argumentTypes) {
        return ((REMMethodProxyFactory)this.fRegistry.getMethodProxyFactory()).getMethodProxy((IREMBeanTypeProxy)this, methodName, argumentTypes);
    }

    public IInvokable getInvokable(String methodName) {
        return ((REMMethodProxyFactory)this.fRegistry.getMethodProxyFactory()).getInvokable((IREMBeanTypeProxy)this, methodName, (IBeanTypeProxy[])null);
    }

    public IInvokable getInvokable(String methodName, String[] argumentClassNames) {
        return ((REMMethodProxyFactory)this.fRegistry.getMethodProxyFactory()).getInvokable((IREMBeanTypeProxy)this, methodName, argumentClassNames);
    }

    public IInvokable getInvokable(String methodName, String argumentQualifiedTypeName) {
        return this.getInvokable(methodName, new String[]{argumentQualifiedTypeName});
    }

    public IInvokable getInvokable(String methodName, IBeanTypeProxy[] argumentTypes) {
        return ((REMMethodProxyFactory)this.fRegistry.getMethodProxyFactory()).getInvokable((IREMBeanTypeProxy)this, methodName, argumentTypes);
    }

    public IConstructorProxy getNullConstructorProxy() {
        return this.getConstructorProxy((IBeanTypeProxy[])null);
    }

    public ProxyFactoryRegistry getProxyFactoryRegistry() {
        return this.fRegistry;
    }

    public IBeanTypeProxy getSuperBeanTypeProxy() {
        return this.fSuperType;
    }

    public String getTypeName() {
        return this.fClassname;
    }

    public boolean isArray() {
        return false;
    }

    public boolean isInterface() {
        return false;
    }

    public boolean isPrimitive() {
        return false;
    }

    public boolean isKindOf(IBeanTypeProxy aBeanProxyType) {
        return ((IBooleanBeanProxy)REMStandardBeanProxyConstants.getConstants(this.fRegistry).getClassIsAssignableFrom().invokeCatchThrowableExceptions((IBeanProxy)aBeanProxyType, (IBeanProxy)this)).booleanValue();
    }

    public IBeanProxy newInstance(String initializationString) throws ThrowableProxy, ClassCastException, InstantiationException {
        try {
            return ((REMStandardBeanProxyFactory)this.fRegistry.getBeanProxyFactory()).createBeanProxy(this, initializationString);
        }
        catch (CommandException e) {
            ProxyPlugin.getPlugin().getLogger().log((Object)new Status(2, ProxyPlugin.getPlugin().getBundle().getSymbolicName(), 0, "", (Throwable)e));
            return null;
        }
    }

    public String toString() {
        return String.valueOf(super.toString()) + "(" + this.getTypeName() + ")";
    }

    public IBeanTypeProxy getTypeProxy() {
        return ((REMStandardBeanTypeProxyFactory)this.fRegistry.getBeanTypeProxyFactory()).classClass;
    }

    public String toBeanString() {
        return this.getTypeName();
    }

    public IBeanProxy newInstance() throws ThrowableProxy {
        return ((REMStandardBeanProxyFactory)this.fRegistry.getBeanProxyFactory()).createBeanProxy(this);
    }

    public void renderBean(Commands.ValueObject value) {
        value.setObjectID(this.getID().intValue());
    }

    public String getFormalTypeName() {
        return this.getTypeName();
    }

    public String getInitializationError() {
        return null;
    }
}

