/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jem.internal.proxy.remote;

import org.eclipse.core.runtime.Status;
import org.eclipse.jem.internal.proxy.core.IArrayBeanProxy;
import org.eclipse.jem.internal.proxy.core.IArrayBeanTypeProxy;
import org.eclipse.jem.internal.proxy.core.IBeanProxy;
import org.eclipse.jem.internal.proxy.core.IBeanTypeProxy;
import org.eclipse.jem.internal.proxy.core.IIntegerBeanProxy;
import org.eclipse.jem.internal.proxy.core.ProxyPlugin;
import org.eclipse.jem.internal.proxy.core.ThrowableProxy;
import org.eclipse.jem.internal.proxy.remote.IREMBeanProxy;
import org.eclipse.jem.internal.proxy.remote.IREMMethodProxy;
import org.eclipse.jem.internal.proxy.remote.REMBeanProxy;
import org.eclipse.jem.internal.proxy.remote.REMProxyFactoryRegistry;
import org.eclipse.jem.internal.proxy.remote.REMStandardBeanProxyConstants;

public final class REMArrayBeanProxy
extends REMBeanProxy
implements IArrayBeanProxy {
    private int fLength = -1;

    REMArrayBeanProxy(REMProxyFactoryRegistry aRegistry, Integer anID, IBeanTypeProxy aType) {
        super(aRegistry, anID, aType);
    }

    public IBeanProxy get(int index) throws ThrowableProxy {
        Object[] parms = new Object[]{this, new Integer(index)};
        IBeanTypeProxy compType = ((IArrayBeanTypeProxy)this.getTypeProxy()).getComponentType();
        if (!compType.isPrimitive()) {
            return ((IREMMethodProxy)REMStandardBeanProxyConstants.getConstants(this.fFactory).getArrayGet()).invokeWithParms(null, parms);
        }
        int id = ((IREMBeanProxy)compType).getID();
        switch (id) {
            case 5: {
                return ((IREMMethodProxy)REMStandardBeanProxyConstants.getConstants(this.fFactory).getArrayGetByte()).invokeWithParms(null, parms);
            }
            case 1: {
                return ((IREMMethodProxy)REMStandardBeanProxyConstants.getConstants(this.fFactory).getArrayGetBoolean()).invokeWithParms(null, parms);
            }
            case 7: {
                return ((IREMMethodProxy)REMStandardBeanProxyConstants.getConstants(this.fFactory).getArrayGetChar()).invokeWithParms(null, parms);
            }
            case 9: {
                return ((IREMMethodProxy)REMStandardBeanProxyConstants.getConstants(this.fFactory).getArrayGetDouble()).invokeWithParms(null, parms);
            }
            case 11: {
                return ((IREMMethodProxy)REMStandardBeanProxyConstants.getConstants(this.fFactory).getArrayGetFloat()).invokeWithParms(null, parms);
            }
            case 3: {
                return ((IREMMethodProxy)REMStandardBeanProxyConstants.getConstants(this.fFactory).getArrayGetInt()).invokeWithParms(null, parms);
            }
            case 15: {
                return ((IREMMethodProxy)REMStandardBeanProxyConstants.getConstants(this.fFactory).getArrayGetLong()).invokeWithParms(null, parms);
            }
            case 13: {
                return ((IREMMethodProxy)REMStandardBeanProxyConstants.getConstants(this.fFactory).getArrayGetShort()).invokeWithParms(null, parms);
            }
        }
        return null;
    }

    public IBeanProxy get(int[] indexes) throws ThrowableProxy {
        Object[] parms = new Object[]{this, indexes};
        int dims = ((IArrayBeanTypeProxy)this.getTypeProxy()).getDimensions();
        if (dims < indexes.length) {
            throw new IllegalArgumentException();
        }
        IBeanTypeProxy finalCompType = ((IArrayBeanTypeProxy)this.getTypeProxy()).getFinalComponentType();
        if (dims == indexes.length && finalCompType.isPrimitive()) {
            int id = ((IREMBeanProxy)finalCompType).getID();
            switch (id) {
                case 5: {
                    return ((IREMMethodProxy)REMStandardBeanProxyConstants.getConstants(this.fFactory).getArrayHelperGetByte()).invokeWithParms(null, parms);
                }
                case 1: {
                    return ((IREMMethodProxy)REMStandardBeanProxyConstants.getConstants(this.fFactory).getArrayHelperGetBoolean()).invokeWithParms(null, parms);
                }
                case 7: {
                    return ((IREMMethodProxy)REMStandardBeanProxyConstants.getConstants(this.fFactory).getArrayHelperGetChar()).invokeWithParms(null, parms);
                }
                case 9: {
                    return ((IREMMethodProxy)REMStandardBeanProxyConstants.getConstants(this.fFactory).getArrayHelperGetDouble()).invokeWithParms(null, parms);
                }
                case 11: {
                    return ((IREMMethodProxy)REMStandardBeanProxyConstants.getConstants(this.fFactory).getArrayHelperGetFloat()).invokeWithParms(null, parms);
                }
                case 3: {
                    return ((IREMMethodProxy)REMStandardBeanProxyConstants.getConstants(this.fFactory).getArrayHelperGetInt()).invokeWithParms(null, parms);
                }
                case 15: {
                    return ((IREMMethodProxy)REMStandardBeanProxyConstants.getConstants(this.fFactory).getArrayHelperGetLong()).invokeWithParms(null, parms);
                }
                case 13: {
                    return ((IREMMethodProxy)REMStandardBeanProxyConstants.getConstants(this.fFactory).getArrayHelperGetShort()).invokeWithParms(null, parms);
                }
            }
        } else {
            return ((IREMMethodProxy)REMStandardBeanProxyConstants.getConstants(this.fFactory).getArrayHelperGet()).invokeWithParms(null, parms);
        }
        return null;
    }

    public void set(IBeanProxy value, int index) throws ThrowableProxy {
        Object[] parms = new Object[]{this, new Integer(index), value};
        ((IREMMethodProxy)REMStandardBeanProxyConstants.getConstants(this.fFactory).getArraySet()).invokeWithParms(null, parms);
    }

    public void set(IBeanProxy value, int[] indexes) throws ThrowableProxy {
        Object[] parms = new Object[]{this, indexes, value};
        ((IREMMethodProxy)REMStandardBeanProxyConstants.getConstants(this.fFactory).getArrayHelperSet()).invokeWithParms(null, parms);
    }

    public int getLength() {
        if (this.fLength == -1) {
            this.fLength = ((IIntegerBeanProxy)REMStandardBeanProxyConstants.getConstants(this.fFactory).getArrayGetLength().invokeCatchThrowableExceptions(null, (IBeanProxy)this)).intValue();
        }
        return this.fLength;
    }

    public IBeanProxy getCatchThrowableException(int index) {
        try {
            return this.get(index);
        }
        catch (ThrowableProxy e) {
            ProxyPlugin.getPlugin().getLogger().log((Object)new Status(2, ProxyPlugin.getPlugin().getBundle().getSymbolicName(), 0, "", (Throwable)e));
            this.fFactory.releaseProxy((IBeanProxy)e);
            return null;
        }
    }
}

