/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jem.internal.beaninfo.impl;

import java.util.Collection;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.EAnnotationImpl;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EcoreEMap;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.jem.internal.beaninfo.BeaninfoFactory;
import org.eclipse.jem.internal.beaninfo.BeaninfoPackage;
import org.eclipse.jem.internal.beaninfo.FeatureAttributeValue;
import org.eclipse.jem.internal.beaninfo.FeatureDecorator;
import org.eclipse.jem.internal.beaninfo.adapters.BeaninfoProxyConstants;
import org.eclipse.jem.internal.proxy.core.EnumerationBeanProxyWrapper;
import org.eclipse.jem.internal.proxy.core.IBeanProxy;
import org.eclipse.jem.internal.proxy.core.IBooleanBeanProxy;
import org.eclipse.jem.internal.proxy.core.IMethodProxy;
import org.eclipse.jem.internal.proxy.core.IStringBeanProxy;
import org.eclipse.jem.internal.proxy.core.ThrowableProxy;

public class FeatureDecoratorImpl
extends EAnnotationImpl
implements FeatureDecorator {
    protected static final String DISPLAY_NAME_EDEFAULT = null;
    protected IBeanProxy fFeatureProxy;
    protected FeatureDecorator fFeatureDecoratorProxy;
    private int fIsImplicit = 0;
    private String fProxyDisplayName = null;
    protected boolean isDesignTimeProxy = false;
    protected boolean setIsDesignTimeProxy;
    protected boolean isPreferredProxy = false;
    protected boolean setIsPreferredProxy;
    protected String categoryProxy;
    protected boolean setCategoryProxy;
    protected String shortDescriptionProxy;
    protected boolean setShortDescriptionProxy;
    protected String displayName = DISPLAY_NAME_EDEFAULT;
    protected boolean displayNameESet = false;
    protected static final String SHORT_DESCRIPTION_EDEFAULT = null;
    protected String shortDescription = SHORT_DESCRIPTION_EDEFAULT;
    protected boolean shortDescriptionESet = false;
    protected static final String CATEGORY_EDEFAULT = null;
    protected String category = CATEGORY_EDEFAULT;
    protected static final boolean EXPERT_EDEFAULT = false;
    protected boolean expert = false;
    protected boolean expertESet = false;
    protected static final boolean HIDDEN_EDEFAULT = false;
    protected boolean hidden = false;
    protected boolean hiddenESet = false;
    protected static final boolean PREFERRED_EDEFAULT = false;
    protected boolean preferred = false;
    protected boolean preferredESet = false;
    protected static final boolean MERGE_INTROSPECTION_EDEFAULT = true;
    protected boolean mergeIntrospection = true;
    protected static final boolean ATTRIBUTES_EXPLICIT_EDEFAULT = false;
    protected boolean attributesExplicit = false;
    protected EMap attributes = null;
    protected boolean retrievedAttributes;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    protected FeatureDecoratorImpl() {
        this.setSource(this.getClass().getName());
    }

    protected EClass eStaticClass() {
        return BeaninfoPackage.eINSTANCE.getFeatureDecorator();
    }

    protected boolean validProxy(IBeanProxy proxy) {
        return proxy != null ? proxy.isValid() : false;
    }

    public EMap getAttributes() {
        if (!this.isAttributesExplicit() && this.validProxy(this.fFeatureProxy) && !this.retrievedAttributes) {
            this.retrievedAttributes = true;
            EMap attribs = this.getAttributesGen();
            IMethodProxy getValue = BeaninfoProxyConstants.getConstants(this.fFeatureProxy.getProxyFactoryRegistry()).getValueProxy();
            try {
                EnumerationBeanProxyWrapper attrNames = new EnumerationBeanProxyWrapper(BeaninfoProxyConstants.getConstants(this.fFeatureProxy.getProxyFactoryRegistry()).getAttributeNamesProxy().invoke(this.fFeatureProxy));
                while (attrNames.hasMoreElements()) {
                    try {
                        IBooleanBeanProxy v;
                        IStringBeanProxy attrName = (IStringBeanProxy)attrNames.nextElement();
                        IBeanProxy attrValue = getValue.invoke(this.fFeatureProxy, (IBeanProxy)attrName);
                        if ("ivjDesignTimeProperty".equals(attrName.stringValue())) {
                            if (attrValue instanceof IBooleanBeanProxy) {
                                v = (IBooleanBeanProxy)attrValue;
                                this.isDesignTimeProxy = v.booleanValue();
                            } else {
                                this.isDesignTimeProxy = false;
                            }
                            this.setIsDesignTimeProxy = true;
                            continue;
                        }
                        if ("category".equals(attrName.stringValue())) {
                            this.categoryProxy = attrValue instanceof IStringBeanProxy ? ((IStringBeanProxy)attrValue).stringValue() : null;
                            this.setCategoryProxy = true;
                            continue;
                        }
                        if ("preferred".equals(attrName.stringValue())) {
                            if (!(attrValue instanceof IBooleanBeanProxy)) continue;
                            v = (IBooleanBeanProxy)attrValue;
                            this.isPreferredProxy = v.booleanValue();
                            this.setIsPreferredProxy = true;
                            continue;
                        }
                        String key = attrName.stringValue();
                        FeatureAttributeValue fv = (FeatureAttributeValue)attribs.get((Object)key);
                        if (fv == null) {
                            fv = BeaninfoFactory.eINSTANCE.createFeatureAttributeValue();
                        } else if (!fv.isSetValueProxy()) continue;
                        fv.setValueProxy(attrValue);
                        attribs.put((Object)key, (Object)fv);
                    }
                    catch (ThrowableProxy throwableProxy) {}
                }
            }
            catch (ThrowableProxy throwableProxy) {}
        }
        return this.getAttributesGen();
    }

    public int isImplicitlyCreated() {
        return this.fIsImplicit;
    }

    public void setImplicitlyCreated(int implicit) {
        this.fIsImplicit = implicit;
    }

    public boolean isIntrospected() {
        return this.fFeatureProxy != null;
    }

    public IBeanProxy getDescriptorProxy() {
        return this.fFeatureProxy;
    }

    public void setDescriptorProxy(IBeanProxy descriptor) {
        this.fFeatureProxy = descriptor;
        this.fProxyDisplayName = null;
        if (this.retrievedAttributes) {
            this.attributes.clear();
            this.retrievedAttributes = false;
        }
        this.isDesignTimeProxy = false;
        this.setIsDesignTimeProxy = false;
        this.setCategoryProxy = false;
        this.categoryProxy = null;
        this.setShortDescriptionProxy = false;
        this.shortDescriptionProxy = null;
        this.isPreferredProxy = false;
        this.setIsPreferredProxy = false;
        if (this.validProxy(this.fFeatureProxy) && !this.isSetDisplayName()) {
            try {
                this.fProxyDisplayName = ((IStringBeanProxy)BeaninfoProxyConstants.getConstants(this.fFeatureProxy.getProxyFactoryRegistry()).getDisplayNameProxy().invoke(this.fFeatureProxy)).stringValue();
            }
            catch (NullPointerException nullPointerException) {
            }
            catch (ThrowableProxy throwableProxy) {}
        }
    }

    public void setDecoratorProxy(FeatureDecorator decorator) {
        this.fFeatureDecoratorProxy = decorator;
    }

    public String getName() {
        ENamedElement ne = (ENamedElement)this.getEModelElement();
        if (ne != null) {
            return ne.getName();
        }
        return "?";
    }

    public String getDisplayName() {
        if (!this.isSetDisplayName()) {
            if (this.fProxyDisplayName != null) {
                return this.fProxyDisplayName;
            }
            return this.getName();
        }
        return this.getDisplayNameGen();
    }

    public String getShortDescription() {
        if (!this.isSetShortDescription()) {
            if (!this.setShortDescriptionProxy) {
                this.setShortDescriptionProxy = true;
                if (this.validProxy(this.fFeatureProxy)) {
                    try {
                        IStringBeanProxy str = (IStringBeanProxy)BeaninfoProxyConstants.getConstants(this.fFeatureProxy.getProxyFactoryRegistry()).getShortDescriptionProxy().invoke(this.fFeatureProxy);
                        if (str != null) {
                            this.shortDescriptionProxy = str.stringValue();
                        }
                    }
                    catch (ThrowableProxy throwableProxy) {}
                }
            }
            return this.shortDescriptionProxy != null ? this.shortDescriptionProxy : this.getDisplayName();
        }
        return this.getShortDescriptionGen();
    }

    public void setDisplayName(String newDisplayName) {
        String oldDisplayName = this.displayName;
        this.displayName = newDisplayName;
        boolean oldDisplayNameESet = this.displayNameESet;
        this.displayNameESet = true;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 6, (Object)oldDisplayName, (Object)this.displayName, !oldDisplayNameESet));
        }
    }

    public void unsetDisplayName() {
        String oldDisplayName = this.displayName;
        boolean oldDisplayNameESet = this.displayNameESet;
        this.displayName = DISPLAY_NAME_EDEFAULT;
        this.displayNameESet = false;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 2, 6, (Object)oldDisplayName, (Object)DISPLAY_NAME_EDEFAULT, oldDisplayNameESet));
        }
    }

    public boolean isSetDisplayName() {
        return this.displayNameESet;
    }

    public void setShortDescription(String newShortDescription) {
        String oldShortDescription = this.shortDescription;
        this.shortDescription = newShortDescription;
        boolean oldShortDescriptionESet = this.shortDescriptionESet;
        this.shortDescriptionESet = true;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 7, (Object)oldShortDescription, (Object)this.shortDescription, !oldShortDescriptionESet));
        }
    }

    public void unsetShortDescription() {
        String oldShortDescription = this.shortDescription;
        boolean oldShortDescriptionESet = this.shortDescriptionESet;
        this.shortDescription = SHORT_DESCRIPTION_EDEFAULT;
        this.shortDescriptionESet = false;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 2, 7, (Object)oldShortDescription, (Object)SHORT_DESCRIPTION_EDEFAULT, oldShortDescriptionESet));
        }
    }

    public boolean isSetShortDescription() {
        return this.shortDescriptionESet;
    }

    public String getCategory() {
        if (this.category != CATEGORY_EDEFAULT) {
            return this.getCategoryGen();
        }
        this.getAttributes();
        return this.setCategoryProxy ? this.categoryProxy : CATEGORY_EDEFAULT;
    }

    public String getCategoryGen() {
        return this.category;
    }

    public void setCategory(String newCategory) {
        String oldCategory = this.category;
        this.category = newCategory;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 8, (Object)oldCategory, (Object)this.category));
        }
    }

    public boolean isExpert() {
        if (this.validProxy(this.fFeatureProxy) && !this.isSetExpert()) {
            try {
                return ((IBooleanBeanProxy)BeaninfoProxyConstants.getConstants(this.fFeatureProxy.getProxyFactoryRegistry()).getIsExpertProxy().invoke(this.fFeatureProxy)).booleanValue();
            }
            catch (ThrowableProxy throwableProxy) {}
        }
        return this.isExpertGen();
    }

    public boolean isExpertGen() {
        return this.expert;
    }

    public void setExpert(boolean newExpert) {
        boolean oldExpert = this.expert;
        this.expert = newExpert;
        boolean oldExpertESet = this.expertESet;
        this.expertESet = true;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 9, oldExpert, this.expert, !oldExpertESet));
        }
    }

    public void unsetExpert() {
        boolean oldExpert = this.expert;
        boolean oldExpertESet = this.expertESet;
        this.expert = false;
        this.expertESet = false;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 2, 9, oldExpert, false, oldExpertESet));
        }
    }

    public boolean isSetExpert() {
        return this.expertESet;
    }

    public boolean isHidden() {
        if (this.validProxy(this.fFeatureProxy) && !this.isSetHidden()) {
            try {
                return ((IBooleanBeanProxy)BeaninfoProxyConstants.getConstants(this.fFeatureProxy.getProxyFactoryRegistry()).getIsHiddenProxy().invoke(this.fFeatureProxy)).booleanValue();
            }
            catch (ThrowableProxy throwableProxy) {}
        }
        return this.isHiddenGen();
    }

    public boolean isHiddenGen() {
        return this.hidden;
    }

    public void setHidden(boolean newHidden) {
        boolean oldHidden = this.hidden;
        this.hidden = newHidden;
        boolean oldHiddenESet = this.hiddenESet;
        this.hiddenESet = true;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 10, oldHidden, this.hidden, !oldHiddenESet));
        }
    }

    public void unsetHidden() {
        boolean oldHidden = this.hidden;
        boolean oldHiddenESet = this.hiddenESet;
        this.hidden = false;
        this.hiddenESet = false;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 2, 10, oldHidden, false, oldHiddenESet));
        }
    }

    public boolean isSetHidden() {
        return this.hiddenESet;
    }

    public boolean isPreferred() {
        this.getAttributes();
        if (this.setIsPreferredProxy) {
            return this.isPreferredProxy;
        }
        if (this.validProxy(this.fFeatureProxy) && !this.isSetPreferred()) {
            try {
                return ((IBooleanBeanProxy)BeaninfoProxyConstants.getConstants(this.fFeatureProxy.getProxyFactoryRegistry()).getIsPreferredProxy().invoke(this.fFeatureProxy)).booleanValue();
            }
            catch (ThrowableProxy throwableProxy) {}
        }
        return this.isPreferredGen();
    }

    public boolean isPreferredGen() {
        return this.preferred;
    }

    public void setPreferred(boolean newPreferred) {
        boolean oldPreferred = this.preferred;
        this.preferred = newPreferred;
        boolean oldPreferredESet = this.preferredESet;
        this.preferredESet = true;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 11, oldPreferred, this.preferred, !oldPreferredESet));
        }
    }

    public void unsetPreferred() {
        boolean oldPreferred = this.preferred;
        boolean oldPreferredESet = this.preferredESet;
        this.preferred = false;
        this.preferredESet = false;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 2, 11, oldPreferred, false, oldPreferredESet));
        }
    }

    public boolean isSetPreferred() {
        return this.preferredESet;
    }

    public boolean isMergeIntrospection() {
        return this.mergeIntrospection;
    }

    public void setMergeIntrospection(boolean newMergeIntrospection) {
        boolean oldMergeIntrospection = this.mergeIntrospection;
        this.mergeIntrospection = newMergeIntrospection;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 12, oldMergeIntrospection, this.mergeIntrospection));
        }
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (displayName: ");
        if (this.displayNameESet) {
            result.append(this.displayName);
        } else {
            result.append("<unset>");
        }
        result.append(", shortDescription: ");
        if (this.shortDescriptionESet) {
            result.append(this.shortDescription);
        } else {
            result.append("<unset>");
        }
        result.append(", category: ");
        result.append(this.category);
        result.append(", expert: ");
        if (this.expertESet) {
            result.append(this.expert);
        } else {
            result.append("<unset>");
        }
        result.append(", hidden: ");
        if (this.hiddenESet) {
            result.append(this.hidden);
        } else {
            result.append("<unset>");
        }
        result.append(", preferred: ");
        if (this.preferredESet) {
            result.append(this.preferred);
        } else {
            result.append("<unset>");
        }
        result.append(", mergeIntrospection: ");
        result.append(this.mergeIntrospection);
        result.append(", attributesExplicit: ");
        result.append(this.attributesExplicit);
        result.append(')');
        return result.toString();
    }

    public String getDisplayNameGen() {
        return this.displayName;
    }

    public String getShortDescriptionGen() {
        return this.shortDescription;
    }

    public EMap getAttributesGen() {
        if (this.attributes == null) {
            EClass eClass = BeaninfoPackage.eINSTANCE.getFeatureAttributeMapEntry();
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.jem.internal.beaninfo.impl.FeatureAttributeMapEntryImpl");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.attributes = new EcoreEMap(eClass, (Class)clazz, (InternalEObject)this, 14);
        }
        return this.attributes;
    }

    public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
        if (featureID >= 0) {
            switch (this.eDerivedStructuralFeatureID(featureID, baseClass)) {
                case 0: {
                    return ((InternalEList)this.getEAnnotations()).basicAdd((Object)otherEnd, msgs);
                }
                case 3: {
                    if (this.eContainer != null) {
                        msgs = this.eBasicRemoveFromContainer(msgs);
                    }
                    return this.eBasicSetContainer(otherEnd, 3, msgs);
                }
            }
            return this.eDynamicInverseAdd(otherEnd, featureID, baseClass, msgs);
        }
        if (this.eContainer != null) {
            msgs = this.eBasicRemoveFromContainer(msgs);
        }
        return this.eBasicSetContainer(otherEnd, featureID, msgs);
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
        if (featureID >= 0) {
            switch (this.eDerivedStructuralFeatureID(featureID, baseClass)) {
                case 0: {
                    return ((InternalEList)this.getEAnnotations()).basicRemove((Object)otherEnd, msgs);
                }
                case 2: {
                    return ((InternalEList)this.getDetails()).basicRemove((Object)otherEnd, msgs);
                }
                case 3: {
                    return this.eBasicSetContainer(null, 3, msgs);
                }
                case 4: {
                    return ((InternalEList)this.getContents()).basicRemove((Object)otherEnd, msgs);
                }
                case 14: {
                    return ((InternalEList)this.getAttributes()).basicRemove((Object)otherEnd, msgs);
                }
            }
            return this.eDynamicInverseRemove(otherEnd, featureID, baseClass, msgs);
        }
        return this.eBasicSetContainer(null, featureID, msgs);
    }

    public NotificationChain eBasicRemoveFromContainer(NotificationChain msgs) {
        block6: {
            if (this.eContainerFeatureID < 0) break block6;
            switch (this.eContainerFeatureID) {
                case 3: {
                    Class<?> clazz = class$1;
                    if (clazz == null) {
                        try {
                            clazz = class$1 = Class.forName("org.eclipse.emf.ecore.EModelElement");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    return this.eContainer.eInverseRemove((InternalEObject)this, 0, (Class)clazz, msgs);
                }
            }
            return this.eDynamicBasicRemoveFromContainer(msgs);
        }
        return this.eContainer.eInverseRemove((InternalEObject)this, -1 - this.eContainerFeatureID, null, msgs);
    }

    public Object eGet(EStructuralFeature eFeature, boolean resolve) {
        switch (this.eDerivedStructuralFeatureID(eFeature)) {
            case 0: {
                return this.getEAnnotations();
            }
            case 1: {
                return this.getSource();
            }
            case 2: {
                return this.getDetails();
            }
            case 3: {
                return this.getEModelElement();
            }
            case 4: {
                return this.getContents();
            }
            case 5: {
                return this.getReferences();
            }
            case 6: {
                return this.getDisplayName();
            }
            case 7: {
                return this.getShortDescription();
            }
            case 8: {
                return this.getCategory();
            }
            case 9: {
                return this.isExpert() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 10: {
                return this.isHidden() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 11: {
                return this.isPreferred() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 12: {
                return this.isMergeIntrospection() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 13: {
                return this.isAttributesExplicit() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 14: {
                return this.getAttributes();
            }
        }
        return this.eDynamicGet(eFeature, resolve);
    }

    public void eSet(EStructuralFeature eFeature, Object newValue) {
        switch (this.eDerivedStructuralFeatureID(eFeature)) {
            case 0: {
                this.getEAnnotations().clear();
                this.getEAnnotations().addAll((Collection)newValue);
                return;
            }
            case 1: {
                this.setSource((String)newValue);
                return;
            }
            case 2: {
                this.getDetails().clear();
                this.getDetails().addAll((Collection)newValue);
                return;
            }
            case 3: {
                this.setEModelElement((EModelElement)newValue);
                return;
            }
            case 4: {
                this.getContents().clear();
                this.getContents().addAll((Collection)newValue);
                return;
            }
            case 5: {
                this.getReferences().clear();
                this.getReferences().addAll((Collection)newValue);
                return;
            }
            case 6: {
                this.setDisplayName((String)newValue);
                return;
            }
            case 7: {
                this.setShortDescription((String)newValue);
                return;
            }
            case 8: {
                this.setCategory((String)newValue);
                return;
            }
            case 9: {
                this.setExpert((Boolean)newValue);
                return;
            }
            case 10: {
                this.setHidden((Boolean)newValue);
                return;
            }
            case 11: {
                this.setPreferred((Boolean)newValue);
                return;
            }
            case 12: {
                this.setMergeIntrospection((Boolean)newValue);
                return;
            }
            case 13: {
                this.setAttributesExplicit((Boolean)newValue);
                return;
            }
            case 14: {
                this.getAttributes().clear();
                this.getAttributes().addAll((Collection)newValue);
                return;
            }
        }
        this.eDynamicSet(eFeature, newValue);
    }

    public void eUnset(EStructuralFeature eFeature) {
        switch (this.eDerivedStructuralFeatureID(eFeature)) {
            case 0: {
                this.getEAnnotations().clear();
                return;
            }
            case 1: {
                this.setSource(EAnnotationImpl.SOURCE_EDEFAULT);
                return;
            }
            case 2: {
                this.getDetails().clear();
                return;
            }
            case 3: {
                this.setEModelElement(null);
                return;
            }
            case 4: {
                this.getContents().clear();
                return;
            }
            case 5: {
                this.getReferences().clear();
                return;
            }
            case 6: {
                this.unsetDisplayName();
                return;
            }
            case 7: {
                this.unsetShortDescription();
                return;
            }
            case 8: {
                this.setCategory(CATEGORY_EDEFAULT);
                return;
            }
            case 9: {
                this.unsetExpert();
                return;
            }
            case 10: {
                this.unsetHidden();
                return;
            }
            case 11: {
                this.unsetPreferred();
                return;
            }
            case 12: {
                this.setMergeIntrospection(true);
                return;
            }
            case 13: {
                this.setAttributesExplicit(false);
                return;
            }
            case 14: {
                this.getAttributes().clear();
                return;
            }
        }
        this.eDynamicUnset(eFeature);
    }

    public boolean eIsSet(EStructuralFeature eFeature) {
        switch (this.eDerivedStructuralFeatureID(eFeature)) {
            case 0: {
                return this.eAnnotations != null && !this.eAnnotations.isEmpty();
            }
            case 1: {
                return EAnnotationImpl.SOURCE_EDEFAULT == null ? this.source != null : !EAnnotationImpl.SOURCE_EDEFAULT.equals(this.source);
            }
            case 2: {
                return this.details != null && !this.details.isEmpty();
            }
            case 3: {
                return this.getEModelElement() != null;
            }
            case 4: {
                return this.contents != null && !this.contents.isEmpty();
            }
            case 5: {
                return this.references != null && !this.references.isEmpty();
            }
            case 6: {
                return this.isSetDisplayName();
            }
            case 7: {
                return this.isSetShortDescription();
            }
            case 8: {
                return CATEGORY_EDEFAULT == null ? this.category != null : !CATEGORY_EDEFAULT.equals(this.category);
            }
            case 9: {
                return this.isSetExpert();
            }
            case 10: {
                return this.isSetHidden();
            }
            case 11: {
                return this.isSetPreferred();
            }
            case 12: {
                return !this.mergeIntrospection;
            }
            case 13: {
                return this.attributesExplicit;
            }
            case 14: {
                return this.attributes != null && !this.attributes.isEmpty();
            }
        }
        return this.eDynamicIsSet(eFeature);
    }

    public boolean isAttributesExplicit() {
        return this.attributesExplicit;
    }

    public void setAttributesExplicit(boolean newAttributesExplicit) {
        boolean oldAttributesExplicit = this.attributesExplicit;
        this.attributesExplicit = newAttributesExplicit;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 13, oldAttributesExplicit, this.attributesExplicit));
        }
    }

    public boolean needIntrospection() {
        return this.fFeatureProxy != null && !this.validProxy(this.fFeatureProxy);
    }
}

