/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wtp.common.util;

import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TimerTests {
    public static TimerTests basicTest = new TimerTests();
    public static final String CURRENT_PARENT_ID = "current parent";
    protected boolean testOn = false;
    protected List steps;
    protected Map stepMap;
    protected TimerStep currentParent;
    private static final long PRINT_ALL = -1L;
    protected static NumberFormat nf;

    public synchronized boolean startStep(String id, String parentId) {
        if (!this.testOn) {
            return true;
        }
        if (this.stepMap.containsKey(id)) {
            new IllegalStateException("Starting same step \"" + id + "\" while previous is not completed.").printStackTrace();
            return false;
        }
        TimerStep step = this.createTimerStep(id, parentId, false);
        return step != null;
    }

    protected TimerStep createTimerStep(String id, String parentId, boolean cumulative) {
        TimerStep parentStep = null;
        if (parentId == CURRENT_PARENT_ID) {
            parentStep = this.currentParent;
        } else if (parentId != null && (parentStep = (TimerStep)this.stepMap.get(parentId)) == null) {
            new IllegalStateException("Starting step \"" + id + "\" but parent step \"" + parentId + "\" didn't exist or wasn't active.").printStackTrace();
            return null;
        }
        TimerStep newStep = !cumulative ? new TimerStep() : new TimerCumulativeStep();
        this.stepMap.put(id, newStep);
        newStep.id = id;
        newStep.parentStep = parentStep;
        newStep.startTime = System.currentTimeMillis();
        if (parentStep != null) {
            if (parentStep.subSteps == null) {
                parentStep.subSteps = new ArrayList();
            }
            parentStep.subSteps.add(newStep);
        } else {
            this.steps.add(newStep);
        }
        this.currentParent = newStep;
        return newStep;
    }

    public synchronized boolean stopStep(String id) {
        if (!this.testOn) {
            return true;
        }
        TimerStep step = (TimerStep)this.stepMap.remove(id);
        if (step == null) {
            new IllegalStateException("Stopping step \"" + id + "\" but was not started.").printStackTrace();
            return false;
        }
        step.stopTime = System.currentTimeMillis();
        if (step == this.currentParent) {
            this.currentParent = step.parentStep;
        }
        return true;
    }

    public synchronized boolean startCumulativeStep(String id, String parentId) {
        if (!this.testOn) {
            return true;
        }
        if (this.stepMap.containsKey(id)) {
            return true;
        }
        TimerCumulativeStep step = (TimerCumulativeStep)this.createTimerStep(id, parentId, true);
        return step != null;
    }

    public synchronized boolean startCumulativeStep(String id) {
        if (!this.testOn) {
            return true;
        }
        TimerCumulativeStep step = (TimerCumulativeStep)this.stepMap.get(id);
        if (step == null) {
            return false;
        }
        step.startTime = System.currentTimeMillis();
        step.stopTime = 0L;
        return true;
    }

    public synchronized boolean stopCumulativeStep(String id) {
        if (!this.testOn) {
            return true;
        }
        TimerCumulativeStep step = (TimerCumulativeStep)this.stepMap.get(id);
        if (step == null) {
            return false;
        }
        step.stopTime = System.currentTimeMillis();
        step.totalTime += step.stopTime - step.startTime;
        ++step.count;
        return true;
    }

    public synchronized boolean startExcludeCumulativeStep(String id) {
        if (!this.testOn) {
            return true;
        }
        TimerCumulativeStep step = (TimerCumulativeStep)this.stepMap.get(id);
        if (step == null) {
            return false;
        }
        step.stopTime = System.currentTimeMillis();
        step.totalTime += step.stopTime - step.startTime;
        return true;
    }

    public synchronized boolean stopExcludeCumulativeStep(String id) {
        if (!this.testOn) {
            return true;
        }
        TimerCumulativeStep step = (TimerCumulativeStep)this.stepMap.get(id);
        if (step == null) {
            return false;
        }
        step.startTime = System.currentTimeMillis();
        step.stopTime = 0L;
        return true;
    }

    public synchronized void printIt() {
        if (!this.testOn) {
            return;
        }
        System.out.println("*** Timings Start Output:");
        this.printIt(this.steps, null, 3, -1L, null);
        System.out.println("*** Timings Stop Output:");
    }

    public synchronized void printIt(long minTime) {
        if (!this.testOn) {
            return;
        }
        System.out.println("*** Timings Start Output:");
        this.printIt(this.steps, null, 3, minTime, null);
        System.out.println("*** Timings Stop Output:");
    }

    protected long printIt(List steps, TimerStep outerStep, int indent, long cutoff, StringBuffer pending) {
        if (steps == null) {
            return 0L;
        }
        TimerStep prevStep = outerStep;
        long latestEnd = 0L;
        int i = 0;
        while (i < steps.size()) {
            TimerStep step = (TimerStep)steps.get(i);
            StringBuffer strb = new StringBuffer(50);
            int j = 0;
            while (j < indent) {
                strb.append(' ');
                ++j;
            }
            if (!(step instanceof TimerCumulativeStep)) {
                long stepTime = step.stopTime - step.startTime;
                if (stepTime >= cutoff) {
                    strb.append("\"");
                    strb.append(step.id);
                    strb.append("\" ");
                    int headlen = strb.length();
                    strb.append("time is ");
                    strb.append(stepTime);
                    if (prevStep != null && step.startTime != prevStep.stopTime) {
                        long endDelta = step.startTime - prevStep.stopTime;
                        if (endDelta > 0L) {
                            strb.append(" \t\t time since end of \"");
                            strb.append(prevStep.id);
                            strb.append("\" is ");
                            strb.append(endDelta);
                        } else {
                            long startDelta = step.startTime - prevStep.startTime;
                            if (startDelta > 0L) {
                                strb.append(" \t\t time since start of \"");
                                strb.append(prevStep.id);
                                strb.append("\" is ");
                                strb.append(startDelta);
                            }
                        }
                    }
                    if (pending != null) {
                        System.out.println(pending.toString());
                        pending.setLength(0);
                        pending = null;
                    }
                    System.out.println(strb);
                    long latestSubEnd = this.printIt(step.subSteps, step, indent + 3, cutoff, null);
                    if (latestSubEnd != 0L && latestSubEnd < step.stopTime) {
                        strb.setLength(headlen);
                        strb.append("time between last nested step and this end is ");
                        strb.append(step.stopTime - latestSubEnd);
                        System.out.println(strb);
                    }
                    prevStep = step;
                    latestEnd = Math.max(latestEnd, step.stopTime);
                }
            } else {
                TimerCumulativeStep cumStep = (TimerCumulativeStep)step;
                strb.append("\"");
                strb.append(cumStep.id);
                if (cumStep.count > 0 && cumStep.totalTime >= cutoff) {
                    strb.append("\" total time/count: ");
                    strb.append(cumStep.totalTime);
                    strb.append('/');
                    strb.append(cumStep.count);
                    strb.append(" avg: ");
                    double avg = (double)cumStep.totalTime / (double)cumStep.count;
                    if (nf == null) {
                        nf = NumberFormat.getNumberInstance();
                        nf.setMaximumFractionDigits(3);
                    }
                    strb.append(nf.format(avg));
                    if (pending != null) {
                        System.out.println(pending.toString());
                        pending.setLength(0);
                        pending = null;
                    }
                    System.out.println(strb);
                } else if (step.subSteps != null) {
                    if (pending != null) {
                        strb.insert(0, System.getProperties().getProperty("line.separator"));
                        strb.insert(0, pending.toString());
                    }
                    this.printIt(step.subSteps, step, indent + 3, cutoff, strb);
                    if (pending != null && strb.length() == 0) {
                        pending.setLength(0);
                        pending = null;
                    }
                }
            }
            ++i;
        }
        return latestEnd;
    }

    public synchronized void clearTests() {
        if (!this.testOn) {
            return;
        }
        this.stepMap.clear();
        this.steps.clear();
        this.currentParent = null;
    }

    public synchronized void testState(boolean on) {
        if (on == this.testOn) {
            return;
        }
        if (on) {
            this.testOn = true;
            if (this.stepMap == null) {
                this.stepMap = new HashMap();
            }
            if (this.steps == null) {
                this.steps = new ArrayList();
            }
            this.currentParent = null;
        } else {
            this.testOn = false;
            this.stepMap = null;
            this.steps = null;
            this.currentParent = null;
        }
    }

    protected static class TimerStep {
        protected String id;
        protected long startTime;
        protected long stopTime;
        protected List subSteps;
        protected TimerStep parentStep;

        protected TimerStep() {
        }
    }

    protected static class TimerCumulativeStep
    extends TimerStep {
        protected long totalTime;
        protected int count;

        protected TimerCumulativeStep() {
        }
    }
}

