/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wtp.emf.workbench.nature;

import com.ibm.wtp.common.logger.proxy.Logger;
import com.ibm.wtp.emf.workbench.EMFWorkbenchContextBase;
import com.ibm.wtp.emf.workbench.IEMFContextContributor;
import com.ibm.wtp.emf.workbench.ProjectResourceSet;
import com.ibm.wtp.emf.workbench.ProjectUtilities;
import com.ibm.wtp.emf.workbench.WorkbenchResourceHelperBase;
import com.ibm.wtp.emf.workbench.WorkbenchURIConverter;
import com.ibm.wtp.internal.emf.workbench.nature.EMFNatureRegistry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectNature;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;

public abstract class EMFNature
implements IProjectNature,
IEMFContextContributor {
    protected IProject project;
    protected EMFWorkbenchContextBase emfContext;
    protected boolean hasConfigured = false;

    protected static void addNatureToProject(IProject proj, String natureId) throws CoreException {
        ProjectUtilities.addNatureToProject(proj, natureId);
    }

    public void configure() throws CoreException {
        if (!this.hasConfigured) {
            this.hasConfigured = true;
            this.primConfigure();
        }
    }

    protected void primConfigure() throws CoreException {
    }

    protected void createEmfContext() throws CoreException {
        WorkbenchResourceHelperBase.createEMFContext(this.getProject(), this);
    }

    public IFolder createFolder(String aProjectRelativePathString) throws CoreException {
        if (aProjectRelativePathString != null && aProjectRelativePathString.length() > 0) {
            return this.createFolder((IPath)new Path(aProjectRelativePathString));
        }
        return null;
    }

    public IFolder createFolder(IPath aProjectRelativePath) throws CoreException {
        if (aProjectRelativePath != null && !aProjectRelativePath.isEmpty()) {
            IFolder folder = this.getWorkspace().getRoot().getFolder(this.getProjectPath().append(aProjectRelativePath));
            if (!folder.exists()) {
                ProjectUtilities.ensureContainerNotReadOnly((IResource)folder);
                folder.create(true, true, null);
            }
            return folder;
        }
        return null;
    }

    public void deconfigure() throws CoreException {
        this.emfContext = null;
    }

    public boolean fileExists(String aFileName) {
        if (aFileName == null) {
            return false;
        }
        Path path = new Path(aFileName);
        if (path.isAbsolute()) {
            return ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)path).exists();
        }
        return this.getWorkbenchURIConverter().canGetUnderlyingResource(aFileName);
    }

    public ResourceSet getResourceSet() {
        return this.getEmfContextBase().getResourceSet();
    }

    public IContainer getEMFRoot() {
        return this.getProject();
    }

    public boolean hasContext() {
        return this.hasResourceSet();
    }

    public boolean hasResourceSet() {
        return this.emfContext != null && this.emfContext.hasResourceSet();
    }

    protected EMFWorkbenchContextBase getEmfContextBase() {
        if (this.emfContext == null) {
            try {
                this.createEmfContext();
            }
            catch (CoreException ex) {
                Logger.getLogger().logError((Throwable)ex);
            }
        }
        return this.emfContext;
    }

    public IFile getFile(String aFileName) {
        return this.getWorkbenchURIConverter().getFile(aFileName);
    }

    public abstract String getNatureID();

    protected abstract String getPluginID();

    public IProject getProject() {
        return this.project;
    }

    public IPath getProjectPath() {
        return this.getProject().getFullPath();
    }

    protected String getProjectServerValue(String key) {
        if (key == null) {
            return null;
        }
        try {
            QualifiedName wholeName = this.qualifiedKey(key);
            return this.getProject().getPersistentProperty(wholeName);
        }
        catch (CoreException exception) {
            exception.printStackTrace();
            return null;
        }
    }

    protected WorkbenchURIConverter getWorkbenchURIConverter() {
        return (WorkbenchURIConverter)this.getResourceSet().getURIConverter();
    }

    public IWorkspace getWorkspace() {
        return this.getProject().getWorkspace();
    }

    public Resource getXmiResource(String uri) {
        return this.getResource(URI.createURI((String)uri));
    }

    public Resource getResource(URI uri) {
        try {
            return this.getResourceSet().getResource(uri, true);
        }
        catch (WrappedException ex) {
            if (!WorkbenchResourceHelperBase.isResourceNotFound(ex)) {
                throw ex;
            }
            return null;
        }
    }

    public ResourceSet getXmiResourceSet() {
        return this.getResourceSet();
    }

    protected void initializeDependentComponents() {
    }

    public Resource makeXmiResource(String uri) {
        return this.createResource(URI.createURI((String)uri));
    }

    public Resource makeXmiResource(String uri, EList anExtent) {
        Resource res = this.makeXmiResource(uri);
        if (res != null) {
            res.getContents().addAll((Collection)anExtent);
        }
        return res;
    }

    public Resource createResource(URI uri) {
        return this.getResourceSet().createResource(uri);
    }

    private QualifiedName qualifiedKey(String key) {
        return new QualifiedName(this.getPluginID(), key);
    }

    public static void registerNatureID(String natureID) {
        EMFNatureRegistry.singleton().REGISTERED_NATURE_IDS.add(natureID);
    }

    public void setProject(IProject newProject) {
        this.project = newProject;
    }

    protected void setProjectServerValue(String key, String value) {
        if (key != null) {
            try {
                QualifiedName wholeName = this.qualifiedKey(key);
                this.getProject().setPersistentProperty(wholeName, value);
            }
            catch (CoreException exception) {
                exception.printStackTrace();
                return;
            }
        }
    }

    public void shutdown() {
        if (this.getResourceSet() != null) {
            ((ProjectResourceSet)this.getResourceSet()).release();
        }
    }

    public static List getRegisteredRuntimes(IProject project) {
        ArrayList<EMFNature> result = null;
        EMFNature nature = null;
        if (project != null && project.isAccessible()) {
            Iterator it = EMFNatureRegistry.singleton().REGISTERED_NATURE_IDS.iterator();
            while (it.hasNext()) {
                String natureID = (String)it.next();
                try {
                    nature = (EMFNature)project.getNature(natureID);
                }
                catch (CoreException coreException) {}
                if (nature == null) continue;
                if (result == null) {
                    result = new ArrayList<EMFNature>(2);
                }
                result.add(nature);
            }
        }
        return result == null ? Collections.EMPTY_LIST : result;
    }

    public static List getRegisteredRuntimeIDs(IProject project) {
        ArrayList<String> result = null;
        String natureID = null;
        if (project != null && project.isAccessible()) {
            Iterator it = EMFNatureRegistry.singleton().REGISTERED_NATURE_IDS.iterator();
            while (it.hasNext()) {
                natureID = (String)it.next();
                try {
                    if (!project.hasNature(natureID)) continue;
                    if (result == null) {
                        result = new ArrayList<String>(2);
                    }
                    result.add(natureID);
                }
                catch (CoreException coreException) {}
            }
        }
        return result == null ? Collections.EMPTY_LIST : result;
    }

    public static boolean hasRuntime(IProject project, String natureId) {
        if (project == null || !project.isAccessible()) {
            return false;
        }
        try {
            return project.hasNature(natureId);
        }
        catch (CoreException coreException) {
            return false;
        }
    }

    public static boolean hasRuntime(IProject project, String[] possibleNatureIds) {
        if (project != null) {
            int i = 0;
            while (i < possibleNatureIds.length) {
                if (EMFNature.hasRuntime(project, possibleNatureIds[i])) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }
}

