/*******************************************************************************
 * Copyright (c) 2003, 2004 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.jem.internal.instantiation.base;
/*
 *  $RCSfile: JavaInstantiationHandlerFactoryAdapter.java,v $
 *  $Revision: 1.3 $  $Date: 2004/08/27 15:33:17 $ 
 */

import org.eclipse.emf.common.notify.impl.AdapterImpl;

import org.eclipse.jem.java.impl.JavaFactoryImpl;
import org.eclipse.jem.internal.java.instantiation.IInstantiationHandler;
import org.eclipse.jem.internal.java.instantiation.IInstantiationHandlerFactoryAdapter;

/**
 * This adapter is attached to the resource set for a java model. The
 * JavaXMIFactory will ask for this adapter and ask it for the IInstantiationHandler.
 */
public class JavaInstantiationHandlerFactoryAdapter extends AdapterImpl implements IInstantiationHandlerFactoryAdapter {

	/**
	 * Constructor for JavaInstantiationHandlerFactoryAdapter.
	 */
	public JavaInstantiationHandlerFactoryAdapter() {
		super();
	}

	/**
	 * @see org.eclipse.jem.internal.instantiation.IInstantiationHandlerFactoryAdapter#getInstantiationHandler(JavaFactoryImpl)
	 */
	public IInstantiationHandler getInstantiationHandler(JavaFactoryImpl factory) {
		return JavaFactoryHandler.INSTANCE;
	}

	/**
	 * @see org.eclipse.emf.common.notify.Adapter#isAdapterForType(Object)
	 */
	public boolean isAdapterForType(Object type) {
		return IInstantiationHandlerFactoryAdapter.ADAPTER_KEY == type;
	}

}
