package com.ibm.wtp.emf.workbench;

import org.eclipse.core.resources.IProject;
import org.eclipse.emf.ecore.resource.ResourceSet;

/*
 * Licensed Material - Property of IBM 
 * (C) Copyright IBM Corp. 2001, 2002 - All Rights Reserved. 
 * US Government Users Restricted Rights - Use, duplication or disclosure 
 * restricted by GSA ADP Schedule Contract with IBM Corp. 
 */


public interface ProjectResourceSet extends ResourceSet {
	IProject getProject();

	/**
	 * Call when the ResourceSet is no longer to be used.
	 */
	void release() ;
		
	/**
	 * Add the <code>resourceHandler</code> to the end of the list
	 * of resourceHandlers.
	 * @param resourceHandler IResourceHandler
	 * @return boolean Return true if it was added.
	 */
	boolean add(ResourceHandler resourceHandler) ;
	
	/**
	 * Add the <code>resourceHandler</code> to the front of the list
	 * of resourceHandlers.
	 * @param resourceHandler IResourceHandler
	 */
	void addFirst(ResourceHandler resourceHandler) ;
	
	/**
	 * Remove the <code>resourceHandler</code> from the list
	 * of resourceHandlers.
	 * @param resourceHandler IResourceHandler
	 * @return boolean Return true if it was removed. 
	 */
	boolean remove(ResourceHandler resourceHandler) ;
	
	/**
	 * Return the ResourceSet synchronizer that will synchronize
	 * the ResourceSet with changes from the Workbench.
	 * @return ResourceSetWorkbenchSynchronizer
	 */
	ResourceSetWorkbenchSynchronizer getSynchronizer();
	
	/**
	 * Set the ResourceSet synchronizer that will synchronize
	 * the ResourceSet with changes from the Workbench.
	 * @return ResourceSetWorkbenchSynchronizer
	 */
	void setSynchronizer(ResourceSetWorkbenchSynchronizer aSynchronizer);
	
	/**
	 * This should be called by clients whenever the structure
	 * of the project changes such that any cached URIs will be invalid.
	 * For example, if the source folders within the URIConverter change.
	 *
	 */
	void resetNormalizedURICache() ;
}
