package com.ibm.wtp.common.logger;

/*
 * Licensed Material - Property of IBM
 * (C) Copyright IBM Corp. 2001 - All Rights Reserved.
 * US Government Users Restricted Rights - Use, duplication or disclosure
 * restricted by GSA ADP Schedule Contract with IBM Corp.
 */
import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;

/**
 * This class should be used when logging information which
 * should be grouped together. Instead of creating a new instance
 * of this class every time it is needed, for performance reasons,
 * create an instance and reuse it.
 */
public class LogEntry {
	private int _executionMap = 0;
	private Throwable _caughtException = null;
	private String _propertiesFileName = null;
	private String localeOfOrigin = null;
    private String sourceIdentifier;
    private String elapsedTime;
    private String text;
    private String messageTypeIdentifier;
	/**
	 * The file name parameter must be a name which can be used
	 * by ResourceBundle to load the string from the .properties
	 * file. The parameter must not be null or the empty string.
	 */
	public LogEntry(String propertiesFileName) {
		setPropertiesFileName(propertiesFileName);
	}
	
	/**
	 * Default Constructor
	 */
	public LogEntry() {
	}
	public int getExecutionMap() {
		return _executionMap;
	}
	public String getPropertiesFileName() {
		return _propertiesFileName;
	}
	public Throwable getTargetException() {
		return _caughtException;
	}
	public String getLocaleOfOrigin() {
		return localeOfOrigin;
	}
	public String getSourceidentifier() {
		return sourceIdentifier;
	}
	public String getElapsedTime() {
		return elapsedTime;
	}
	public String getMessageTypeIdentifier() {
		return messageTypeIdentifier;
	}
	public void setExecutionMap(int map) {
		_executionMap = map;
	}
	public void setPropertiesFileName(String fName) {
		_propertiesFileName = fName;
	}
	public void setTargetException(Throwable exc) {
		_caughtException = exc;
	}

	public void appendStackTrace() {
		// Grab the stack trace from the Thread ... 
		ByteArrayOutputStream byteOutput = new ByteArrayOutputStream();
		PrintWriter printWriter = new PrintWriter(byteOutput);
		// Can't call Thread.dumpStack() because it doesn't take a writer as input.
		// Copy its mechanism instead.
		new Exception("Stack trace").printStackTrace(printWriter); //$NON-NLS-1$
		printWriter.flush();
		
		// and update the text to the LogEntry's text.
		StringBuffer buffer = new StringBuffer();
		buffer.append(getText());
		buffer.append("\n"); //$NON-NLS-1$
		buffer.append(byteOutput.toString());
		setText(buffer.toString());
	}
	

	/**
     * @return
     */
    public String getText() {
        return text;
    }
    /**
     * @param string
     */
	public void setText(String string) {
        text = string;
    }
    /**
	 * Set every entry, other than the propertiesFileName, to its default value.
	 */
	public void reset() {
		setExecutionMap(0);
		setTargetException(null);
		localeOfOrigin = null;
		sourceIdentifier = null;
		elapsedTime = null;
		setText(null);
	}
	
	public void setLocaleOfOrigin(String origin) {
		localeOfOrigin = origin;
	}
	
	public void setSourceID(String id) {
		sourceIdentifier = id;
	}

	public void setElapsedTime(long time) {
		elapsedTime = String.valueOf(time);
	}
    /**
     * @param string
     */
    public void setSourceIdentifier(String string) {
        setSourceID(string);
    }
    /**
     * @param string
     */
    public void setMessageTypeIdentifier(String string) {
        messageTypeIdentifier = string;
    }
    
    public void setMessageTypeID(String string) {
    	setMessageTypeIdentifier(string);
    }
    /**
     * @param strings
     */
    public void setTokens(String[] strings) {
        //TODO handle tokens
    }
    
    /* (non-Javadoc)
	 * @see java.lang.Object#toString()
	 */
	public String toString() {
		StringBuffer b = new StringBuffer();
		if (text != null)
			b.append(text);
		if (_caughtException != null)
			b.append(_caughtException.toString());
		return b.toString();
	}
	
	
}
