/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jem.internal.proxy.common.remote;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.eclipse.jem.internal.proxy.common.CommandException;
import org.eclipse.jem.internal.proxy.common.remote.Commands;
import org.eclipse.jem.internal.proxy.common.remote.UnexpectedExceptionCommandException;

public class ExpressionCommands {
    public static final byte START_EXPRESSION_TREE_PROCESSING = 0;
    public static final byte PUSH_EXPRESSION = 1;
    public static final byte END_EXPRESSION_TREE_PROCESSING = 2;
    public static final byte SYNC_REQUEST = 3;
    public static final byte PULL_VALUE_REQUEST = 4;
    public static final int ExpressionNoExpressionValueException = 9;

    public static void sendStartExpressionProcessingCommand(int expressionID, DataOutputStream os) throws IOException {
        os.writeByte(19);
        os.writeInt(expressionID);
        os.writeByte(0);
    }

    public static void sendEndExpressionProcessingCommand(int expressionID, DataOutputStream os) throws IOException {
        os.writeByte(19);
        os.writeInt(expressionID);
        os.writeByte(2);
        os.flush();
    }

    public static void sendExpressionCommand(int expressionID, DataOutputStream os, byte subcommand) throws IOException {
        os.writeByte(19);
        os.writeInt(expressionID);
        os.writeByte(1);
        os.writeByte(subcommand);
    }

    public static void sendByte(DataOutputStream os, byte aByte) throws IOException {
        os.writeByte(aByte);
    }

    public static void sendInt(DataOutputStream os, int anInt) throws IOException {
        os.writeInt(anInt);
    }

    public static void sendString(DataOutputStream os, String aString) throws IOException {
        os.writeUTF(aString);
    }

    public static void sendBoolean(DataOutputStream os, boolean aBool) throws IOException {
        os.writeBoolean(aBool);
    }

    public static void sendPullValueCommand(int expressionID, DataOutputStream os, DataInputStream is, Commands.ValueObject valueReturn) throws CommandException {
        try {
            os.writeByte(19);
            os.writeInt(expressionID);
            os.writeByte(4);
            os.flush();
            Commands.readBackValue(is, valueReturn, (byte)-1);
        }
        catch (CommandException e) {
            throw e;
        }
        catch (Exception e) {
            throw new UnexpectedExceptionCommandException(false, e);
        }
    }

    public static void sendSyncCommand(int expressionID, DataOutputStream os, DataInputStream is, Commands.ValueObject returnValue) throws CommandException {
        try {
            os.writeByte(19);
            os.writeInt(expressionID);
            os.writeByte(3);
            os.flush();
            Commands.readBackValue(is, returnValue, (byte)-1);
        }
        catch (CommandException e) {
            throw e;
        }
        catch (Exception e) {
            throw new UnexpectedExceptionCommandException(false, e);
        }
    }

    private ExpressionCommands() {
    }
}

