/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jem.internal.temp;

import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class VETimerTests {
    public static VETimerTests basicTest = new VETimerTests();
    public static final String CURRENT_PARENT_ID = "current parent";
    protected String currentParentId = null;
    protected boolean testOn = false;
    protected List steps;

    public synchronized boolean startStep(String id) {
        if (!this.testOn) {
            return true;
        }
        TimerStep step = this.createTimerStep(id, 0);
        return step != null;
    }

    protected TimerStep createTimerStep(String id, int stepType) {
        TimerStep newStep = new TimerStep();
        newStep.threadId = Thread.currentThread().hashCode();
        newStep.id = id;
        newStep.type = stepType;
        newStep.currentTime = System.currentTimeMillis();
        this.steps.add(newStep);
        return newStep;
    }

    public synchronized boolean stopStep(String id) {
        if (!this.testOn) {
            return true;
        }
        TimerStep step = this.createTimerStep(id, 1);
        return step != null;
    }

    public synchronized boolean startAccumulating(String id) {
        if (!this.testOn) {
            return true;
        }
        return this.createTimerStep(id, 4) != null;
    }

    public synchronized boolean stopAccumulating(String id) {
        if (!this.testOn) {
            return true;
        }
        return this.createTimerStep(id, 5) != null;
    }

    public synchronized boolean startCumulativeStep(String id) {
        if (!this.testOn) {
            return true;
        }
        return this.createTimerStep(id, 2) != null;
    }

    public synchronized boolean stopCumulativeStep(String id) {
        if (!this.testOn) {
            return true;
        }
        return this.createTimerStep(id, 3) != null;
    }

    public synchronized void clearTests() {
        if (!this.testOn) {
            return;
        }
        this.steps.clear();
        this.currentParentId = null;
    }

    public synchronized void testState(boolean on) {
        if (on == this.testOn) {
            return;
        }
        if (on) {
            this.testOn = true;
            if (this.steps == null) {
                this.steps = new ArrayList();
            }
        } else {
            this.testOn = false;
            this.steps = null;
        }
        this.currentParentId = null;
    }

    public synchronized void printIt() {
        if (!this.testOn) {
            return;
        }
        if (this.steps == null) {
            return;
        }
        HashMap<Integer, HashMap<String, Object>> stepInfoByThreadId = new HashMap<Integer, HashMap<String, Object>>();
        HashMap<Integer, Integer> indentsByThreadId = new HashMap<Integer, Integer>();
        TimerStep prevStep = null;
        NumberFormat percentFormatter = NumberFormat.getPercentInstance();
        double totalTime = 0.0;
        StringBuffer strb = new StringBuffer(150);
        if (this.steps.size() > 2) {
            totalTime = ((TimerStep)this.steps.get((int)(this.steps.size() - 1))).currentTime - ((TimerStep)this.steps.get((int)0)).currentTime;
        }
        int i = 0;
        while (i < this.steps.size()) {
            TimerStep step = (TimerStep)this.steps.get(i);
            Integer threadId = new Integer(step.threadId);
            switch (step.type) {
                case 0: 
                case 1: {
                    Integer threadIndent = (Integer)indentsByThreadId.get(threadId);
                    int indent = 0;
                    if (step.type == 0) {
                        if (threadIndent != null) {
                            indent = threadIndent + 1;
                        }
                        indentsByThreadId.put(threadId, new Integer(indent));
                    } else {
                        if (threadIndent != null) {
                            indent = threadIndent;
                        }
                        if (indent > 0) {
                            indentsByThreadId.put(threadId, new Integer(indent - 1));
                        } else {
                            indentsByThreadId.remove(threadId);
                            indent = 0;
                        }
                    }
                    strb.setLength(0);
                    strb.append(step.currentTime);
                    strb.append("\t");
                    int j = 0;
                    while (j < indent) {
                        strb.append("     ");
                        ++j;
                    }
                    switch (step.type) {
                        case 0: {
                            strb.append("Start");
                            break;
                        }
                        case 1: {
                            strb.append("Stop ");
                            break;
                        }
                    }
                    strb.append(" \"");
                    strb.append(step.id);
                    strb.append("\"   id(");
                    strb.append(step.threadId);
                    strb.append(")");
                    HashMap<String, TimerStep> startSteps = (HashMap<String, TimerStep>)stepInfoByThreadId.get(threadId);
                    if (startSteps == null) {
                        startSteps = new HashMap<String, TimerStep>();
                        stepInfoByThreadId.put(threadId, startSteps);
                    }
                    if (step.type == 0) {
                        startSteps.put(step.id, step);
                    } else {
                        Object item = startSteps.remove(step.id);
                        if (item instanceof TimerStep) {
                            TimerStep startStep = (TimerStep)item;
                            if (startStep != null) {
                                int addchars = 100 - strb.length();
                                int j2 = 0;
                                while (j2 < addchars) {
                                    strb.append(" ");
                                    ++j2;
                                }
                                long delta = step.currentTime - startStep.currentTime;
                                strb.append("    Total = " + delta + " ms");
                                if (totalTime > 0.0) {
                                    strb.append("   " + percentFormatter.format((double)delta / totalTime));
                                }
                            }
                        } else {
                            strb.append("    ---> Couldn't find Starting point for \"" + step.id + "\"");
                        }
                    }
                    if (i > 0 && step.currentTime - prevStep.currentTime > 0L) {
                        System.out.println("-- " + (step.currentTime - prevStep.currentTime) + " ms --");
                    }
                    prevStep = step;
                    System.out.println(strb);
                    break;
                }
                case 4: {
                    Map cumSteps = (HashMap<String, CumulativeInformation>)stepInfoByThreadId.get(threadId);
                    if (cumSteps == null) {
                        cumSteps = new HashMap<String, CumulativeInformation>();
                        stepInfoByThreadId.put(threadId, (HashMap<String, Object>)cumSteps);
                    }
                    cumSteps.put(step.id, new CumulativeInformation());
                    Integer threadIndent = (Integer)indentsByThreadId.get(threadId);
                    int indent = 0;
                    if (threadIndent != null) {
                        indent = threadIndent;
                    }
                    strb.setLength(0);
                    strb.append(step.currentTime);
                    strb.append("\t");
                    int j = 0;
                    while (j < indent) {
                        strb.append("     ");
                        ++j;
                    }
                    strb.append("Start Accumulating");
                    strb.append(" \"");
                    strb.append(step.id);
                    strb.append("\"   id(");
                    strb.append(step.threadId);
                    strb.append(")");
                    if (i > 0 && step.currentTime - prevStep.currentTime > 0L) {
                        System.out.println("-- " + (step.currentTime - prevStep.currentTime) + " ms --");
                    }
                    prevStep = step;
                    System.out.println(strb);
                    break;
                }
                case 2: {
                    Object info;
                    Map cumSteps = (Map)stepInfoByThreadId.get(threadId);
                    if (cumSteps == null || !((info = cumSteps.get(step.id)) instanceof CumulativeInformation)) break;
                    ((CumulativeInformation)info).currentCumulativeStep = step;
                    break;
                }
                case 3: {
                    Object info;
                    Map cumSteps = (Map)stepInfoByThreadId.get(threadId);
                    if (cumSteps == null || !((info = cumSteps.get(step.id)) instanceof CumulativeInformation)) break;
                    CumulativeInformation cumInfo = (CumulativeInformation)info;
                    if (cumInfo.currentCumulativeStep == null) break;
                    ++cumInfo.cumCount;
                    long delta = step.currentTime - cumInfo.currentCumulativeStep.currentTime;
                    cumInfo.cumTime += delta;
                    if (cumInfo.maxTime < delta) {
                        cumInfo.maxTime = delta;
                    }
                    if (delta >= cumInfo.minTime) break;
                    cumInfo.minTime = delta;
                    break;
                }
                case 5: {
                    Object info;
                    Integer threadIndent = (Integer)indentsByThreadId.get(threadId);
                    int indent = 0;
                    if (threadIndent != null) {
                        indent = threadIndent;
                    }
                    strb.setLength(0);
                    strb.append(step.currentTime);
                    strb.append("\t");
                    int j = 0;
                    while (j < indent) {
                        strb.append("     ");
                        ++j;
                    }
                    strb.append("Stop  Accumulating");
                    strb.append(" \"");
                    strb.append(step.id);
                    strb.append("\"   id(");
                    strb.append(step.threadId);
                    strb.append(")");
                    Map cumSteps = (Map)stepInfoByThreadId.get(threadId);
                    if (cumSteps != null && (info = cumSteps.get(step.id)) instanceof CumulativeInformation) {
                        CumulativeInformation cumInfo = (CumulativeInformation)info;
                        if (cumInfo.currentCumulativeStep != null) {
                            strb.append("   cumulative time=");
                            strb.append(cumInfo.cumTime);
                            strb.append("   cumulative count=");
                            strb.append(cumInfo.cumCount);
                            strb.append("   max time=");
                            strb.append(cumInfo.maxTime);
                            strb.append("   min time=");
                            strb.append(cumInfo.minTime);
                            strb.append("   avg time=");
                            Double cumT = new Double(cumInfo.cumTime);
                            Double cumC = new Double(cumInfo.cumCount);
                            strb.append(cumT / cumC);
                        }
                    }
                    if (i > 0 && step.currentTime - prevStep.currentTime > 0L) {
                        System.out.println("-- " + (step.currentTime - prevStep.currentTime) + " ms --");
                    }
                    prevStep = step;
                    System.out.println(strb);
                }
            }
            ++i;
        }
    }

    protected static class TimerStep {
        static final int START = 0;
        static final int STOP = 1;
        static final int START_CUMULATIVE = 2;
        static final int STOP_CUMULATIVE = 3;
        static final int START_ACCUMULATING = 4;
        static final int STOP_ACCUMULATING = 5;
        protected String id;
        protected int type;
        protected long currentTime;
        protected int threadId;

        protected TimerStep() {
        }
    }

    private static class CumulativeInformation {
        public TimerStep currentCumulativeStep;
        public long cumTime;
        public int cumCount;
        public long maxTime;
        public long minTime = Integer.MAX_VALUE;

        CumulativeInformation() {
        }
    }
}

