/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.cde.core;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.FigureListener;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.editparts.LayerManager;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ve.internal.cde.core.DistributeFigure;
import org.eclipse.ve.internal.cde.core.DistributeHandle;
import org.eclipse.ve.internal.cde.core.EditDomain;

public class DistributeController
implements ISelectionChangedListener,
FigureListener {
    public static final String DISTRIBUTE_KEY = "org.eclipse.ve.internal.cde.core.distributekey";
    protected GraphicalViewer viewer;
    protected List handles;
    protected Rectangle boundaryBox = new Rectangle();
    protected DistributeFigure distributeFigure = new DistributeFigure();
    protected boolean active = false;
    protected boolean boxVisible = false;
    protected List childFigures = new ArrayList();
    private boolean revalidateWaiting = false;
    static /* synthetic */ Class class$0;

    public static DistributeController getDistributeController(IWorkbenchPart activePart) {
        EditPartViewer viewer;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.gef.EditPartViewer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((viewer = (EditPartViewer)activePart.getAdapter((Class)clazz)) != null) {
            EditDomain dom = (EditDomain)viewer.getEditDomain();
            return dom != null ? (DistributeController)dom.getViewerData(viewer, DISTRIBUTE_KEY) : null;
        }
        return null;
    }

    public static DistributeController getDistributeController(EditPart editPart) {
        EditPartViewer viewer = editPart.getRoot().getViewer();
        EditDomain dom = (EditDomain)viewer.getEditDomain();
        return (DistributeController)dom.getViewerData(viewer, DISTRIBUTE_KEY);
    }

    public DistributeController(GraphicalViewer viewer) {
        this.viewer = viewer;
    }

    public void setBoxVisible(boolean visible) {
        this.boxVisible = visible;
        if (visible) {
            this.revalidate();
            this.viewer.addSelectionChangedListener((ISelectionChangedListener)this);
        } else {
            this.viewer.removeSelectionChangedListener((ISelectionChangedListener)this);
            this.deactivate();
        }
    }

    protected void createSelectionHandles() {
        if (this.handles == null) {
            this.handles = new ArrayList(8);
            this.handles.add(new DistributeHandle(this.distributeFigure, 1));
            this.handles.add(new DistributeHandle(this.distributeFigure, 9));
            this.handles.add(new DistributeHandle(this.distributeFigure, 17));
            this.handles.add(new DistributeHandle(this.distributeFigure, 4));
            this.handles.add(new DistributeHandle(this.distributeFigure, 12));
            this.handles.add(new DistributeHandle(this.distributeFigure, 20));
            this.handles.add(new DistributeHandle(this.distributeFigure, 16));
            this.handles.add(new DistributeHandle(this.distributeFigure, 8));
        }
    }

    protected void calculateBoundingBox(List editparts) {
        this.boundaryBox = new Rectangle(((GraphicalEditPart)editparts.get(0)).getFigure().getBounds());
        int i = 1;
        while (i < editparts.size()) {
            this.boundaryBox.union(((GraphicalEditPart)editparts.get(i)).getFigure().getBounds());
            ++i;
        }
        this.distributeFigure.setBoundingBox(this.boundaryBox);
    }

    public boolean isBoxActive() {
        return this.active;
    }

    public boolean isBoxVisible() {
        return this.boxVisible;
    }

    public Rectangle getBoundaryBox() {
        return this.boundaryBox.getCopy();
    }

    public void activate() {
        if (this.active || !this.boxVisible) {
            return;
        }
        List editparts = this.viewer.getSelectedEditParts();
        if (editparts.size() > 1) {
            this.active = true;
            this.calculateBoundingBox(editparts);
            IFigure layerFigure = ((LayerManager)this.viewer.getEditPartRegistry().get(LayerManager.ID)).getLayer((Object)"Handle Layer");
            layerFigure.add((IFigure)this.distributeFigure);
            this.distributeFigure.addFigureListener(this);
            this.createSelectionHandles();
            int i = 0;
            while (i < this.handles.size()) {
                layerFigure.add((IFigure)this.handles.get(i));
                ++i;
            }
            this.childFigures.clear();
            i = 0;
            while (i < editparts.size()) {
                IFigure childF = ((GraphicalEditPart)editparts.get(i)).getFigure();
                this.childFigures.add(childF);
                childF.addFigureListener((FigureListener)this);
                ++i;
            }
        }
    }

    public void deactivate() {
        if (!this.active) {
            return;
        }
        this.active = false;
        IFigure layerFigure = ((LayerManager)this.viewer.getEditPartRegistry().get(LayerManager.ID)).getLayer((Object)"Handle Layer");
        this.distributeFigure.removeFigureListener(this);
        layerFigure.remove((IFigure)this.distributeFigure);
        int i = 0;
        while (i < this.handles.size()) {
            layerFigure.remove((IFigure)this.handles.get(i));
            ++i;
        }
        i = 0;
        while (i < this.childFigures.size()) {
            IFigure childF = (IFigure)this.childFigures.get(i);
            childF.removeFigureListener((FigureListener)this);
            ++i;
        }
        this.childFigures.clear();
    }

    public void revalidate() {
        this.deactivate();
        this.activate();
    }

    public void figureMoved(IFigure source) {
        if (source == this.distributeFigure) {
            this.boundaryBox = source.getBounds();
        } else {
            this.queueRevalidate();
        }
    }

    protected void queueRevalidate() {
        this.revalidateWaiting = true;
        Display.getCurrent().asyncExec(new Runnable(){

            public void run() {
                if (DistributeController.this.revalidateWaiting) {
                    DistributeController.this.revalidateWaiting = false;
                    DistributeController.this.revalidate();
                }
            }
        });
    }

    public void selectionChanged(SelectionChangedEvent event) {
        if (!this.boxVisible) {
            return;
        }
        if (this.active) {
            this.revalidate();
        } else if (!event.getSelection().isEmpty()) {
            this.activate();
        } else {
            this.deactivate();
        }
    }
}

